/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

final class CloseableURLConnection
extends URLConnection
implements AutoCloseable {
    private final URLConnection urlConnection;

    static CloseableURLConnection open(URI uRI) {
        return CloseableURLConnection.open(Objects.requireNonNull(uRI, "uri").toURL());
    }

    static CloseableURLConnection open(URL uRL) {
        return new CloseableURLConnection(uRL.openConnection());
    }

    CloseableURLConnection(URLConnection uRLConnection) {
        super(Objects.requireNonNull(uRLConnection, "urlConnection").getURL());
        this.urlConnection = uRLConnection;
    }

    @Override
    public void addRequestProperty(String string, String string2) {
        this.urlConnection.addRequestProperty(string, string2);
    }

    @Override
    public void close() {
        IOUtils.close(this.urlConnection);
    }

    @Override
    public void connect() {
        this.urlConnection.connect();
    }

    public boolean equals(Object object) {
        return this.urlConnection.equals(object);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.urlConnection.getAllowUserInteraction();
    }

    @Override
    public int getConnectTimeout() {
        return this.urlConnection.getConnectTimeout();
    }

    @Override
    public Object getContent() {
        return this.urlConnection.getContent();
    }

    public Object getContent(Class[] classArray) {
        return this.urlConnection.getContent(classArray);
    }

    @Override
    public String getContentEncoding() {
        return this.urlConnection.getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.urlConnection.getContentLength();
    }

    @Override
    public long getContentLengthLong() {
        return this.urlConnection.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return this.urlConnection.getContentType();
    }

    @Override
    public long getDate() {
        return this.urlConnection.getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.urlConnection.getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return this.urlConnection.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this.urlConnection.getDoOutput();
    }

    @Override
    public long getExpiration() {
        return this.urlConnection.getExpiration();
    }

    @Override
    public String getHeaderField(int n2) {
        return this.urlConnection.getHeaderField(n2);
    }

    @Override
    public String getHeaderField(String string) {
        return this.urlConnection.getHeaderField(string);
    }

    @Override
    public long getHeaderFieldDate(String string, long l2) {
        return this.urlConnection.getHeaderFieldDate(string, l2);
    }

    @Override
    public int getHeaderFieldInt(String string, int n2) {
        return this.urlConnection.getHeaderFieldInt(string, n2);
    }

    @Override
    public String getHeaderFieldKey(int n2) {
        return this.urlConnection.getHeaderFieldKey(n2);
    }

    @Override
    public long getHeaderFieldLong(String string, long l2) {
        return this.urlConnection.getHeaderFieldLong(string, l2);
    }

    public Map getHeaderFields() {
        return this.urlConnection.getHeaderFields();
    }

    @Override
    public long getIfModifiedSince() {
        return this.urlConnection.getIfModifiedSince();
    }

    @Override
    public InputStream getInputStream() {
        return this.urlConnection.getInputStream();
    }

    @Override
    public long getLastModified() {
        return this.urlConnection.getLastModified();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.urlConnection.getOutputStream();
    }

    @Override
    public Permission getPermission() {
        return this.urlConnection.getPermission();
    }

    @Override
    public int getReadTimeout() {
        return this.urlConnection.getReadTimeout();
    }

    public Map getRequestProperties() {
        return this.urlConnection.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String string) {
        return this.urlConnection.getRequestProperty(string);
    }

    @Override
    public URL getURL() {
        return this.urlConnection.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this.urlConnection.getUseCaches();
    }

    public int hashCode() {
        return this.urlConnection.hashCode();
    }

    @Override
    public void setAllowUserInteraction(boolean bl2) {
        this.urlConnection.setAllowUserInteraction(bl2);
    }

    @Override
    public void setConnectTimeout(int n2) {
        this.urlConnection.setConnectTimeout(n2);
    }

    @Override
    public void setDefaultUseCaches(boolean bl2) {
        this.urlConnection.setDefaultUseCaches(bl2);
    }

    @Override
    public void setDoInput(boolean bl2) {
        this.urlConnection.setDoInput(bl2);
    }

    @Override
    public void setDoOutput(boolean bl2) {
        this.urlConnection.setDoOutput(bl2);
    }

    @Override
    public void setIfModifiedSince(long l2) {
        this.urlConnection.setIfModifiedSince(l2);
    }

    @Override
    public void setReadTimeout(int n2) {
        this.urlConnection.setReadTimeout(n2);
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        this.urlConnection.setRequestProperty(string, string2);
    }

    @Override
    public void setUseCaches(boolean bl2) {
        this.urlConnection.setUseCaches(bl2);
    }

    @Override
    public String toString() {
        return this.urlConnection.toString();
    }
}

