/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayOutputStream;

final class RFC2231Utils {
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final byte MASK = 127;
    private static final int MASK_128 = 128;
    private static final byte[] HEX_DECODE = new byte[128];

    static String decodeText(String string) {
        int n2 = string.indexOf(39);
        if (n2 == -1) {
            return string;
        }
        String string2 = string.substring(0, n2);
        int n3 = string.indexOf(39, n2 + 1);
        if (n3 == -1) {
            return string;
        }
        byte[] byArray = RFC2231Utils.fromHex(string.substring(n3 + 1));
        return new String(byArray, RFC2231Utils.getJavaCharset(string2));
    }

    private static byte[] fromHex(String string) {
        int n2 = 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        int n3 = 0;
        while (n3 < string.length()) {
            char c2;
            if ((c2 = string.charAt(n3++)) == '%') {
                if (n3 > string.length() - 2) break;
                byte by = HEX_DECODE[string.charAt(n3++) & 0x7F];
                byte by2 = HEX_DECODE[string.charAt(n3++) & 0x7F];
                byteArrayOutputStream.write(by << 4 | by2);
                continue;
            }
            byteArrayOutputStream.write((byte)c2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static String getJavaCharset(String string) {
        return string;
    }

    static boolean hasEncodedValue(String string) {
        if (string != null) {
            return string.lastIndexOf(42) == string.length() - 1;
        }
        return false;
    }

    static String stripDelimiter(String string) {
        if (RFC2231Utils.hasEncodedValue(string)) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.deleteCharAt(string.lastIndexOf(42));
            return stringBuilder.toString();
        }
        return string;
    }

    private RFC2231Utils() {
    }

    static {
        for (int i2 = 0; i2 < HEX_DIGITS.length; ++i2) {
            RFC2231Utils.HEX_DECODE[RFC2231Utils.HEX_DIGITS[i2]] = (byte)i2;
            RFC2231Utils.HEX_DECODE[Character.toLowerCase((char)RFC2231Utils.HEX_DIGITS[i2])] = (byte)i2;
        }
    }
}

