/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.IOException;
import java.io.OutputStream;

final class QuotedPrintableDecoder {
    private static final int UPPER_NIBBLE_SHIFT = 4;

    public static int decode(byte[] byArray, OutputStream outputStream) {
        int n2 = 0;
        int n3 = byArray.length;
        int n4 = n2 + n3;
        int n5 = 0;
        while (n2 < n4) {
            byte by;
            if ((by = byArray[n2++]) == 95) {
                outputStream.write(32);
                continue;
            }
            if (by == 61) {
                if (n2 + 1 >= n4) {
                    throw new IOException("Invalid quoted printable encoding; truncated escape sequence");
                }
                byte by2 = byArray[n2++];
                byte by3 = byArray[n2++];
                if (by2 == 13) {
                    if (by3 == 10) continue;
                    throw new IOException("Invalid quoted printable encoding; CR must be followed by LF");
                }
                int n6 = QuotedPrintableDecoder.hexToBinary(by2);
                int n7 = QuotedPrintableDecoder.hexToBinary(by3);
                outputStream.write(n6 << 4 | n7);
                ++n5;
                continue;
            }
            outputStream.write(by);
            ++n5;
        }
        return n5;
    }

    private static int hexToBinary(byte by) {
        int n2 = Character.digit((char)by, 16);
        if (n2 == -1) {
            throw new IOException("Invalid quoted printable encoding: not a valid hex digit: " + by);
        }
        return n2;
    }

    private QuotedPrintableDecoder() {
    }
}

