/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.fileupload2.core.MimeUtils;
import org.apache.commons.fileupload2.core.RFC2231Utils;

public class ParameterParser {
    private char[] chars;
    private int pos;
    private int len;
    private int i1;
    private int i2;
    private boolean lowerCaseNames;

    private String getToken(boolean bl2) {
        while (this.i1 < this.i2 && Character.isWhitespace(this.chars[this.i1])) {
            ++this.i1;
        }
        while (this.i2 > this.i1 && Character.isWhitespace(this.chars[this.i2 - 1])) {
            --this.i2;
        }
        if (bl2 && this.i2 - this.i1 >= 2 && this.chars[this.i1] == '\"' && this.chars[this.i2 - 1] == '\"') {
            ++this.i1;
            --this.i2;
        }
        String string = null;
        if (this.i2 > this.i1) {
            string = new String(this.chars, this.i1, this.i2 - this.i1);
        }
        return string;
    }

    private boolean hasChar() {
        return this.pos < this.len;
    }

    public boolean isLowerCaseNames() {
        return this.lowerCaseNames;
    }

    private boolean isOneOf(char c2, char[] cArray) {
        boolean bl2 = false;
        for (char c3 : cArray) {
            if (c2 != c3) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public Map parse(char[] cArray, char c2) {
        if (cArray == null) {
            return new HashMap();
        }
        return this.parse(cArray, 0, cArray.length, c2);
    }

    public Map parse(char[] cArray, int n2, int n3, char c2) {
        if (cArray == null) {
            return new HashMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.chars = (char[])cArray.clone();
        this.pos = n2;
        this.len = n3;
        while (this.hasChar()) {
            String string = this.parseToken(new char[]{'=', c2});
            String string2 = null;
            if (this.hasChar() && cArray[this.pos] == '=') {
                ++this.pos;
                string2 = this.parseQuotedToken(new char[]{c2});
                if (string2 != null) {
                    try {
                        string2 = RFC2231Utils.hasEncodedValue(string) ? RFC2231Utils.decodeText(string2) : MimeUtils.decodeText(string2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
            if (this.hasChar() && cArray[this.pos] == c2) {
                ++this.pos;
            }
            if (string == null || string.isEmpty()) continue;
            string = RFC2231Utils.stripDelimiter(string);
            if (this.lowerCaseNames) {
                string = string.toLowerCase(Locale.ROOT);
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public Map parse(String string, char c2) {
        if (string == null) {
            return new HashMap();
        }
        return this.parse(string.toCharArray(), c2);
    }

    public Map parse(String string, char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return new HashMap();
        }
        char c2 = cArray[0];
        if (string != null) {
            int n2 = string.length();
            for (char c3 : cArray) {
                int n3 = string.indexOf(c3);
                if (n3 == -1 || n3 >= n2) continue;
                n2 = n3;
                c2 = c3;
            }
        }
        return this.parse(string, c2);
    }

    private String parseQuotedToken(char[] cArray) {
        this.i1 = this.pos;
        this.i2 = this.pos;
        boolean bl2 = false;
        boolean bl3 = false;
        while (this.hasChar()) {
            char c2 = this.chars[this.pos];
            if (!bl2 && this.isOneOf(c2, cArray)) break;
            if (!bl3 && c2 == '\"') {
                bl2 = !bl2;
            }
            bl3 = !bl3 && c2 == '\\';
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(true);
    }

    private String parseToken(char[] cArray) {
        char c2;
        this.i1 = this.pos;
        this.i2 = this.pos;
        while (this.hasChar() && !this.isOneOf(c2 = this.chars[this.pos], cArray)) {
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(false);
    }

    public void setLowerCaseNames(boolean bl2) {
        this.lowerCaseNames = bl2;
    }
}

