/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.core.MultipartInput$Builder;
import org.apache.commons.fileupload2.core.MultipartInput$FileUploadBoundaryException;
import org.apache.commons.fileupload2.core.MultipartInput$ItemInputStream;
import org.apache.commons.fileupload2.core.MultipartInput$MalformedStreamException;
import org.apache.commons.fileupload2.core.MultipartInput$ProgressNotifier;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public final class MultipartInput {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DASH = 45;
    static final int DEFAULT_BUFSIZE = 4096;
    public static final int DEFAULT_PART_HEADER_SIZE_MAX = 512;
    static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    static final byte[] FIELD_SEPARATOR = new byte[]{13, 10};
    static final byte[] STREAM_TERMINATOR = new byte[]{45, 45};
    static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private final InputStream input;
    private int boundaryLength;
    private final int keepRegion;
    private final byte[] boundary;
    private final int[] boundaryTable;
    private final int bufSize;
    private final byte[] buffer;
    private int head;
    private int tail;
    private Charset headerCharset;
    private final MultipartInput$ProgressNotifier notifier;
    private final int partHeaderSizeMax;

    static boolean arrayEquals(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static MultipartInput$Builder builder() {
        return new MultipartInput$Builder();
    }

    private MultipartInput(InputStream inputStream, byte[] byArray, int n2, int n3, MultipartInput$ProgressNotifier progressNotifier) {
        if (byArray == null) {
            throw new IllegalArgumentException("boundary may not be null");
        }
        this.boundaryLength = byArray.length + BOUNDARY_PREFIX.length;
        if (n2 < this.boundaryLength + 1) {
            throw new IllegalArgumentException("The buffer size specified for the MultipartInput is too small");
        }
        this.input = inputStream;
        this.bufSize = Math.max(n2, this.boundaryLength * 2);
        this.buffer = new byte[this.bufSize];
        this.notifier = progressNotifier;
        this.partHeaderSizeMax = n3;
        this.boundary = new byte[this.boundaryLength];
        this.boundaryTable = new int[this.boundaryLength + 1];
        this.keepRegion = this.boundary.length;
        System.arraycopy(BOUNDARY_PREFIX, 0, this.boundary, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(byArray, 0, this.boundary, BOUNDARY_PREFIX.length, byArray.length);
        this.computeBoundaryTable();
        this.head = 0;
        this.tail = 0;
    }

    private void computeBoundaryTable() {
        int n2 = 2;
        int n3 = 0;
        this.boundaryTable[0] = -1;
        this.boundaryTable[1] = 0;
        while (n2 <= this.boundaryLength) {
            if (this.boundary[n2 - 1] == this.boundary[n3]) {
                this.boundaryTable[n2] = n3 + 1;
                ++n3;
                ++n2;
                continue;
            }
            if (n3 > 0) {
                n3 = this.boundaryTable[n3];
                continue;
            }
            this.boundaryTable[n2] = 0;
            ++n2;
        }
    }

    public long discardBodyData() {
        return this.readBodyData(NullOutputStream.INSTANCE);
    }

    protected int findByte(byte by, int n2) {
        for (int i2 = n2; i2 < this.tail; ++i2) {
            if (this.buffer[i2] != by) continue;
            return i2;
        }
        return -1;
    }

    protected int findSeparator() {
        int n2 = 0;
        for (int i2 = this.head; i2 < this.tail; ++i2) {
            while (n2 >= 0 && this.buffer[i2] != this.boundary[n2]) {
                n2 = this.boundaryTable[n2];
            }
            if (++n2 != this.boundaryLength) continue;
            return i2 - this.boundaryLength;
        }
        return -1;
    }

    public Charset getHeaderCharset() {
        return this.headerCharset;
    }

    public int getPartHeaderSizeMax() {
        return this.partHeaderSizeMax;
    }

    public MultipartInput$ItemInputStream newInputStream() {
        return new MultipartInput$ItemInputStream(this);
    }

    public long readBodyData(OutputStream outputStream) {
        try (MultipartInput$ItemInputStream multipartInput$ItemInputStream = this.newInputStream();){
            long l2 = IOUtils.copyLarge(multipartInput$ItemInputStream, outputStream);
            return l2;
        }
    }

    public boolean readBoundary() {
        boolean bl2;
        block6: {
            byte[] byArray = new byte[2];
            this.head += this.boundaryLength;
            try {
                byArray[0] = this.readByte();
                if (byArray[0] == 10) {
                    return true;
                }
                byArray[1] = this.readByte();
                if (MultipartInput.arrayEquals(byArray, STREAM_TERMINATOR, 2)) {
                    bl2 = false;
                    break block6;
                }
                if (MultipartInput.arrayEquals(byArray, FIELD_SEPARATOR, 2)) {
                    bl2 = true;
                    break block6;
                }
                throw new MultipartInput$MalformedStreamException("Unexpected characters follow a boundary");
            }
            catch (FileUploadSizeException fileUploadSizeException) {
                throw fileUploadSizeException;
            }
            catch (IOException iOException) {
                throw new MultipartInput$MalformedStreamException("Stream ended unexpectedly", iOException);
            }
        }
        return bl2;
    }

    public byte readByte() {
        if (this.head == this.tail) {
            this.head = 0;
            this.tail = this.input.read(this.buffer, this.head, this.bufSize);
            if (this.tail == -1) {
                throw new IOException("No more data is available");
            }
            if (this.notifier != null) {
                this.notifier.noteBytesRead(this.tail);
            }
        }
        return this.buffer[this.head++];
    }

    public String readHeaders() {
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while (n2 < HEADER_SEPARATOR.length) {
            byte by;
            try {
                by = this.readByte();
            }
            catch (FileUploadSizeException fileUploadSizeException) {
                throw fileUploadSizeException;
            }
            catch (IOException iOException) {
                throw new MultipartInput$MalformedStreamException("Stream ended unexpectedly", iOException);
            }
            int n4 = this.getPartHeaderSizeMax();
            if (n4 != -1 && ++n3 > n4) {
                throw new FileUploadSizeException(String.format("Header section has more than %s bytes (maybe it is not properly terminated)", n4), n4, n3);
            }
            n2 = by == HEADER_SEPARATOR[n2] ? ++n2 : 0;
            byteArrayOutputStream.write(by);
        }
        try {
            return byteArrayOutputStream.toString(Charsets.toCharset(this.headerCharset, Charset.defaultCharset()).name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public void setBoundary(byte[] byArray) {
        if (byArray.length != this.boundaryLength - BOUNDARY_PREFIX.length) {
            throw new MultipartInput$FileUploadBoundaryException("The length of a boundary token cannot be changed");
        }
        System.arraycopy(byArray, 0, this.boundary, BOUNDARY_PREFIX.length, byArray.length);
        this.computeBoundaryTable();
    }

    public void setHeaderCharset(Charset charset) {
        this.headerCharset = charset;
    }

    public boolean skipPreamble() {
        System.arraycopy(this.boundary, 2, this.boundary, 0, this.boundary.length - 2);
        this.boundaryLength = this.boundary.length - 2;
        this.computeBoundaryTable();
        try {
            this.discardBodyData();
            boolean bl2 = this.readBoundary();
            return bl2;
        }
        catch (MultipartInput$MalformedStreamException multipartInput$MalformedStreamException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            System.arraycopy(this.boundary, 0, this.boundary, 2, this.boundary.length - 2);
            this.boundaryLength = this.boundary.length;
            this.boundary[0] = 13;
            this.boundary[1] = 10;
            this.computeBoundaryTable();
        }
    }
}

