/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.InputStream;
import org.apache.commons.fileupload2.core.FileItemInput$ItemSkippedException;
import org.apache.commons.fileupload2.core.MultipartInput;
import org.apache.commons.fileupload2.core.MultipartInput$MalformedStreamException;

public class MultipartInput$ItemInputStream
extends InputStream {
    private static final int BYTE_POSITIVE_OFFSET = 256;
    private long total;
    private int pad;
    private int pos;
    private boolean closed;
    final /* synthetic */ MultipartInput this$0;

    MultipartInput$ItemInputStream(MultipartInput multipartInput) {
        this.this$0 = multipartInput;
        this.findSeparator();
    }

    @Override
    public int available() {
        if (this.pos == -1) {
            return this.this$0.tail - this.this$0.head - this.pad;
        }
        return this.pos - this.this$0.head;
    }

    private void checkOpen() {
        if (this.closed) {
            throw new FileItemInput$ItemSkippedException("checkOpen()");
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void close(boolean bl2) {
        if (this.closed) {
            return;
        }
        if (bl2) {
            this.closed = true;
            this.this$0.input.close();
        } else {
            int n2;
            while ((n2 = this.available()) != 0 || (n2 = this.makeAvailable()) != 0) {
                if (this.skip(n2) == (long)n2) continue;
            }
        }
        this.closed = true;
    }

    private void findSeparator() {
        this.pos = this.this$0.findSeparator();
        if (this.pos == -1) {
            this.pad = this.this$0.tail - this.this$0.head > this.this$0.keepRegion ? this.this$0.keepRegion : this.this$0.tail - this.this$0.head;
        }
    }

    public long getBytesRead() {
        return this.total;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private int makeAvailable() {
        int n2;
        if (this.pos != -1) {
            return 0;
        }
        this.total += (long)(this.this$0.tail - this.this$0.head - this.pad);
        System.arraycopy(this.this$0.buffer, this.this$0.tail - this.pad, this.this$0.buffer, 0, this.pad);
        this.this$0.head = 0;
        this.this$0.tail = this.pad;
        do {
            int n3;
            if ((n3 = this.this$0.input.read(this.this$0.buffer, this.this$0.tail, this.this$0.bufSize - this.this$0.tail)) == -1) {
                String string = "Stream ended unexpectedly";
                throw new MultipartInput$MalformedStreamException("Stream ended unexpectedly");
            }
            if (this.this$0.notifier != null) {
                this.this$0.notifier.noteBytesRead(n3);
            }
            this.this$0.tail += n3;
            this.findSeparator();
        } while ((n2 = this.available()) <= 0 && this.pos == -1);
        return n2;
    }

    @Override
    public int read() {
        byte by;
        this.checkOpen();
        if (this.available() == 0 && this.makeAvailable() == 0) {
            return -1;
        }
        ++this.total;
        if ((by = this.this$0.buffer[this.this$0.head++]) >= 0) {
            return by;
        }
        return by + 256;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        this.checkOpen();
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.available();
        if (n4 == 0 && (n4 = this.makeAvailable()) == 0) {
            return -1;
        }
        n4 = Math.min(n4, n3);
        System.arraycopy(this.this$0.buffer, this.this$0.head, byArray, n2, n4);
        this.this$0.head += n4;
        this.total += (long)n4;
        return n4;
    }

    @Override
    public long skip(long l2) {
        this.checkOpen();
        int n2 = this.available();
        if (n2 == 0 && (n2 = this.makeAvailable()) == 0) {
            return 0L;
        }
        int n3 = Math.toIntExact(Math.min((long)n2, l2));
        this.this$0.head += n3;
        return n3;
    }
}

