/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.fileupload2.core.QuotedPrintableDecoder;

final class MimeUtils {
    private static final String BASE64_ENCODING_MARKER = "B";
    private static final String QUOTEDPRINTABLE_ENCODING_MARKER = "Q";
    private static final String ENCODED_TOKEN_MARKER = "=?";
    private static final String ENCODED_TOKEN_FINISHER = "?=";
    private static final String LINEAR_WHITESPACE = " \t\r\n";
    private static final Map MIME2JAVA = new HashMap();

    static String decodeText(String string) {
        if (!string.contains(ENCODED_TOKEN_MARKER)) {
            return string;
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = -1;
        int n5 = -1;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl2 = false;
        block2: while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (LINEAR_WHITESPACE.indexOf(c2) != -1) {
                n4 = n2;
                while (n2 < n3) {
                    c2 = string.charAt(n2);
                    if (LINEAR_WHITESPACE.indexOf(c2) == -1) {
                        n5 = n2;
                        continue block2;
                    }
                    ++n2;
                }
                continue;
            }
            int n6 = n2;
            while (n2 < n3 && LINEAR_WHITESPACE.indexOf(c2 = string.charAt(n2)) == -1) {
                ++n2;
            }
            String string2 = string.substring(n6, n2);
            if (string2.startsWith(ENCODED_TOKEN_MARKER)) {
                try {
                    String string3 = MimeUtils.decodeWord(string2);
                    if (!bl2 && n4 != -1) {
                        stringBuilder.append(string, n4, n5);
                        n4 = -1;
                    }
                    bl2 = true;
                    stringBuilder.append(string3);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (n4 != -1) {
                stringBuilder.append(string, n4, n5);
                n4 = -1;
            }
            bl2 = false;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static String decodeWord(String string) {
        int n2 = string.indexOf(ENCODED_TOKEN_MARKER);
        if (n2 != 0) {
            throw new ParseException("Invalid RFC 2047 encoded-word: " + string, n2);
        }
        int n3 = string.indexOf(63, 2);
        if (n3 == -1) {
            throw new ParseException("Missing charset in RFC 2047 encoded-word: " + string, n3);
        }
        String string2 = string.substring(2, n3).toLowerCase(Locale.ROOT);
        int n4 = string.indexOf(63, n3 + 1);
        if (n4 == -1) {
            throw new ParseException("Missing encoding in RFC 2047 encoded-word: " + string, n4);
        }
        String string3 = string.substring(n3 + 1, n4);
        int n5 = string.indexOf(ENCODED_TOKEN_FINISHER, n4 + 1);
        if (n5 == -1) {
            throw new ParseException("Missing encoded text in RFC 2047 encoded-word: " + string, n5);
        }
        String string4 = string.substring(n4 + 1, n5);
        if (string4.isEmpty()) {
            return "";
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string4.length());
            byte[] byArray = string4.getBytes(StandardCharsets.US_ASCII);
            if (string3.equals(BASE64_ENCODING_MARKER)) {
                byteArrayOutputStream.write(Base64.getMimeDecoder().decode(byArray));
            } else if (string3.equals(QUOTEDPRINTABLE_ENCODING_MARKER)) {
                QuotedPrintableDecoder.decode(byArray, byteArrayOutputStream);
            } else {
                throw new UnsupportedEncodingException("Unknown RFC 2047 encoding: " + string3);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return new String(byArray2, MimeUtils.javaCharset(string2));
        }
        catch (IOException iOException) {
            throw new UnsupportedEncodingException("Invalid RFC 2047 encoding");
        }
    }

    private static String javaCharset(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)MIME2JAVA.get(string.toLowerCase(Locale.ROOT));
        return string2 == null ? string : string2;
    }

    private MimeUtils() {
    }

    static {
        MIME2JAVA.put("iso-2022-cn", "ISO2022CN");
        MIME2JAVA.put("iso-2022-kr", "ISO2022KR");
        MIME2JAVA.put("utf-8", "UTF8");
        MIME2JAVA.put("utf8", "UTF8");
        MIME2JAVA.put("ja_jp.iso2022-7", "ISO2022JP");
        MIME2JAVA.put("ja_jp.eucjp", "EUCJIS");
        MIME2JAVA.put("euc-kr", "KSC5601");
        MIME2JAVA.put("euckr", "KSC5601");
        MIME2JAVA.put("us-ascii", StandardCharsets.ISO_8859_1.name());
        MIME2JAVA.put("x-us-ascii", StandardCharsets.ISO_8859_1.name());
    }
}

