/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputImpl;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileUploadContentTypeException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.core.MultipartInput;
import org.apache.commons.fileupload2.core.MultipartInput$Builder;
import org.apache.commons.fileupload2.core.MultipartInput$ProgressNotifier;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.BoundedInputStream$Builder;

class FileItemInputIteratorImpl
implements FileItemInputIterator {
    private final AbstractFileUpload fileUpload;
    private final RequestContext requestContext;
    private long sizeMax;
    private long fileSizeMax;
    private MultipartInput multiPartInput;
    private MultipartInput$ProgressNotifier progressNotifier;
    private byte[] multiPartBoundary;
    private FileItemInputImpl currentItem;
    private String currentFieldName;
    private boolean skipPreamble;
    private boolean itemValid;
    private boolean eof;
    private final boolean multipartRelated;

    FileItemInputIteratorImpl(AbstractFileUpload abstractFileUpload, RequestContext requestContext) {
        this.fileUpload = abstractFileUpload;
        this.sizeMax = abstractFileUpload.getSizeMax();
        this.fileSizeMax = abstractFileUpload.getFileSizeMax();
        this.requestContext = Objects.requireNonNull(requestContext, "requestContext");
        this.multipartRelated = this.requestContext.isMultipartRelated();
        this.skipPreamble = true;
        this.findNextItem();
    }

    private boolean findNextItem() {
        if (this.eof) {
            return false;
        }
        if (this.currentItem != null) {
            this.currentItem.close();
            this.currentItem = null;
        }
        MultipartInput multipartInput = this.getMultiPartInput();
        while (true) {
            String string;
            boolean bl2;
            if (!(bl2 = this.skipPreamble ? multipartInput.skipPreamble() : multipartInput.readBoundary())) {
                if (this.currentFieldName == null) {
                    this.eof = true;
                    return false;
                }
                multipartInput.setBoundary(this.multiPartBoundary);
                this.currentFieldName = null;
                continue;
            }
            FileItemHeaders fileItemHeaders = this.fileUpload.getParsedHeaders(multipartInput.readHeaders());
            if (this.multipartRelated) {
                this.currentFieldName = "";
                this.currentItem = new FileItemInputImpl(this, null, null, fileItemHeaders.getHeader("Content-type"), false, this.getContentLength(fileItemHeaders));
                this.currentItem.setHeaders(fileItemHeaders);
                this.progressNotifier.noteItem();
                this.itemValid = true;
                return true;
            }
            if (this.currentFieldName == null) {
                string = this.fileUpload.getFieldName(fileItemHeaders);
                if (string != null) {
                    Object object;
                    String string2 = fileItemHeaders.getHeader("Content-type");
                    if (string2 != null && string2.toLowerCase(Locale.ROOT).startsWith("multipart/mixed")) {
                        this.currentFieldName = string;
                        object = this.fileUpload.getBoundary(string2);
                        multipartInput.setBoundary((byte[])object);
                        this.skipPreamble = true;
                        continue;
                    }
                    object = this.fileUpload.getFileName(fileItemHeaders);
                    this.currentItem = new FileItemInputImpl(this, (String)object, string, fileItemHeaders.getHeader("Content-type"), object == null, this.getContentLength(fileItemHeaders));
                    this.currentItem.setHeaders(fileItemHeaders);
                    this.progressNotifier.noteItem();
                    this.itemValid = true;
                    return true;
                }
            } else {
                string = this.fileUpload.getFileName(fileItemHeaders);
                if (string != null) {
                    this.currentItem = new FileItemInputImpl(this, string, this.currentFieldName, fileItemHeaders.getHeader("Content-type"), false, this.getContentLength(fileItemHeaders));
                    this.currentItem.setHeaders(fileItemHeaders);
                    this.progressNotifier.noteItem();
                    this.itemValid = true;
                    return true;
                }
            }
            multipartInput.discardBodyData();
        }
    }

    private long getContentLength(FileItemHeaders fileItemHeaders) {
        try {
            return Long.parseLong(fileItemHeaders.getHeader("Content-length"));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @Override
    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public MultipartInput getMultiPartInput() {
        if (this.multiPartInput == null) {
            this.init(this.fileUpload, this.requestContext);
        }
        return this.multiPartInput;
    }

    @Override
    public long getSizeMax() {
        return this.sizeMax;
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        if (this.itemValid) {
            return true;
        }
        return this.findNextItem();
    }

    protected void init(AbstractFileUpload abstractFileUpload, RequestContext requestContext) {
        InputStream inputStream;
        long l4;
        String string = this.requestContext.getContentType();
        if (null == string || !string.toLowerCase(Locale.ROOT).startsWith("multipart/")) {
            throw new FileUploadContentTypeException(String.format("the request doesn't contain a %s or %s stream, content type header is %s", "multipart/form-data", "multipart/mixed", string), string);
        }
        long l5 = this.requestContext.getContentLength();
        long l6 = l4 = RequestContext.class.isAssignableFrom(this.requestContext.getClass()) ? this.requestContext.getContentLength() : l5;
        if (this.sizeMax >= 0L) {
            if (l4 != -1L && l4 > this.sizeMax) {
                throw new FileUploadSizeException(String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", l4, this.sizeMax), this.sizeMax, l4);
            }
            inputStream = ((BoundedInputStream$Builder)((BoundedInputStream$Builder)((BoundedInputStream$Builder)BoundedInputStream.builder().setInputStream(this.requestContext.getInputStream())).setMaxCount(this.sizeMax)).setOnMaxCount((l2, l3) -> {
                throw new FileUploadSizeException(String.format("The request was rejected because its size (%s) exceeds the configured maximum (%s)", l3, l2), (long)l2, (long)l3);
            })).get();
        } else {
            inputStream = this.requestContext.getInputStream();
        }
        Charset charset = Charsets.toCharset(abstractFileUpload.getHeaderCharset(), this.requestContext.getCharset());
        this.multiPartBoundary = abstractFileUpload.getBoundary(string);
        if (this.multiPartBoundary == null) {
            IOUtils.closeQuietly(inputStream);
            throw new FileUploadException("the request was rejected because no multipart boundary was found");
        }
        this.progressNotifier = new MultipartInput$ProgressNotifier(abstractFileUpload.getProgressListener(), l4);
        try {
            this.multiPartInput = ((MultipartInput$Builder)MultipartInput.builder().setInputStream(inputStream)).setBoundary(this.multiPartBoundary).setProgressNotifier(this.progressNotifier).get();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOUtils.closeQuietly(inputStream);
            throw new FileUploadContentTypeException(String.format("The boundary specified in the %s header is too long", "Content-type"), illegalArgumentException);
        }
        this.multiPartInput.setHeaderCharset(charset);
    }

    @Override
    public FileItemInput next() {
        if (this.eof || !this.itemValid && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.itemValid = false;
        return this.currentItem;
    }

    @Override
    public void setFileSizeMax(long l2) {
        this.fileSizeMax = l2;
    }

    @Override
    public void setSizeMax(long l2) {
        this.sizeMax = l2;
    }

    @Override
    public Iterator unwrap() {
        return (Iterator)((Object)this);
    }
}

