/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.InputStream;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInput$ItemSkippedException;
import org.apache.commons.fileupload2.core.FileItemInputIteratorImpl;
import org.apache.commons.fileupload2.core.FileUploadByteCountLimitException;
import org.apache.commons.fileupload2.core.MultipartInput$ItemInputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.BoundedInputStream$Builder;

class FileItemInputImpl
implements FileItemInput {
    private final FileItemInputIteratorImpl fileItemInputIteratorImpl;
    private final String contentType;
    private final String fieldName;
    private final String fileName;
    private final boolean formField;
    private final InputStream inputStream;
    private boolean inputStreamClosed;
    private FileItemHeaders headers;

    FileItemInputImpl(FileItemInputIteratorImpl fileItemInputIteratorImpl, String string, String string2, String string3, boolean bl2, long l2) {
        MultipartInput$ItemInputStream multipartInput$ItemInputStream;
        this.fileItemInputIteratorImpl = fileItemInputIteratorImpl;
        this.fileName = string;
        this.fieldName = string2;
        this.contentType = string3;
        this.formField = bl2;
        long l5 = this.fileItemInputIteratorImpl.getFileSizeMax();
        if (l5 != -1L && l2 != -1L && l2 > l5) {
            throw new FileUploadByteCountLimitException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", string2, l5), l2, l5, string, string2);
        }
        InputStream inputStream = multipartInput$ItemInputStream = this.fileItemInputIteratorImpl.getMultiPartInput().newInputStream();
        if (l5 != -1L) {
            inputStream = ((BoundedInputStream$Builder)((BoundedInputStream$Builder)((BoundedInputStream$Builder)BoundedInputStream.builder().setInputStream(inputStream)).setMaxCount(l5 + 1L)).setOnMaxCount((l3, l4) -> {
                multipartInput$ItemInputStream.close(true);
                throw new FileUploadByteCountLimitException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", string2, l5), (long)l4, l5, string, string2);
            })).get();
        }
        this.inputStream = inputStream;
    }

    public void close() {
        this.inputStream.close();
        this.inputStreamClosed = true;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getInputStream() {
        if (this.inputStreamClosed) {
            throw new FileItemInput$ItemSkippedException("getInputStream()");
        }
        return this.inputStream;
    }

    @Override
    public String getName() {
        return DiskFileItem.checkFileName(this.fileName);
    }

    @Override
    public boolean isFormField() {
        return this.formField;
    }

    @Override
    public FileItemInputImpl setHeaders(FileItemHeaders fileItemHeaders) {
        this.headers = fileItemHeaders;
        return this;
    }
}

