/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.fileupload2.core.FileItemHeaders;

class FileItemHeadersImpl
implements FileItemHeaders {
    private final Map headerNameToValueListMap = new LinkedHashMap();

    FileItemHeadersImpl() {
    }

    @Override
    public synchronized void addHeader(String string2, String string3) {
        this.headerNameToValueListMap.computeIfAbsent(this.toLowerCase(string2), string -> new ArrayList()).add(string3);
    }

    @Override
    public String getHeader(String string) {
        List list = this.getList(string);
        if (null == list) {
            return null;
        }
        return (String)list.get(0);
    }

    @Override
    public Iterator getHeaderNames() {
        return this.headerNameToValueListMap.keySet().iterator();
    }

    @Override
    public Iterator getHeaders(String string) {
        List list = this.getList(string);
        if (null == list) {
            list = Collections.emptyList();
        }
        return list.iterator();
    }

    private List getList(String string) {
        return (List)this.headerNameToValueListMap.get(this.toLowerCase(string));
    }

    private String toLowerCase(String string) {
        return string.toLowerCase(Locale.ROOT);
    }
}

