/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.fileupload2.core.DiskFileItem$Builder;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.ParameterParser;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;

public final class DiskFileItem
implements FileItem {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final String UID = UUID.randomUUID().toString().replace('-', '_');
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private String fieldName;
    private final String contentType;
    private volatile boolean isFormField;
    private final String fileName;
    private volatile long size = -1L;
    private final int threshold;
    private final Path repository;
    private byte[] cachedContent;
    private DeferredFileOutputStream dfos;
    private final Path tempFile;
    private FileItemHeaders fileItemHeaders;
    private Charset charsetDefault = DEFAULT_CHARSET;

    public static DiskFileItem$Builder builder() {
        return new DiskFileItem$Builder();
    }

    public static String checkFileName(String string) {
        if (string != null) {
            int n2 = string.indexOf(0);
            if (n2 != -1) {
                StringBuilder stringBuilder = new StringBuilder();
                block3: for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c2 = string.charAt(i2);
                    switch (c2) {
                        case '\u0000': {
                            stringBuilder.append("\\0");
                            continue block3;
                        }
                        default: {
                            stringBuilder.append(c2);
                        }
                    }
                }
                throw new InvalidPathException(string, stringBuilder.toString(), n2);
            }
            Paths.get(string, new String[0]);
        }
        return string;
    }

    private static String getUniqueId() {
        int n2 = 100000000;
        int n3 = COUNTER.getAndIncrement();
        String string = Integer.toString(n3);
        if (n3 < 100000000) {
            string = ("00000000" + string).substring(string.length());
        }
        return string;
    }

    private DiskFileItem(String string, String string2, boolean bl2, String string3, int n2, Path path, FileItemHeaders fileItemHeaders, Charset charset) {
        this.fieldName = string;
        this.contentType = string2;
        this.charsetDefault = charset;
        this.isFormField = bl2;
        this.fileName = string3;
        this.fileItemHeaders = fileItemHeaders;
        this.threshold = n2;
        this.repository = path != null ? path : PathUtils.getTempDirectory();
        this.tempFile = this.repository.resolve(String.format("upload_%s_%s.tmp", UID, DiskFileItem.getUniqueId()));
    }

    @Override
    public DiskFileItem delete() {
        this.cachedContent = null;
        Path path = this.getPath();
        if (path != null && !this.isInMemory() && Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        return this;
    }

    @Override
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.cachedContent == null && this.dfos != null) {
                this.cachedContent = this.dfos.getData();
            }
            return this.cachedContent != null ? (byte[])this.cachedContent.clone() : new byte[]{};
        }
        return Files.readAllBytes(this.dfos.getFile().toPath());
    }

    public Charset getCharset() {
        ParameterParser parameterParser = new ParameterParser();
        parameterParser.setLowerCaseNames(true);
        Map map = parameterParser.parse(this.getContentType(), ';');
        return Charsets.toCharset((String)map.get("charset"), this.charsetDefault);
    }

    public Charset getCharsetDefault() {
        return this.charsetDefault;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.fileItemHeaders;
    }

    @Override
    public InputStream getInputStream() {
        if (!this.isInMemory()) {
            return Files.newInputStream(this.dfos.getFile().toPath(), new OpenOption[0]);
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    @Override
    public String getName() {
        return DiskFileItem.checkFileName(this.fileName);
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.dfos == null) {
            this.dfos = DeferredFileOutputStream.builder().setThreshold(this.threshold).setOutputFile(this.getTempFile().toFile()).get();
        }
        return this.dfos;
    }

    public Path getPath() {
        if (this.dfos == null) {
            return null;
        }
        if (this.isInMemory()) {
            return null;
        }
        return this.dfos.getFile().toPath();
    }

    @Override
    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        return this.dfos != null ? this.dfos.getByteCount() : 0L;
    }

    @Override
    public String getString() {
        return new String(this.get(), this.getCharset());
    }

    @Override
    public String getString(Charset charset) {
        return new String(this.get(), Charsets.toCharset(charset, this.charsetDefault));
    }

    protected Path getTempFile() {
        return this.tempFile;
    }

    @Override
    public boolean isFormField() {
        return this.isFormField;
    }

    @Override
    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.dfos.isInMemory();
    }

    public DiskFileItem setCharsetDefault(Charset charset) {
        this.charsetDefault = charset;
        return this;
    }

    @Override
    public DiskFileItem setFieldName(String string) {
        this.fieldName = string;
        return this;
    }

    @Override
    public DiskFileItem setFormField(boolean bl2) {
        this.isFormField = bl2;
        return this;
    }

    @Override
    public DiskFileItem setHeaders(FileItemHeaders fileItemHeaders) {
        this.fileItemHeaders = fileItemHeaders;
        return this;
    }

    public String toString() {
        return String.format("name=%s, StoreLocation=%s, size=%s bytes, isFormField=%s, FieldName=%s", this.getName(), this.getPath(), this.getSize(), this.isFormField(), this.getFieldName());
    }

    @Override
    public DiskFileItem write(Path path) {
        block10: {
            if (this.isInMemory()) {
                try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                    outputStream.write(this.get());
                    break block10;
                }
                catch (IOException iOException) {
                    throw new IOException("Unexpected output data", iOException);
                }
            }
            Path path2 = this.getPath();
            if (path2 == null) {
                throw new FileUploadException("Cannot write uploaded file to disk.");
            }
            this.size = Files.size(path2);
            Files.move(path2, path, StandardCopyOption.REPLACE_EXISTING);
        }
        return this;
    }
}

