/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.regex.Pattern;
import org.apache.commons.fileupload2.core.RequestContext;

public abstract class AbstractRequestContext
implements RequestContext {
    private static final Pattern MULTIPART_RELATED = Pattern.compile("^\\s*multipart/related.*", 2);
    private final LongSupplier contentLengthDefault;
    private final Function contentLengthString;
    private final Object request;

    protected AbstractRequestContext(Function function, LongSupplier longSupplier, Object object) {
        this.contentLengthString = Objects.requireNonNull(function, "contentLengthString");
        this.contentLengthDefault = Objects.requireNonNull(longSupplier, "contentLengthDefault");
        this.request = Objects.requireNonNull(object, "request");
    }

    @Override
    public long getContentLength() {
        try {
            return Long.parseLong((String)this.contentLengthString.apply("Content-length"));
        }
        catch (NumberFormatException numberFormatException) {
            return this.contentLengthDefault.getAsLong();
        }
    }

    public Object getRequest() {
        return this.request;
    }

    @Override
    public boolean isMultipartRelated() {
        return MULTIPART_RELATED.matcher(this.getContentType()).matches();
    }

    public String toString() {
        return String.format("%s [ContentLength=%s, ContentType=%s]", this.getClass().getSimpleName(), this.getContentLength(), this.getContentType());
    }
}

