/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemFactory$AbstractFileItemBuilder;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileItemInputIteratorImpl;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadFileCountLimitException;
import org.apache.commons.fileupload2.core.ParameterParser;
import org.apache.commons.fileupload2.core.ProgressListener;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.io.IOUtils;

public abstract class AbstractFileUpload {
    private static final String BOUNDARY_KEY = "boundary";
    private static final String NAME_KEY = "name";
    private static final String FILENAME_KEY = "filename";
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String CONTENT_LENGTH = "Content-length";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    private long sizeMax = -1L;
    private long fileSizeMax = -1L;
    private long fileCountMax = -1L;
    private Charset headerCharset;
    private ProgressListener progressListener = ProgressListener.NOP;
    private FileItemFactory fileItemFactory;

    public static final boolean isMultipartContent(RequestContext requestContext) {
        String string = requestContext.getContentType();
        if (string == null) {
            return false;
        }
        return string.toLowerCase(Locale.ROOT).startsWith(MULTIPART);
    }

    public byte[] getBoundary(String string) {
        ParameterParser parameterParser = new ParameterParser();
        parameterParser.setLowerCaseNames(true);
        Map map = parameterParser.parse(string, new char[]{';', ','});
        String string2 = (String)map.get(BOUNDARY_KEY);
        return string2 != null ? string2.getBytes(StandardCharsets.ISO_8859_1) : null;
    }

    public String getFieldName(FileItemHeaders fileItemHeaders) {
        return this.getFieldName(fileItemHeaders.getHeader(CONTENT_DISPOSITION));
    }

    private String getFieldName(String string) {
        String string2 = null;
        if (string != null && string.toLowerCase(Locale.ROOT).startsWith(FORM_DATA)) {
            ParameterParser parameterParser = new ParameterParser();
            parameterParser.setLowerCaseNames(true);
            Map map = parameterParser.parse(string, ';');
            string2 = (String)map.get(NAME_KEY);
            if (string2 != null) {
                string2 = string2.trim();
            }
        }
        return string2;
    }

    public long getFileCountMax() {
        return this.fileCountMax;
    }

    public FileItemFactory getFileItemFactory() {
        return this.fileItemFactory;
    }

    public String getFileName(FileItemHeaders fileItemHeaders) {
        return this.getFileName(fileItemHeaders.getHeader(CONTENT_DISPOSITION));
    }

    private String getFileName(String string) {
        String string2;
        String string3 = null;
        if (string != null && ((string2 = string.toLowerCase(Locale.ROOT)).startsWith(FORM_DATA) || string2.startsWith(ATTACHMENT))) {
            ParameterParser parameterParser = new ParameterParser();
            parameterParser.setLowerCaseNames(true);
            Map map = parameterParser.parse(string, ';');
            if (map.containsKey(FILENAME_KEY)) {
                string3 = (String)map.get(FILENAME_KEY);
                string3 = string3 != null ? string3.trim() : "";
            }
        }
        return string3;
    }

    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public Charset getHeaderCharset() {
        return this.headerCharset;
    }

    public abstract FileItemInputIterator getItemIterator(Object var1);

    public FileItemInputIterator getItemIterator(RequestContext requestContext) {
        return new FileItemInputIteratorImpl(this, requestContext);
    }

    public FileItemHeaders getParsedHeaders(String string) {
        int n2;
        int n3 = string.length();
        FileItemHeaders fileItemHeaders = this.newFileItemHeaders();
        int n4 = 0;
        while (n4 != (n2 = this.parseEndOfLine(string, n4))) {
            StringBuilder stringBuilder = new StringBuilder(string.substring(n4, n2));
            n4 = n2 + 2;
            while (n4 < n3) {
                char c2;
                int n5;
                for (n5 = n4; n5 < n3 && ((c2 = string.charAt(n5)) == ' ' || c2 == '\t'); ++n5) {
                }
                if (n5 == n4) break;
                n2 = this.parseEndOfLine(string, n5);
                stringBuilder.append(' ').append(string, n5, n2);
                n4 = n2 + 2;
            }
            this.parseHeaderLine(fileItemHeaders, stringBuilder.toString());
        }
        return fileItemHeaders;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public long getSizeMax() {
        return this.sizeMax;
    }

    protected FileItemHeaders newFileItemHeaders() {
        return FileItemFactory$AbstractFileItemBuilder.newFileItemHeaders();
    }

    private int parseEndOfLine(String string, int n2) {
        int n3 = n2;
        while (true) {
            int n4;
            if ((n4 = string.indexOf(13, n3)) == -1 || n4 + 1 >= string.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (string.charAt(n4 + 1) == '\n') {
                return n4;
            }
            n3 = n4 + 1;
        }
    }

    private void parseHeaderLine(FileItemHeaders fileItemHeaders, String string) {
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            return;
        }
        String string2 = string.substring(0, n2).trim();
        String string3 = string.substring(n2 + 1).trim();
        fileItemHeaders.addHeader(string2, string3);
    }

    public abstract Map parseParameterMap(Object var1);

    public Map parseParameterMap(RequestContext requestContext) {
        List list = this.parseRequest(requestContext);
        HashMap<String, List> hashMap = new HashMap<String, List>(list.size());
        for (FileItem fileItem : list) {
            String string2 = fileItem.getFieldName();
            List list2 = hashMap.computeIfAbsent(string2, string -> new ArrayList());
            list2.add(fileItem);
        }
        return hashMap;
    }

    public abstract List parseRequest(Object var1);

    public List parseRequest(RequestContext requestContext) {
        ArrayList arrayList = new ArrayList();
        boolean bl2 = false;
        try {
            FileItemFactory fileItemFactory = Objects.requireNonNull(this.getFileItemFactory(), "No FileItemFactory has been set.");
            byte[] byArray = new byte[8192];
            this.getItemIterator(requestContext).forEachRemaining(fileItemInput -> {
                if ((long)arrayList.size() == this.fileCountMax) {
                    throw new FileUploadFileCountLimitException(ATTACHMENT, this.getFileCountMax(), arrayList.size());
                }
                FileItem fileItem = (FileItem)fileItemFactory.fileItemBuilder().setFieldName(fileItemInput.getFieldName()).setContentType(fileItemInput.getContentType()).setFormField(fileItemInput.isFormField()).setFileName(fileItemInput.getName()).setFileItemHeaders(fileItemInput.getHeaders()).get();
                arrayList.add(fileItem);
                try (InputStream inputStream = fileItemInput.getInputStream();
                     OutputStream outputStream = fileItem.getOutputStream();){
                    IOUtils.copyLarge(inputStream, outputStream, byArray);
                }
                catch (FileUploadException fileUploadException) {
                    throw fileUploadException;
                }
                catch (IOException iOException) {
                    throw new FileUploadException(String.format("Processing of %s request failed. %s", MULTIPART_FORM_DATA, iOException.getMessage()), iOException);
                }
            });
            bl2 = true;
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        catch (FileUploadException fileUploadException) {
            throw fileUploadException;
        }
        catch (IOException iOException) {
            throw new FileUploadException(iOException.getMessage(), iOException);
        }
        finally {
            if (!bl2) {
                for (FileItem fileItem : arrayList) {
                    try {
                        fileItem.delete();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void setFileCountMax(long l2) {
        this.fileCountMax = l2;
    }

    public void setFileItemFactory(FileItemFactory fileItemFactory) {
        this.fileItemFactory = fileItemFactory;
    }

    public void setFileSizeMax(long l2) {
        this.fileSizeMax = l2;
    }

    public void setHeaderCharset(Charset charset) {
        this.headerCharset = charset;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener != null ? progressListener : ProgressListener.NOP;
    }

    public void setSizeMax(long l2) {
        this.sizeMax = l2;
    }
}

