/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.misc.IntArray;
import org.antlr.runtime.tree.BufferedTreeNodeStream$StreamIterator;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;

public class BufferedTreeNodeStream
implements TreeNodeStream {
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 100;
    public static final int INITIAL_CALL_STACK_SIZE = 10;
    protected Object down;
    protected Object up;
    protected Object eof;
    protected List nodes;
    protected Object root;
    protected TokenStream tokens;
    TreeAdaptor adaptor;
    protected boolean uniqueNavigationNodes = false;
    protected int p = -1;
    protected int lastMarker;
    protected IntArray calls;

    public BufferedTreeNodeStream(Object object) {
        this(new CommonTreeAdaptor(), object);
    }

    public BufferedTreeNodeStream(TreeAdaptor treeAdaptor, Object object) {
        this(treeAdaptor, object, 100);
    }

    public BufferedTreeNodeStream(TreeAdaptor treeAdaptor, Object object, int n2) {
        this.root = object;
        this.adaptor = treeAdaptor;
        this.nodes = new ArrayList(n2);
        this.down = treeAdaptor.create(2, "DOWN");
        this.up = treeAdaptor.create(3, "UP");
        this.eof = treeAdaptor.create(-1, "EOF");
    }

    protected void fillBuffer() {
        this.fillBuffer(this.root);
        this.p = 0;
    }

    public void fillBuffer(Object object) {
        boolean bl2 = this.adaptor.isNil(object);
        if (!bl2) {
            this.nodes.add(object);
        }
        int n2 = this.adaptor.getChildCount(object);
        if (!bl2 && n2 > 0) {
            this.addNavigationNode(2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = this.adaptor.getChild(object, i2);
            this.fillBuffer(object2);
        }
        if (!bl2 && n2 > 0) {
            this.addNavigationNode(3);
        }
    }

    protected int getNodeIndex(Object object) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
            Object e2 = this.nodes.get(i2);
            if (e2 != object) continue;
            return i2;
        }
        return -1;
    }

    protected void addNavigationNode(int n2) {
        Object object = null;
        object = n2 == 2 ? (this.hasUniqueNavigationNodes() ? this.adaptor.create(2, "DOWN") : this.down) : (this.hasUniqueNavigationNodes() ? this.adaptor.create(3, "UP") : this.up);
        this.nodes.add(object);
    }

    public Object get(int n2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.get(n2);
    }

    public Object LT(int n2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 < 0) {
            return this.LB(-n2);
        }
        if (this.p + n2 - 1 >= this.nodes.size()) {
            return this.eof;
        }
        return this.nodes.get(this.p + n2 - 1);
    }

    public Object getCurrentSymbol() {
        return this.LT(1);
    }

    protected Object LB(int n2) {
        if (n2 == 0) {
            return null;
        }
        if (this.p - n2 < 0) {
            return null;
        }
        return this.nodes.get(this.p - n2);
    }

    public Object getTreeSource() {
        return this.root;
    }

    public String getSourceName() {
        return this.getTokenStream().getSourceName();
    }

    public TokenStream getTokenStream() {
        return this.tokens;
    }

    public void setTokenStream(TokenStream tokenStream) {
        this.tokens = tokenStream;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public void setTreeAdaptor(TreeAdaptor treeAdaptor) {
        this.adaptor = treeAdaptor;
    }

    public boolean hasUniqueNavigationNodes() {
        return this.uniqueNavigationNodes;
    }

    public void setUniqueNavigationNodes(boolean bl2) {
        this.uniqueNavigationNodes = bl2;
    }

    public void consume() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        ++this.p;
    }

    public int LA(int n2) {
        return this.adaptor.getType(this.LT(n2));
    }

    public int mark() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void release(int n2) {
    }

    public int index() {
        return this.p;
    }

    public void rewind(int n2) {
        this.seek(n2);
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void seek(int n2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.p = n2;
    }

    public void push(int n2) {
        if (this.calls == null) {
            this.calls = new IntArray();
        }
        this.calls.push(this.p);
        this.seek(n2);
    }

    public int pop() {
        int n2 = this.calls.pop();
        this.seek(n2);
        return n2;
    }

    public void reset() {
        this.p = 0;
        this.lastMarker = 0;
        if (this.calls != null) {
            this.calls.clear();
        }
    }

    public int size() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.size();
    }

    public Iterator iterator() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return new BufferedTreeNodeStream$StreamIterator(this);
    }

    public void replaceChildren(Object object, int n2, int n3, Object object2) {
        if (object != null) {
            this.adaptor.replaceChildren(object, n2, n3, object2);
        }
    }

    public String toTokenTypeString() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
            Object e2 = this.nodes.get(i2);
            stringBuffer.append(" ");
            stringBuffer.append(this.adaptor.getType(e2));
        }
        return stringBuffer.toString();
    }

    public String toTokenString(int n2, int n3) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = n2; i2 < this.nodes.size() && i2 <= n3; ++i2) {
            Object e2 = this.nodes.get(i2);
            stringBuffer.append(" ");
            stringBuffer.append(this.adaptor.getToken(e2));
        }
        return stringBuffer.toString();
    }

    public String toString(Object object, Object object2) {
        String string;
        int n2;
        System.out.println("toString");
        if (object == null || object2 == null) {
            return null;
        }
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (object instanceof CommonTree) {
            System.out.print("toString: " + ((CommonTree)object).getToken() + ", ");
        } else {
            System.out.println(object);
        }
        if (object2 instanceof CommonTree) {
            System.out.println(((CommonTree)object2).getToken());
        } else {
            System.out.println(object2);
        }
        if (this.tokens != null) {
            int n3 = this.adaptor.getTokenStartIndex(object);
            int n4 = this.adaptor.getTokenStopIndex(object2);
            if (this.adaptor.getType(object2) == 3) {
                n4 = this.adaptor.getTokenStopIndex(object);
            } else if (this.adaptor.getType(object2) == -1) {
                n4 = this.size() - 2;
            }
            return this.tokens.toString(n3, n4);
        }
        Object var3_4 = null;
        for (n2 = 0; n2 < this.nodes.size() && (var3_4 = this.nodes.get(n2)) != object; ++n2) {
        }
        StringBuffer stringBuffer = new StringBuffer();
        var3_4 = this.nodes.get(n2);
        while (var3_4 != object2) {
            string = this.adaptor.getText(var3_4);
            if (string == null) {
                string = " " + String.valueOf(this.adaptor.getType(var3_4));
            }
            stringBuffer.append(string);
            var3_4 = this.nodes.get(++n2);
        }
        string = this.adaptor.getText(object2);
        if (string == null) {
            string = " " + String.valueOf(this.adaptor.getType(object2));
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

