/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public abstract class BaseTree
implements Tree {
    protected List children;

    public BaseTree() {
    }

    public BaseTree(Tree tree) {
    }

    public Tree getChild(int n2) {
        if (this.children == null || n2 >= this.children.size()) {
            return null;
        }
        return (Tree)this.children.get(n2);
    }

    public List getChildren() {
        return this.children;
    }

    public Tree getFirstChildWithType(int n2) {
        for (int i2 = 0; this.children != null && i2 < this.children.size(); ++i2) {
            Tree tree = (Tree)this.children.get(i2);
            if (tree.getType() != n2) continue;
            return tree;
        }
        return null;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(Tree tree) {
        if (tree == null) {
            return;
        }
        BaseTree baseTree = (BaseTree)tree;
        if (baseTree.isNil()) {
            if (this.children != null && this.children == baseTree.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (baseTree.children != null) {
                if (this.children != null) {
                    int n2 = baseTree.children.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Tree tree2 = (Tree)baseTree.children.get(i2);
                        this.children.add(tree2);
                        tree2.setParent(this);
                        tree2.setChildIndex(this.children.size() - 1);
                    }
                } else {
                    this.children = baseTree.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add(tree);
            baseTree.setParent(this);
            baseTree.setChildIndex(this.children.size() - 1);
        }
    }

    public void addChildren(List list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Tree tree = (Tree)list.get(i2);
            this.addChild(tree);
        }
    }

    public void setChild(int n2, Tree tree) {
        if (tree == null) {
            return;
        }
        if (tree.isNil()) {
            throw new IllegalArgumentException("Can't set single child to a list");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(n2, tree);
        tree.setParent(this);
        tree.setChildIndex(n2);
    }

    public void insertChild(int n2, Object object) {
        if (this.children == null) {
            return;
        }
        this.children.add(n2, object);
        this.freshenParentAndChildIndexes(n2);
    }

    public Object deleteChild(int n2) {
        if (this.children == null) {
            return null;
        }
        Tree tree = (Tree)this.children.remove(n2);
        this.freshenParentAndChildIndexes(n2);
        return tree;
    }

    public void replaceChildren(int n2, int n3, Object object) {
        if (this.children == null) {
            throw new IllegalArgumentException("indexes invalid; no children in list");
        }
        int n4 = n3 - n2 + 1;
        BaseTree baseTree = (BaseTree)object;
        ArrayList<BaseTree> arrayList = null;
        if (baseTree.isNil()) {
            arrayList = baseTree.children;
        } else {
            arrayList = new ArrayList<BaseTree>(1);
            arrayList.add(baseTree);
        }
        int n5 = arrayList.size();
        int n6 = arrayList.size();
        int n7 = n4 - n5;
        if (n7 == 0) {
            int n8 = 0;
            for (int i2 = n2; i2 <= n3; ++i2) {
                BaseTree baseTree2 = (BaseTree)arrayList.get(n8);
                this.children.set(i2, baseTree2);
                baseTree2.setParent(this);
                baseTree2.setChildIndex(i2);
                ++n8;
            }
        } else if (n7 > 0) {
            int n9;
            for (n9 = 0; n9 < n6; ++n9) {
                this.children.set(n2 + n9, arrayList.get(n9));
            }
            for (int i3 = n9 = n2 + n6; i3 <= n3; ++i3) {
                this.children.remove(n9);
            }
            this.freshenParentAndChildIndexes(n2);
        } else {
            int n10;
            for (n10 = 0; n10 < n4; ++n10) {
                this.children.set(n2 + n10, arrayList.get(n10));
            }
            n10 = n5 - n4;
            for (int i4 = n4; i4 < n5; ++i4) {
                this.children.add(n2 + i4, arrayList.get(i4));
            }
            this.freshenParentAndChildIndexes(n2);
        }
    }

    protected List createChildrenList() {
        return new ArrayList();
    }

    public boolean isNil() {
        return false;
    }

    public void freshenParentAndChildIndexes() {
        this.freshenParentAndChildIndexes(0);
    }

    public void freshenParentAndChildIndexes(int n2) {
        int n3 = this.getChildCount();
        for (int i2 = n2; i2 < n3; ++i2) {
            Tree tree = this.getChild(i2);
            tree.setChildIndex(i2);
            tree.setParent(this);
        }
    }

    public void freshenParentAndChildIndexesDeeply() {
        this.freshenParentAndChildIndexesDeeply(0);
    }

    public void freshenParentAndChildIndexesDeeply(int n2) {
        int n3 = this.getChildCount();
        for (int i2 = n2; i2 < n3; ++i2) {
            BaseTree baseTree = (BaseTree)this.getChild(i2);
            baseTree.setChildIndex(i2);
            baseTree.setParent(this);
            baseTree.freshenParentAndChildIndexesDeeply();
        }
    }

    public void sanityCheckParentAndChildIndexes() {
        this.sanityCheckParentAndChildIndexes(null, -1);
    }

    public void sanityCheckParentAndChildIndexes(Tree tree, int n2) {
        if (tree != this.getParent()) {
            throw new IllegalStateException("parents don't match; expected " + tree + " found " + this.getParent());
        }
        if (n2 != this.getChildIndex()) {
            throw new IllegalStateException("child indexes don't match; expected " + n2 + " found " + this.getChildIndex());
        }
        int n3 = this.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            CommonTree commonTree = (CommonTree)this.getChild(i2);
            commonTree.sanityCheckParentAndChildIndexes(this, i2);
        }
    }

    public int getChildIndex() {
        return 0;
    }

    public void setChildIndex(int n2) {
    }

    public Tree getParent() {
        return null;
    }

    public void setParent(Tree tree) {
    }

    public boolean hasAncestor(int n2) {
        return this.getAncestor(n2) != null;
    }

    public Tree getAncestor(int n2) {
        Tree tree = this;
        for (tree = tree.getParent(); tree != null; tree = tree.getParent()) {
            if (tree.getType() != n2) continue;
            return tree;
        }
        return null;
    }

    public List getAncestors() {
        if (this.getParent() == null) {
            return null;
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        Tree tree = this;
        for (tree = tree.getParent(); tree != null; tree = tree.getParent()) {
            arrayList.add(0, tree);
        }
        return arrayList;
    }

    public String toStringTree() {
        if (this.children == null || this.children.size() == 0) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isNil()) {
            stringBuffer.append("(");
            stringBuffer.append(this.toString());
            stringBuffer.append(' ');
        }
        for (int i2 = 0; this.children != null && i2 < this.children.size(); ++i2) {
            Tree tree = (Tree)this.children.get(i2);
            if (i2 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(tree.toStringTree());
        }
        if (!this.isNil()) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public int getLine() {
        return 0;
    }

    public int getCharPositionInLine() {
        return 0;
    }

    public abstract String toString();
}

