/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.util.StringTokenizer;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.debug.RemoteDebugEventSocketListener$ProxyToken;
import org.antlr.runtime.debug.RemoteDebugEventSocketListener$ProxyTree;

public class RemoteDebugEventSocketListener
implements Runnable {
    static final int MAX_EVENT_ELEMENTS = 8;
    DebugEventListener listener;
    String machine;
    int port;
    Socket channel = null;
    PrintWriter out;
    BufferedReader in;
    String event;
    public String version;
    public String grammarFileName;
    int previousTokenIndex = -1;
    boolean tokenIndexesInvalid = false;

    public RemoteDebugEventSocketListener(DebugEventListener debugEventListener, String string, int n2) {
        this.listener = debugEventListener;
        this.machine = string;
        this.port = n2;
        if (!this.openConnection()) {
            throw new ConnectException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventHandler() {
        try {
            this.handshake();
            this.event = this.in.readLine();
            while (this.event != null) {
                this.dispatch(this.event);
                this.ack();
                this.event = this.in.readLine();
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        finally {
            this.closeConnection();
        }
    }

    protected boolean openConnection() {
        boolean bl2 = false;
        try {
            this.channel = new Socket(this.machine, this.port);
            this.channel.setTcpNoDelay(true);
            OutputStream outputStream = this.channel.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
            this.out = new PrintWriter(new BufferedWriter(outputStreamWriter));
            InputStream inputStream = this.channel.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
            this.in = new BufferedReader(inputStreamReader);
            bl2 = true;
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() {
        try {
            this.in.close();
            this.in = null;
            this.out.close();
            this.out = null;
            this.channel.close();
            this.channel = null;
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
    }

    protected void handshake() {
        String string = this.in.readLine();
        String[] stringArray = this.getEventElements(string);
        this.version = stringArray[1];
        String string2 = this.in.readLine();
        String[] stringArray2 = this.getEventElements(string2);
        this.grammarFileName = stringArray2[1];
        this.ack();
        this.listener.commence();
    }

    protected void ack() {
        this.out.println("ack");
        this.out.flush();
    }

    protected void dispatch(String string) {
        String[] stringArray = this.getEventElements(string);
        if (stringArray == null || stringArray[0] == null) {
            System.err.println("unknown debug event: " + string);
            return;
        }
        if (stringArray[0].equals("enterRule")) {
            this.listener.enterRule(stringArray[1], stringArray[2]);
        } else if (stringArray[0].equals("exitRule")) {
            this.listener.exitRule(stringArray[1], stringArray[2]);
        } else if (stringArray[0].equals("enterAlt")) {
            this.listener.enterAlt(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("enterSubRule")) {
            this.listener.enterSubRule(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("exitSubRule")) {
            this.listener.exitSubRule(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("enterDecision")) {
            this.listener.enterDecision(Integer.parseInt(stringArray[1]), stringArray[2].equals("true"));
        } else if (stringArray[0].equals("exitDecision")) {
            this.listener.exitDecision(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("location")) {
            this.listener.location(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        } else if (stringArray[0].equals("consumeToken")) {
            RemoteDebugEventSocketListener$ProxyToken remoteDebugEventSocketListener$ProxyToken = this.deserializeToken(stringArray, 1);
            if (remoteDebugEventSocketListener$ProxyToken.getTokenIndex() == this.previousTokenIndex) {
                this.tokenIndexesInvalid = true;
            }
            this.previousTokenIndex = remoteDebugEventSocketListener$ProxyToken.getTokenIndex();
            this.listener.consumeToken(remoteDebugEventSocketListener$ProxyToken);
        } else if (stringArray[0].equals("consumeHiddenToken")) {
            RemoteDebugEventSocketListener$ProxyToken remoteDebugEventSocketListener$ProxyToken = this.deserializeToken(stringArray, 1);
            if (remoteDebugEventSocketListener$ProxyToken.getTokenIndex() == this.previousTokenIndex) {
                this.tokenIndexesInvalid = true;
            }
            this.previousTokenIndex = remoteDebugEventSocketListener$ProxyToken.getTokenIndex();
            this.listener.consumeHiddenToken(remoteDebugEventSocketListener$ProxyToken);
        } else if (stringArray[0].equals("LT")) {
            RemoteDebugEventSocketListener$ProxyToken remoteDebugEventSocketListener$ProxyToken = this.deserializeToken(stringArray, 2);
            this.listener.LT(Integer.parseInt(stringArray[1]), remoteDebugEventSocketListener$ProxyToken);
        } else if (stringArray[0].equals("mark")) {
            this.listener.mark(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("rewind")) {
            if (stringArray[1] != null) {
                this.listener.rewind(Integer.parseInt(stringArray[1]));
            } else {
                this.listener.rewind();
            }
        } else if (stringArray[0].equals("beginBacktrack")) {
            this.listener.beginBacktrack(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("endBacktrack")) {
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            this.listener.endBacktrack(n2, n3 == 1);
        } else if (stringArray[0].equals("exception")) {
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            String string5 = stringArray[4];
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string2);
                RecognitionException recognitionException = (RecognitionException)clazz.newInstance();
                recognitionException.index = Integer.parseInt(string3);
                recognitionException.line = Integer.parseInt(string4);
                recognitionException.charPositionInLine = Integer.parseInt(string5);
                this.listener.recognitionException(recognitionException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("can't find class " + classNotFoundException);
                classNotFoundException.printStackTrace(System.err);
            }
            catch (InstantiationException instantiationException) {
                System.err.println("can't instantiate class " + instantiationException);
                instantiationException.printStackTrace(System.err);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("can't access class " + illegalAccessException);
                illegalAccessException.printStackTrace(System.err);
            }
        } else if (stringArray[0].equals("beginResync")) {
            this.listener.beginResync();
        } else if (stringArray[0].equals("endResync")) {
            this.listener.endResync();
        } else if (stringArray[0].equals("terminate")) {
            this.listener.terminate();
        } else if (stringArray[0].equals("semanticPredicate")) {
            Boolean bl2 = Boolean.valueOf(stringArray[1]);
            String string6 = stringArray[2];
            string6 = this.unEscapeNewlines(string6);
            this.listener.semanticPredicate(bl2, string6);
        } else if (stringArray[0].equals("consumeNode")) {
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree = this.deserializeNode(stringArray, 1);
            this.listener.consumeNode(remoteDebugEventSocketListener$ProxyTree);
        } else if (stringArray[0].equals("LN")) {
            int n4 = Integer.parseInt(stringArray[1]);
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree = this.deserializeNode(stringArray, 2);
            this.listener.LT(n4, remoteDebugEventSocketListener$ProxyTree);
        } else if (stringArray[0].equals("createNodeFromTokenElements")) {
            int n5 = Integer.parseInt(stringArray[1]);
            int n6 = Integer.parseInt(stringArray[2]);
            String string7 = stringArray[3];
            string7 = this.unEscapeNewlines(string7);
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree = new RemoteDebugEventSocketListener$ProxyTree(n5, n6, -1, -1, -1, string7);
            this.listener.createNode(remoteDebugEventSocketListener$ProxyTree);
        } else if (stringArray[0].equals("createNode")) {
            int n7 = Integer.parseInt(stringArray[1]);
            int n8 = Integer.parseInt(stringArray[2]);
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree = new RemoteDebugEventSocketListener$ProxyTree(n7);
            RemoteDebugEventSocketListener$ProxyToken remoteDebugEventSocketListener$ProxyToken = new RemoteDebugEventSocketListener$ProxyToken(n8);
            this.listener.createNode(remoteDebugEventSocketListener$ProxyTree, remoteDebugEventSocketListener$ProxyToken);
        } else if (stringArray[0].equals("nilNode")) {
            int n9 = Integer.parseInt(stringArray[1]);
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree = new RemoteDebugEventSocketListener$ProxyTree(n9);
            this.listener.nilNode(remoteDebugEventSocketListener$ProxyTree);
        } else if (stringArray[0].equals("errorNode")) {
            int n10 = Integer.parseInt(stringArray[1]);
            int n11 = Integer.parseInt(stringArray[2]);
            String string8 = stringArray[3];
            string8 = this.unEscapeNewlines(string8);
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree = new RemoteDebugEventSocketListener$ProxyTree(n10, n11, -1, -1, -1, string8);
            this.listener.errorNode(remoteDebugEventSocketListener$ProxyTree);
        } else if (stringArray[0].equals("becomeRoot")) {
            int n12 = Integer.parseInt(stringArray[1]);
            int n13 = Integer.parseInt(stringArray[2]);
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree = new RemoteDebugEventSocketListener$ProxyTree(n12);
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree2 = new RemoteDebugEventSocketListener$ProxyTree(n13);
            this.listener.becomeRoot(remoteDebugEventSocketListener$ProxyTree, remoteDebugEventSocketListener$ProxyTree2);
        } else if (stringArray[0].equals("addChild")) {
            int n14 = Integer.parseInt(stringArray[1]);
            int n15 = Integer.parseInt(stringArray[2]);
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree = new RemoteDebugEventSocketListener$ProxyTree(n14);
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree3 = new RemoteDebugEventSocketListener$ProxyTree(n15);
            this.listener.addChild(remoteDebugEventSocketListener$ProxyTree, remoteDebugEventSocketListener$ProxyTree3);
        } else if (stringArray[0].equals("setTokenBoundaries")) {
            int n16 = Integer.parseInt(stringArray[1]);
            RemoteDebugEventSocketListener$ProxyTree remoteDebugEventSocketListener$ProxyTree = new RemoteDebugEventSocketListener$ProxyTree(n16);
            this.listener.setTokenBoundaries(remoteDebugEventSocketListener$ProxyTree, Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        } else {
            System.err.println("unknown debug event: " + string);
        }
    }

    protected RemoteDebugEventSocketListener$ProxyTree deserializeNode(String[] stringArray, int n2) {
        int n3 = Integer.parseInt(stringArray[n2 + 0]);
        int n4 = Integer.parseInt(stringArray[n2 + 1]);
        int n5 = Integer.parseInt(stringArray[n2 + 2]);
        int n6 = Integer.parseInt(stringArray[n2 + 3]);
        int n7 = Integer.parseInt(stringArray[n2 + 4]);
        String string = stringArray[n2 + 5];
        string = this.unEscapeNewlines(string);
        return new RemoteDebugEventSocketListener$ProxyTree(n3, n4, n5, n6, n7, string);
    }

    protected RemoteDebugEventSocketListener$ProxyToken deserializeToken(String[] stringArray, int n2) {
        String string = stringArray[n2 + 0];
        String string2 = stringArray[n2 + 1];
        String string3 = stringArray[n2 + 2];
        String string4 = stringArray[n2 + 3];
        String string5 = stringArray[n2 + 4];
        String string6 = stringArray[n2 + 5];
        string6 = this.unEscapeNewlines(string6);
        int n3 = Integer.parseInt(string);
        RemoteDebugEventSocketListener$ProxyToken remoteDebugEventSocketListener$ProxyToken = new RemoteDebugEventSocketListener$ProxyToken(n3, Integer.parseInt(string2), Integer.parseInt(string3), Integer.parseInt(string4), Integer.parseInt(string5), string6);
        return remoteDebugEventSocketListener$ProxyToken;
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        this.eventHandler();
    }

    public String[] getEventElements(String object) {
        if (object == null) {
            return null;
        }
        String[] stringArray = new String[8];
        String string = null;
        try {
            Object object2;
            int n2 = ((String)object).indexOf(34);
            if (n2 >= 0) {
                object2 = ((String)object).substring(0, n2);
                string = ((String)object).substring(n2 + 1, ((String)object).length());
                object = object2;
            }
            object2 = new StringTokenizer((String)object, "\t", false);
            int n3 = 0;
            while (((StringTokenizer)object2).hasMoreTokens()) {
                if (n3 >= 8) {
                    return stringArray;
                }
                stringArray[n3] = ((StringTokenizer)object2).nextToken();
                ++n3;
            }
            if (string != null) {
                stringArray[n3] = string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return stringArray;
    }

    protected String unEscapeNewlines(String string) {
        string = string.replaceAll("%0A", "\n");
        string = string.replaceAll("%0D", "\r");
        string = string.replaceAll("%25", "%");
        return string;
    }

    public boolean tokenIndexesAreInvalid() {
        return false;
    }
}

