/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.BlankDebugEventListener;
import org.antlr.runtime.debug.DebugParser;
import org.antlr.runtime.debug.Profiler$DecisionDescriptor;
import org.antlr.runtime.debug.Profiler$DecisionEvent;
import org.antlr.runtime.debug.Profiler$ProfileStats;
import org.antlr.runtime.misc.DoubleKeyMap;

public class Profiler
extends BlankDebugEventListener {
    public static final String DATA_SEP = "\t";
    public static final String newline = System.getProperty("line.separator");
    static boolean dump = false;
    public static final String Version = "3";
    public static final String RUNTIME_STATS_FILENAME = "runtime.stats";
    public DebugParser parser = null;
    protected int ruleLevel = 0;
    protected Token lastRealTokenTouchedInDecision;
    protected Set uniqueRules = new HashSet();
    protected Stack currentGrammarFileName = new Stack();
    protected Stack currentRuleName = new Stack();
    protected Stack currentLine = new Stack();
    protected Stack currentPos = new Stack();
    protected DoubleKeyMap decisions = new DoubleKeyMap();
    protected List decisionEvents = new ArrayList();
    protected Stack decisionStack = new Stack();
    protected int backtrackDepth;
    Profiler$ProfileStats stats = new Profiler$ProfileStats();

    public Profiler() {
    }

    public Profiler(DebugParser debugParser) {
        this.parser = debugParser;
    }

    public void enterRule(String string, String string2) {
        ++this.ruleLevel;
        ++this.stats.numRuleInvocations;
        this.uniqueRules.add(string + ":" + string2);
        this.stats.maxRuleInvocationDepth = Math.max(this.stats.maxRuleInvocationDepth, this.ruleLevel);
        this.currentGrammarFileName.push(string);
        this.currentRuleName.push(string2);
    }

    public void exitRule(String string, String string2) {
        --this.ruleLevel;
        this.currentGrammarFileName.pop();
        this.currentRuleName.pop();
    }

    public void examineRuleMemoization(IntStream intStream, int n2, int n3, String string) {
        if (dump) {
            System.out.println("examine memo " + string + " at " + intStream.index() + ": " + n3);
        }
        if (n3 == -1) {
            ++this.stats.numMemoizationCacheMisses;
            ++this.stats.numGuessingRuleInvocations;
            ++this.currentDecision().numMemoizationCacheMisses;
        } else {
            ++this.stats.numMemoizationCacheHits;
            ++this.currentDecision().numMemoizationCacheHits;
        }
    }

    public void memoize(IntStream intStream, int n2, int n3, String string) {
        if (dump) {
            System.out.println("memoize " + string);
        }
        ++this.stats.numMemoizationCacheEntries;
    }

    public void location(int n2, int n3) {
        this.currentLine.push(new Integer(n2));
        this.currentPos.push(new Integer(n3));
    }

    public void enterDecision(int n2, boolean bl2) {
        String string;
        Profiler$DecisionDescriptor profiler$DecisionDescriptor;
        this.lastRealTokenTouchedInDecision = null;
        ++this.stats.numDecisionEvents;
        int n3 = this.parser.getTokenStream().index();
        TokenStream tokenStream = this.parser.getTokenStream();
        if (dump) {
            System.out.println("enterDecision canBacktrack=" + bl2 + " " + n2 + " backtrack depth " + this.backtrackDepth + " @ " + tokenStream.get(tokenStream.index()) + " rule " + this.locationDescription());
        }
        if ((profiler$DecisionDescriptor = (Profiler$DecisionDescriptor)this.decisions.get(string = (String)this.currentGrammarFileName.peek(), new Integer(n2))) == null) {
            profiler$DecisionDescriptor = new Profiler$DecisionDescriptor();
            this.decisions.put(string, new Integer(n2), profiler$DecisionDescriptor);
            profiler$DecisionDescriptor.decision = n2;
            profiler$DecisionDescriptor.fileName = (String)this.currentGrammarFileName.peek();
            profiler$DecisionDescriptor.ruleName = (String)this.currentRuleName.peek();
            profiler$DecisionDescriptor.line = (Integer)this.currentLine.peek();
            profiler$DecisionDescriptor.pos = (Integer)this.currentPos.peek();
            profiler$DecisionDescriptor.couldBacktrack = bl2;
        }
        ++profiler$DecisionDescriptor.n;
        Profiler$DecisionEvent profiler$DecisionEvent = new Profiler$DecisionEvent();
        this.decisionStack.push(profiler$DecisionEvent);
        profiler$DecisionEvent.decision = profiler$DecisionDescriptor;
        profiler$DecisionEvent.startTime = System.currentTimeMillis();
        profiler$DecisionEvent.startIndex = n3;
    }

    public void exitDecision(int n2) {
        int n3;
        Profiler$DecisionEvent profiler$DecisionEvent = (Profiler$DecisionEvent)this.decisionStack.pop();
        profiler$DecisionEvent.stopTime = System.currentTimeMillis();
        int n4 = this.lastRealTokenTouchedInDecision.getTokenIndex();
        int n5 = this.getNumberOfHiddenTokens(profiler$DecisionEvent.startIndex, n4);
        profiler$DecisionEvent.k = n3 = n4 - profiler$DecisionEvent.startIndex - n5 + 1;
        profiler$DecisionEvent.decision.maxk = Math.max(profiler$DecisionEvent.decision.maxk, n3);
        if (dump) {
            System.out.println("exitDecision " + n2 + " in " + profiler$DecisionEvent.decision.ruleName + " lookahead " + profiler$DecisionEvent.k + " max token " + this.lastRealTokenTouchedInDecision);
        }
        this.decisionEvents.add(profiler$DecisionEvent);
    }

    public void consumeToken(Token token) {
        if (dump) {
            System.out.println("consume token " + token);
        }
        if (!this.inDecision()) {
            ++this.stats.numTokens;
            return;
        }
        if (this.lastRealTokenTouchedInDecision == null || this.lastRealTokenTouchedInDecision.getTokenIndex() < token.getTokenIndex()) {
            this.lastRealTokenTouchedInDecision = token;
        }
        Profiler$DecisionEvent profiler$DecisionEvent = this.currentDecision();
        int n2 = token.getTokenIndex();
        int n3 = this.getNumberOfHiddenTokens(profiler$DecisionEvent.startIndex, n2);
        int n4 = n2 - profiler$DecisionEvent.startIndex - n3 + 1;
        if (dump) {
            System.out.println("consume " + n2 + " " + n4 + " tokens ahead in " + profiler$DecisionEvent.decision.ruleName + "-" + profiler$DecisionEvent.decision.decision + " start index " + profiler$DecisionEvent.startIndex);
        }
    }

    public boolean inDecision() {
        return this.decisionStack.size() > 0;
    }

    public void consumeHiddenToken(Token token) {
        if (!this.inDecision()) {
            ++this.stats.numHiddenTokens;
        }
    }

    public void LT(int n2, Token token) {
        if (this.inDecision() && n2 > 0) {
            Profiler$DecisionEvent profiler$DecisionEvent = this.currentDecision();
            if (dump) {
                System.out.println("LT(" + n2 + ")=" + token + " index " + token.getTokenIndex() + " relative to " + profiler$DecisionEvent.decision.ruleName + "-" + profiler$DecisionEvent.decision.decision + " start index " + profiler$DecisionEvent.startIndex);
            }
            if (this.lastRealTokenTouchedInDecision == null || this.lastRealTokenTouchedInDecision.getTokenIndex() < token.getTokenIndex()) {
                this.lastRealTokenTouchedInDecision = token;
                if (dump) {
                    System.out.println("set last token " + this.lastRealTokenTouchedInDecision);
                }
            }
        }
    }

    public void beginBacktrack(int n2) {
        if (dump) {
            System.out.println("enter backtrack " + n2);
        }
        ++this.backtrackDepth;
        Profiler$DecisionEvent profiler$DecisionEvent = this.currentDecision();
        if (profiler$DecisionEvent.decision.couldBacktrack) {
            ++this.stats.numBacktrackOccurrences;
            ++profiler$DecisionEvent.decision.numBacktrackOccurrences;
            profiler$DecisionEvent.backtracks = true;
        }
    }

    public void endBacktrack(int n2, boolean bl2) {
        if (dump) {
            System.out.println("exit backtrack " + n2 + ": " + bl2);
        }
        --this.backtrackDepth;
    }

    public void mark(int n2) {
        if (dump) {
            System.out.println("mark " + n2);
        }
    }

    public void rewind(int n2) {
        if (dump) {
            System.out.println("rewind " + n2);
        }
    }

    public void rewind() {
        if (dump) {
            System.out.println("rewind");
        }
    }

    protected Profiler$DecisionEvent currentDecision() {
        return (Profiler$DecisionEvent)this.decisionStack.peek();
    }

    public void recognitionException(RecognitionException recognitionException) {
        ++this.stats.numReportedErrors;
    }

    public void semanticPredicate(boolean bl2, String string) {
        ++this.stats.numSemanticPredicates;
        if (this.inDecision()) {
            Profiler$DecisionEvent profiler$DecisionEvent = this.currentDecision();
            profiler$DecisionEvent.evalSemPred = true;
            ++profiler$DecisionEvent.decision.numSemPredEvals;
            if (dump) {
                System.out.println("eval " + string + " in " + profiler$DecisionEvent.decision.ruleName + "-" + profiler$DecisionEvent.decision.decision);
            }
        }
    }

    public void terminate() {
        Object object;
        Iterator iterator = this.decisionEvents.iterator();
        while (iterator.hasNext()) {
            object = (Profiler$DecisionEvent)iterator.next();
            ((Profiler$DecisionEvent)object).decision.avgk += (float)((Profiler$DecisionEvent)object).k;
            this.stats.avgkPerDecisionEvent += (float)((Profiler$DecisionEvent)object).k;
            if (!((Profiler$DecisionEvent)object).backtracks) continue;
            this.stats.avgkPerBacktrackingDecisionEvent += (float)((Profiler$DecisionEvent)object).k;
        }
        this.stats.averageDecisionPercentBacktracks = 0.0f;
        iterator = this.decisions.values().iterator();
        while (iterator.hasNext()) {
            object = (Profiler$DecisionDescriptor)iterator.next();
            ++this.stats.numDecisionsCovered;
            ((Profiler$DecisionDescriptor)object).avgk = (float)((double)((Profiler$DecisionDescriptor)object).avgk / (double)((Profiler$DecisionDescriptor)object).n);
            if (((Profiler$DecisionDescriptor)object).couldBacktrack) {
                ++this.stats.numDecisionsThatPotentiallyBacktrack;
                float f2 = (float)((Profiler$DecisionDescriptor)object).numBacktrackOccurrences / (float)((Profiler$DecisionDescriptor)object).n;
                this.stats.averageDecisionPercentBacktracks += f2;
            }
            if (((Profiler$DecisionDescriptor)object).numBacktrackOccurrences <= 0) continue;
            ++this.stats.numDecisionsThatDoBacktrack;
        }
        this.stats.averageDecisionPercentBacktracks /= (float)this.stats.numDecisionsThatPotentiallyBacktrack;
        this.stats.averageDecisionPercentBacktracks *= 100.0f;
        this.stats.avgkPerDecisionEvent /= (float)this.stats.numDecisionEvents;
        this.stats.avgkPerBacktrackingDecisionEvent = (float)((double)this.stats.avgkPerBacktrackingDecisionEvent / (double)this.stats.numBacktrackOccurrences);
        System.err.println(this.toString());
        System.err.println(this.getDecisionStatsDump());
    }

    public void setParser(DebugParser debugParser) {
        this.parser = debugParser;
    }

    public String toNotifyString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Version);
        stringBuffer.append('\t');
        stringBuffer.append(this.parser.getClass().getName());
        return stringBuffer.toString();
    }

    public String toString() {
        return Profiler.toString(this.getReport());
    }

    public Profiler$ProfileStats getReport() {
        this.stats.Version = Version;
        this.stats.name = this.parser.getClass().getName();
        this.stats.numUniqueRulesInvoked = this.uniqueRules.size();
        return this.stats;
    }

    public DoubleKeyMap getDecisionStats() {
        return this.decisions;
    }

    public List getDecisionEvents() {
        return this.decisionEvents;
    }

    public static String toString(Profiler$ProfileStats profiler$ProfileStats) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ANTLR Runtime Report; Profile Version ");
        stringBuffer.append(profiler$ProfileStats.Version);
        stringBuffer.append(newline);
        stringBuffer.append("parser name ");
        stringBuffer.append(profiler$ProfileStats.name);
        stringBuffer.append(newline);
        stringBuffer.append("Number of rule invocations ");
        stringBuffer.append(profiler$ProfileStats.numRuleInvocations);
        stringBuffer.append(newline);
        stringBuffer.append("Number of unique rules visited ");
        stringBuffer.append(profiler$ProfileStats.numUniqueRulesInvoked);
        stringBuffer.append(newline);
        stringBuffer.append("Number of decision events ");
        stringBuffer.append(profiler$ProfileStats.numDecisionEvents);
        stringBuffer.append(newline);
        stringBuffer.append("Overall average k per decision event ");
        stringBuffer.append(profiler$ProfileStats.avgkPerDecisionEvent);
        stringBuffer.append(newline);
        stringBuffer.append("Number of backtracking occurrences (can be multiple per decision) ");
        stringBuffer.append(profiler$ProfileStats.numBacktrackOccurrences);
        stringBuffer.append(newline);
        stringBuffer.append("Overall average k per decision event that backtracks ");
        stringBuffer.append(profiler$ProfileStats.avgkPerBacktrackingDecisionEvent);
        stringBuffer.append(newline);
        stringBuffer.append("Number of rule invocations while backtracking ");
        stringBuffer.append(profiler$ProfileStats.numGuessingRuleInvocations);
        stringBuffer.append(newline);
        stringBuffer.append("num decisions that potentially backtrack ");
        stringBuffer.append(profiler$ProfileStats.numDecisionsThatPotentiallyBacktrack);
        stringBuffer.append(newline);
        stringBuffer.append("num decisions that do backtrack ");
        stringBuffer.append(profiler$ProfileStats.numDecisionsThatDoBacktrack);
        stringBuffer.append(newline);
        stringBuffer.append("num decisions that potentially backtrack but don't ");
        stringBuffer.append(profiler$ProfileStats.numDecisionsThatPotentiallyBacktrack - profiler$ProfileStats.numDecisionsThatDoBacktrack);
        stringBuffer.append(newline);
        stringBuffer.append("average % of time a potentially backtracking decision backtracks ");
        stringBuffer.append(profiler$ProfileStats.averageDecisionPercentBacktracks);
        stringBuffer.append(newline);
        stringBuffer.append("num unique decisions covered ");
        stringBuffer.append(profiler$ProfileStats.numDecisionsCovered);
        stringBuffer.append(newline);
        stringBuffer.append("max rule invocation nesting depth ");
        stringBuffer.append(profiler$ProfileStats.maxRuleInvocationDepth);
        stringBuffer.append(newline);
        stringBuffer.append("rule memoization cache size ");
        stringBuffer.append(profiler$ProfileStats.numMemoizationCacheEntries);
        stringBuffer.append(newline);
        stringBuffer.append("number of rule memoization cache hits ");
        stringBuffer.append(profiler$ProfileStats.numMemoizationCacheHits);
        stringBuffer.append(newline);
        stringBuffer.append("number of rule memoization cache misses ");
        stringBuffer.append(profiler$ProfileStats.numMemoizationCacheMisses);
        stringBuffer.append(newline);
        stringBuffer.append("number of tokens ");
        stringBuffer.append(profiler$ProfileStats.numTokens);
        stringBuffer.append(newline);
        stringBuffer.append("number of hidden tokens ");
        stringBuffer.append(profiler$ProfileStats.numHiddenTokens);
        stringBuffer.append(newline);
        stringBuffer.append("number of char ");
        stringBuffer.append(profiler$ProfileStats.numCharsMatched);
        stringBuffer.append(newline);
        stringBuffer.append("number of hidden char ");
        stringBuffer.append(profiler$ProfileStats.numHiddenCharsMatched);
        stringBuffer.append(newline);
        stringBuffer.append("number of syntax errors ");
        stringBuffer.append(profiler$ProfileStats.numReportedErrors);
        stringBuffer.append(newline);
        return stringBuffer.toString();
    }

    public String getDecisionStatsDump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("location");
        stringBuffer.append(DATA_SEP);
        stringBuffer.append("n");
        stringBuffer.append(DATA_SEP);
        stringBuffer.append("avgk");
        stringBuffer.append(DATA_SEP);
        stringBuffer.append("maxk");
        stringBuffer.append(DATA_SEP);
        stringBuffer.append("synpred");
        stringBuffer.append(DATA_SEP);
        stringBuffer.append("sempred");
        stringBuffer.append(DATA_SEP);
        stringBuffer.append("canbacktrack");
        stringBuffer.append("\n");
        Iterator iterator = this.decisions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = this.decisions.keySet(string).iterator();
            while (iterator2.hasNext()) {
                int n2 = (Integer)iterator2.next();
                Profiler$DecisionDescriptor profiler$DecisionDescriptor = (Profiler$DecisionDescriptor)this.decisions.get(string, new Integer(n2));
                stringBuffer.append(profiler$DecisionDescriptor.decision);
                stringBuffer.append("@");
                stringBuffer.append(this.locationDescription(profiler$DecisionDescriptor.fileName, profiler$DecisionDescriptor.ruleName, profiler$DecisionDescriptor.line, profiler$DecisionDescriptor.pos));
                stringBuffer.append(DATA_SEP);
                stringBuffer.append(profiler$DecisionDescriptor.n);
                stringBuffer.append(DATA_SEP);
                stringBuffer.append(String.format("%.2f", new Float(profiler$DecisionDescriptor.avgk)));
                stringBuffer.append(DATA_SEP);
                stringBuffer.append(profiler$DecisionDescriptor.maxk);
                stringBuffer.append(DATA_SEP);
                stringBuffer.append(profiler$DecisionDescriptor.numBacktrackOccurrences);
                stringBuffer.append(DATA_SEP);
                stringBuffer.append(profiler$DecisionDescriptor.numSemPredEvals);
                stringBuffer.append(DATA_SEP);
                stringBuffer.append(profiler$DecisionDescriptor.couldBacktrack ? "1" : "0");
                stringBuffer.append(newline);
            }
        }
        return stringBuffer.toString();
    }

    protected int[] trim(int[] nArray, int n2) {
        if (n2 < nArray.length) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        return nArray;
    }

    protected int[] toArray(List list) {
        int[] nArray = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Integer n2 = (Integer)list.get(i2);
            nArray[i2] = n2;
        }
        return nArray;
    }

    public int getNumberOfHiddenTokens(int n2, int n3) {
        int n4 = 0;
        TokenStream tokenStream = this.parser.getTokenStream();
        for (int i2 = n2; i2 < tokenStream.size() && i2 <= n3; ++i2) {
            Token token = tokenStream.get(i2);
            if (token.getChannel() == 0) continue;
            ++n4;
        }
        return n4;
    }

    protected String locationDescription() {
        return this.locationDescription((String)this.currentGrammarFileName.peek(), (String)this.currentRuleName.peek(), (Integer)this.currentLine.peek(), (Integer)this.currentPos.peek());
    }

    protected String locationDescription(String string, String string2, int n2, int n3) {
        return string + ":" + n2 + ":" + n3 + "(" + string2 + ")";
    }
}

