/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;

public class DebugTreeNodeStream
implements TreeNodeStream {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;
    protected TreeNodeStream input;
    protected boolean initialStreamState = true;
    protected int lastMarker;

    public DebugTreeNodeStream(TreeNodeStream treeNodeStream, DebugEventListener debugEventListener) {
        this.input = treeNodeStream;
        this.adaptor = treeNodeStream.getTreeAdaptor();
        this.input.setUniqueNavigationNodes(true);
        this.setDebugListener(debugEventListener);
    }

    public void setDebugListener(DebugEventListener debugEventListener) {
        this.dbg = debugEventListener;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public void consume() {
        Object object = this.input.LT(1);
        this.input.consume();
        this.dbg.consumeNode(object);
    }

    public Object get(int n2) {
        return this.input.get(n2);
    }

    public Object LT(int n2) {
        Object object = this.input.LT(n2);
        int n3 = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n4 = this.adaptor.getType(object);
        this.dbg.LT(n2, object);
        return object;
    }

    public int LA(int n2) {
        Object object = this.input.LT(n2);
        int n3 = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n4 = this.adaptor.getType(object);
        this.dbg.LT(n2, object);
        return n4;
    }

    public int mark() {
        this.lastMarker = this.input.mark();
        this.dbg.mark(this.lastMarker);
        return this.lastMarker;
    }

    public int index() {
        return this.input.index();
    }

    public void rewind(int n2) {
        this.dbg.rewind(n2);
        this.input.rewind(n2);
    }

    public void rewind() {
        this.dbg.rewind();
        this.input.rewind(this.lastMarker);
    }

    public void release(int n2) {
    }

    public void seek(int n2) {
        this.input.seek(n2);
    }

    public int size() {
        return this.input.size();
    }

    public void reset() {
    }

    public Object getTreeSource() {
        return this.input;
    }

    public String getSourceName() {
        return this.getTokenStream().getSourceName();
    }

    public TokenStream getTokenStream() {
        return this.input.getTokenStream();
    }

    public void setUniqueNavigationNodes(boolean bl2) {
        this.input.setUniqueNavigationNodes(bl2);
    }

    public void replaceChildren(Object object, int n2, int n3, Object object2) {
        this.input.replaceChildren(object, n2, n3, object2);
    }

    public String toString(Object object, Object object2) {
        return this.input.toString(object, object2);
    }
}

