/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.debug.BlankDebugEventListener;
import org.antlr.runtime.tree.TreeAdaptor;

public class DebugEventSocketProxy
extends BlankDebugEventListener {
    public static final int DEFAULT_DEBUGGER_PORT = 49100;
    protected int port = 49100;
    protected ServerSocket serverSocket;
    protected Socket socket;
    protected String grammarFileName;
    protected PrintWriter out;
    protected BufferedReader in;
    protected BaseRecognizer recognizer;
    protected TreeAdaptor adaptor;

    public DebugEventSocketProxy(BaseRecognizer baseRecognizer, TreeAdaptor treeAdaptor) {
        this(baseRecognizer, 49100, treeAdaptor);
    }

    public DebugEventSocketProxy(BaseRecognizer baseRecognizer, int n2, TreeAdaptor treeAdaptor) {
        this.grammarFileName = baseRecognizer.getGrammarFileName();
        this.adaptor = treeAdaptor;
        this.port = n2;
    }

    public void handshake() {
        if (this.serverSocket == null) {
            this.serverSocket = new ServerSocket(this.port);
            this.socket = this.serverSocket.accept();
            this.socket.setTcpNoDelay(true);
            OutputStream outputStream = this.socket.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
            this.out = new PrintWriter(new BufferedWriter(outputStreamWriter));
            InputStream inputStream = this.socket.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
            this.in = new BufferedReader(inputStreamReader);
            this.out.println("ANTLR 2");
            this.out.println("grammar \"" + this.grammarFileName);
            this.out.flush();
            this.ack();
        }
    }

    public void commence() {
    }

    public void terminate() {
        this.transmit("terminate");
        this.out.close();
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    protected void ack() {
        try {
            this.in.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    protected void transmit(String string) {
        this.out.println(string);
        this.out.flush();
        this.ack();
    }

    public void enterRule(String string, String string2) {
        this.transmit("enterRule\t" + string + "\t" + string2);
    }

    public void enterAlt(int n2) {
        this.transmit("enterAlt\t" + n2);
    }

    public void exitRule(String string, String string2) {
        this.transmit("exitRule\t" + string + "\t" + string2);
    }

    public void enterSubRule(int n2) {
        this.transmit("enterSubRule\t" + n2);
    }

    public void exitSubRule(int n2) {
        this.transmit("exitSubRule\t" + n2);
    }

    public void enterDecision(int n2, boolean bl2) {
        this.transmit("enterDecision\t" + n2 + "\t" + bl2);
    }

    public void exitDecision(int n2) {
        this.transmit("exitDecision\t" + n2);
    }

    public void consumeToken(Token token) {
        String string = this.serializeToken(token);
        this.transmit("consumeToken\t" + string);
    }

    public void consumeHiddenToken(Token token) {
        String string = this.serializeToken(token);
        this.transmit("consumeHiddenToken\t" + string);
    }

    public void LT(int n2, Token token) {
        if (token != null) {
            this.transmit("LT\t" + n2 + "\t" + this.serializeToken(token));
        }
    }

    public void mark(int n2) {
        this.transmit("mark\t" + n2);
    }

    public void rewind(int n2) {
        this.transmit("rewind\t" + n2);
    }

    public void rewind() {
        this.transmit("rewind");
    }

    public void beginBacktrack(int n2) {
        this.transmit("beginBacktrack\t" + n2);
    }

    public void endBacktrack(int n2, boolean bl2) {
        this.transmit("endBacktrack\t" + n2 + "\t" + (bl2 ? 1 : 0));
    }

    public void location(int n2, int n3) {
        this.transmit("location\t" + n2 + "\t" + n3);
    }

    public void recognitionException(RecognitionException recognitionException) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("exception\t");
        stringBuffer.append(recognitionException.getClass().getName());
        stringBuffer.append("\t");
        stringBuffer.append(recognitionException.index);
        stringBuffer.append("\t");
        stringBuffer.append(recognitionException.line);
        stringBuffer.append("\t");
        stringBuffer.append(recognitionException.charPositionInLine);
        this.transmit(stringBuffer.toString());
    }

    public void beginResync() {
        this.transmit("beginResync");
    }

    public void endResync() {
        this.transmit("endResync");
    }

    public void semanticPredicate(boolean bl2, String string) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("semanticPredicate\t");
        stringBuffer.append(bl2);
        this.serializeText(stringBuffer, string);
        this.transmit(stringBuffer.toString());
    }

    public void consumeNode(Object object) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("consumeNode");
        this.serializeNode(stringBuffer, object);
        this.transmit(stringBuffer.toString());
    }

    public void LT(int n2, Object object) {
        int n3 = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n4 = this.adaptor.getType(object);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("LN\t");
        stringBuffer.append(n2);
        this.serializeNode(stringBuffer, object);
        this.transmit(stringBuffer.toString());
    }

    protected void serializeNode(StringBuffer stringBuffer, Object object) {
        int n2 = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n3 = this.adaptor.getType(object);
        stringBuffer.append("\t");
        stringBuffer.append(n2);
        stringBuffer.append("\t");
        stringBuffer.append(n3);
        Token token = this.adaptor.getToken(object);
        int n4 = -1;
        int n5 = -1;
        if (token != null) {
            n4 = token.getLine();
            n5 = token.getCharPositionInLine();
        }
        stringBuffer.append("\t");
        stringBuffer.append(n4);
        stringBuffer.append("\t");
        stringBuffer.append(n5);
        int n6 = this.adaptor.getTokenStartIndex(object);
        stringBuffer.append("\t");
        stringBuffer.append(n6);
        this.serializeText(stringBuffer, string);
    }

    public void nilNode(Object object) {
        int n2 = this.adaptor.getUniqueID(object);
        this.transmit("nilNode\t" + n2);
    }

    public void errorNode(Object object) {
        int n2 = this.adaptor.getUniqueID(object);
        String string = object.toString();
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("errorNode\t");
        stringBuffer.append(n2);
        stringBuffer.append("\t");
        stringBuffer.append(0);
        this.serializeText(stringBuffer, string);
        this.transmit(stringBuffer.toString());
    }

    public void createNode(Object object) {
        int n2 = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n3 = this.adaptor.getType(object);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("createNodeFromTokenElements\t");
        stringBuffer.append(n2);
        stringBuffer.append("\t");
        stringBuffer.append(n3);
        this.serializeText(stringBuffer, string);
        this.transmit(stringBuffer.toString());
    }

    public void createNode(Object object, Token token) {
        int n2 = this.adaptor.getUniqueID(object);
        int n3 = token.getTokenIndex();
        this.transmit("createNode\t" + n2 + "\t" + n3);
    }

    public void becomeRoot(Object object, Object object2) {
        int n2 = this.adaptor.getUniqueID(object);
        int n3 = this.adaptor.getUniqueID(object2);
        this.transmit("becomeRoot\t" + n2 + "\t" + n3);
    }

    public void addChild(Object object, Object object2) {
        int n2 = this.adaptor.getUniqueID(object);
        int n3 = this.adaptor.getUniqueID(object2);
        this.transmit("addChild\t" + n2 + "\t" + n3);
    }

    public void setTokenBoundaries(Object object, int n2, int n3) {
        int n4 = this.adaptor.getUniqueID(object);
        this.transmit("setTokenBoundaries\t" + n4 + "\t" + n2 + "\t" + n3);
    }

    public void setTreeAdaptor(TreeAdaptor treeAdaptor) {
        this.adaptor = treeAdaptor;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    protected String serializeToken(Token token) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(token.getTokenIndex());
        stringBuffer.append('\t');
        stringBuffer.append(token.getType());
        stringBuffer.append('\t');
        stringBuffer.append(token.getChannel());
        stringBuffer.append('\t');
        stringBuffer.append(token.getLine());
        stringBuffer.append('\t');
        stringBuffer.append(token.getCharPositionInLine());
        this.serializeText(stringBuffer, token.getText());
        return stringBuffer.toString();
    }

    protected void serializeText(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\t\"");
        if (string == null) {
            string = "";
        }
        string = this.escapeNewlines(string);
        stringBuffer.append(string);
    }

    protected String escapeNewlines(String string) {
        string = string.replaceAll("%", "%25");
        string = string.replaceAll("\n", "%0A");
        string = string.replaceAll("\r", "%0D");
        return string;
    }
}

