/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CharStreamState;

public class ANTLRStringStream
implements CharStream {
    protected char[] data;
    protected int n;
    protected int p = 0;
    protected int line = 1;
    protected int charPositionInLine = 0;
    protected int markDepth = 0;
    protected List markers;
    protected int lastMarker;
    public String name;

    public ANTLRStringStream() {
    }

    public ANTLRStringStream(String string) {
        this();
        this.data = string.toCharArray();
        this.n = string.length();
    }

    public ANTLRStringStream(char[] cArray, int n2) {
        this();
        this.data = cArray;
        this.n = n2;
    }

    public void reset() {
        this.p = 0;
        this.line = 1;
        this.charPositionInLine = 0;
        this.markDepth = 0;
    }

    public void consume() {
        if (this.p < this.n) {
            ++this.charPositionInLine;
            if (this.data[this.p] == '\n') {
                ++this.line;
                this.charPositionInLine = 0;
            }
            ++this.p;
        }
    }

    public int LA(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 0 && this.p + ++n2 - 1 < 0) {
            return -1;
        }
        if (this.p + n2 - 1 >= this.n) {
            return -1;
        }
        return this.data[this.p + n2 - 1];
    }

    public int LT(int n2) {
        return this.LA(n2);
    }

    public int index() {
        return this.p;
    }

    public int size() {
        return this.n;
    }

    public int mark() {
        if (this.markers == null) {
            this.markers = new ArrayList();
            this.markers.add(null);
        }
        ++this.markDepth;
        CharStreamState charStreamState = null;
        if (this.markDepth >= this.markers.size()) {
            charStreamState = new CharStreamState();
            this.markers.add(charStreamState);
        } else {
            charStreamState = (CharStreamState)this.markers.get(this.markDepth);
        }
        charStreamState.p = this.p;
        charStreamState.line = this.line;
        charStreamState.charPositionInLine = this.charPositionInLine;
        this.lastMarker = this.markDepth;
        return this.markDepth;
    }

    public void rewind(int n2) {
        CharStreamState charStreamState = (CharStreamState)this.markers.get(n2);
        this.seek(charStreamState.p);
        this.line = charStreamState.line;
        this.charPositionInLine = charStreamState.charPositionInLine;
        this.release(n2);
    }

    public void rewind() {
        this.rewind(this.lastMarker);
    }

    public void release(int n2) {
        this.markDepth = n2;
        --this.markDepth;
    }

    public void seek(int n2) {
        if (n2 <= this.p) {
            this.p = n2;
            return;
        }
        while (this.p < n2) {
            this.consume();
        }
    }

    public String substring(int n2, int n3) {
        return new String(this.data, n2, n3 - n2 + 1);
    }

    public int getLine() {
        return this.line;
    }

    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public void setLine(int n2) {
        this.line = n2;
    }

    public void setCharPositionInLine(int n2) {
        this.charPositionInLine = n2;
    }

    public String getSourceName() {
        return this.name;
    }

    public String toString() {
        return new String(this.data);
    }
}

