/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4ByteBufferUtils;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.lz4.LZ4UnsafeUtils;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.UnsafeUtils;

final class LZ4JavaUnsafeSafeDecompressor
extends LZ4SafeDecompressor {
    public static final LZ4SafeDecompressor INSTANCE = new LZ4JavaUnsafeSafeDecompressor();

    LZ4JavaUnsafeSafeDecompressor() {
    }

    @Override
    public int decompress(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6;
        UnsafeUtils.checkRange(byArray, n2, n3);
        UnsafeUtils.checkRange(byArray2, n4, n5);
        if (n5 == 0) {
            if (n3 != 1 || UnsafeUtils.readByte(byArray, n2) != 0) {
                throw new LZ4Exception("Output buffer too small");
            }
            return 0;
        }
        int n7 = n2 + n3;
        int n8 = n4 + n5;
        int n9 = n2;
        int n10 = n4;
        while (true) {
            int n11;
            int n12 = UnsafeUtils.readByte(byArray, n9) & 0xFF;
            ++n9;
            int n13 = n12 >>> 4;
            if (n13 == 15) {
                n6 = -1;
                while (n9 < n7) {
                    byte by = UnsafeUtils.readByte(byArray, n9++);
                    n6 = by;
                    if (by != -1) break;
                    n13 += 255;
                }
                n13 += n6 & 0xFF;
            }
            if ((n6 = n10 + n13) > n8 - 8 || n9 + n13 > n7 - 8) {
                if (n6 > n8) {
                    throw new LZ4Exception();
                }
                if (n9 + n13 != n7) {
                    throw new LZ4Exception("Malformed input at " + n9);
                }
                LZ4UnsafeUtils.safeArraycopy(byArray, n9, byArray2, n10, n13);
                n9 += n13;
                break;
            }
            LZ4UnsafeUtils.wildArraycopy(byArray, n9, byArray2, n10, n13);
            n10 = n6;
            int n14 = UnsafeUtils.readShortLE(byArray, n9 += n13);
            n9 += 2;
            int n15 = n10 - n14;
            if (n15 < n4) {
                throw new LZ4Exception("Malformed input at " + n9);
            }
            int n16 = n12 & 0xF;
            if (n16 == 15) {
                n11 = -1;
                while (n9 < n7) {
                    byte by = UnsafeUtils.readByte(byArray, n9++);
                    n11 = by;
                    if (by != -1) break;
                    n16 += 255;
                }
                n16 += n11 & 0xFF;
            }
            if ((n11 = n10 + (n16 += 4)) > n8 - 8) {
                if (n11 > n8) {
                    throw new LZ4Exception("Malformed input at " + n9);
                }
                LZ4UnsafeUtils.safeIncrementalCopy(byArray2, n15, n10, n16);
            } else {
                LZ4UnsafeUtils.wildIncrementalCopy(byArray2, n15, n10, n11);
            }
            n10 = n11;
        }
        n10 = n6;
        return n10 - n4;
    }

    @Override
    public int decompress(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) {
        int n6;
        if (byteBuffer.hasArray() && byteBuffer2.hasArray()) {
            return this.decompress(byteBuffer.array(), n2 + byteBuffer.arrayOffset(), n3, byteBuffer2.array(), n4 + byteBuffer2.arrayOffset(), n5);
        }
        byteBuffer = ByteBufferUtils.inNativeByteOrder(byteBuffer);
        byteBuffer2 = ByteBufferUtils.inNativeByteOrder(byteBuffer2);
        ByteBufferUtils.checkRange(byteBuffer, n2, n3);
        ByteBufferUtils.checkRange(byteBuffer2, n4, n5);
        if (n5 == 0) {
            if (n3 != 1 || ByteBufferUtils.readByte(byteBuffer, n2) != 0) {
                throw new LZ4Exception("Output buffer too small");
            }
            return 0;
        }
        int n7 = n2 + n3;
        int n8 = n4 + n5;
        int n9 = n2;
        int n10 = n4;
        while (true) {
            int n11;
            int n12 = ByteBufferUtils.readByte(byteBuffer, n9) & 0xFF;
            ++n9;
            int n13 = n12 >>> 4;
            if (n13 == 15) {
                n6 = -1;
                while (n9 < n7) {
                    byte by = ByteBufferUtils.readByte(byteBuffer, n9++);
                    n6 = by;
                    if (by != -1) break;
                    n13 += 255;
                }
                n13 += n6 & 0xFF;
            }
            if ((n6 = n10 + n13) > n8 - 8 || n9 + n13 > n7 - 8) {
                if (n6 > n8) {
                    throw new LZ4Exception();
                }
                if (n9 + n13 != n7) {
                    throw new LZ4Exception("Malformed input at " + n9);
                }
                LZ4ByteBufferUtils.safeArraycopy(byteBuffer, n9, byteBuffer2, n10, n13);
                n9 += n13;
                break;
            }
            LZ4ByteBufferUtils.wildArraycopy(byteBuffer, n9, byteBuffer2, n10, n13);
            n10 = n6;
            int n14 = ByteBufferUtils.readShortLE(byteBuffer, n9 += n13);
            n9 += 2;
            int n15 = n10 - n14;
            if (n15 < n4) {
                throw new LZ4Exception("Malformed input at " + n9);
            }
            int n16 = n12 & 0xF;
            if (n16 == 15) {
                n11 = -1;
                while (n9 < n7) {
                    byte by = ByteBufferUtils.readByte(byteBuffer, n9++);
                    n11 = by;
                    if (by != -1) break;
                    n16 += 255;
                }
                n16 += n11 & 0xFF;
            }
            if ((n11 = n10 + (n16 += 4)) > n8 - 8) {
                if (n11 > n8) {
                    throw new LZ4Exception("Malformed input at " + n9);
                }
                LZ4ByteBufferUtils.safeIncrementalCopy(byteBuffer2, n15, n10, n16);
            } else {
                LZ4ByteBufferUtils.wildIncrementalCopy(byteBuffer2, n15, n10, n11);
            }
            n10 = n11;
        }
        n10 = n6;
        return n10 - n4;
    }
}

