/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jpountz.lz4.LZ4ByteBufferUtils;
import net.jpountz.lz4.LZ4HCJavaUnsafeCompressor;
import net.jpountz.lz4.LZ4UnsafeUtils;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.lz4.LZ4Utils$Match;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.UnsafeUtils;

class LZ4HCJavaUnsafeCompressor$HashTable {
    static final int MASK = 65535;
    int nextToUpdate;
    private final int base;
    private final int[] hashTable;
    private final short[] chainTable;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ LZ4HCJavaUnsafeCompressor this$0;

    LZ4HCJavaUnsafeCompressor$HashTable(LZ4HCJavaUnsafeCompressor lZ4HCJavaUnsafeCompressor, int n2) {
        this.this$0 = lZ4HCJavaUnsafeCompressor;
        this.base = n2;
        this.nextToUpdate = n2;
        this.hashTable = new int[32768];
        Arrays.fill(this.hashTable, -1);
        this.chainTable = new short[65536];
    }

    private int hashPointer(byte[] byArray, int n2) {
        int n3 = UnsafeUtils.readInt(byArray, n2);
        return this.hashPointer(n3);
    }

    private int hashPointer(ByteBuffer byteBuffer, int n2) {
        int n3 = ByteBufferUtils.readInt(byteBuffer, n2);
        return this.hashPointer(n3);
    }

    private int hashPointer(int n2) {
        int n3 = LZ4Utils.hashHC(n2);
        return this.hashTable[n3];
    }

    private int next(int n2) {
        return n2 - (this.chainTable[n2 & 0xFFFF] & 0xFFFF);
    }

    private void addHash(byte[] byArray, int n2) {
        int n3 = UnsafeUtils.readInt(byArray, n2);
        this.addHash(n3, n2);
    }

    private void addHash(ByteBuffer byteBuffer, int n2) {
        int n3 = ByteBufferUtils.readInt(byteBuffer, n2);
        this.addHash(n3, n2);
    }

    private void addHash(int n2, int n3) {
        int n4 = LZ4Utils.hashHC(n2);
        int n5 = n3 - this.hashTable[n4];
        if (!$assertionsDisabled && n5 <= 0) {
            throw new AssertionError(n5);
        }
        if (n5 >= 65536) {
            n5 = 65535;
        }
        this.chainTable[n3 & 0xFFFF] = (short)n5;
        this.hashTable[n4] = n3;
    }

    void insert(int n2, byte[] byArray) {
        while (this.nextToUpdate < n2) {
            this.addHash(byArray, this.nextToUpdate);
            ++this.nextToUpdate;
        }
    }

    void insert(int n2, ByteBuffer byteBuffer) {
        while (this.nextToUpdate < n2) {
            this.addHash(byteBuffer, this.nextToUpdate);
            ++this.nextToUpdate;
        }
    }

    boolean insertAndFindBestMatch(byte[] byArray, int n2, int n3, LZ4Utils$Match lZ4Utils$Match) {
        int n4;
        int n5;
        lZ4Utils$Match.start = n2;
        lZ4Utils$Match.len = 0;
        int n6 = 0;
        int n7 = 0;
        this.insert(n2, byArray);
        int n8 = this.hashPointer(byArray, n2);
        if (n8 >= n2 - 4 && n8 <= n2 && n8 >= this.base) {
            if (LZ4UnsafeUtils.readIntEquals(byArray, n8, n2)) {
                n6 = n2 - n8;
                n7 = lZ4Utils$Match.len = 4 + LZ4UnsafeUtils.commonBytes(byArray, n8 + 4, n2 + 4, n3);
                lZ4Utils$Match.ref = n8;
            }
            n8 = this.next(n8);
        }
        for (n5 = 0; n5 < LZ4HCJavaUnsafeCompressor.access$000(this.this$0) && n8 >= Math.max(this.base, n2 - 65536 + 1) && n8 <= n2; ++n5) {
            if (LZ4UnsafeUtils.readIntEquals(byArray, n8, n2) && (n4 = 4 + LZ4UnsafeUtils.commonBytes(byArray, n8 + 4, n2 + 4, n3)) > lZ4Utils$Match.len) {
                lZ4Utils$Match.ref = n8;
                lZ4Utils$Match.len = n4;
            }
            n8 = this.next(n8);
        }
        if (n7 != 0) {
            n4 = n2 + n7 - 3;
            for (n5 = n2; n5 < n4 - n6; ++n5) {
                this.chainTable[n5 & 0xFFFF] = (short)n6;
            }
            do {
                this.chainTable[n5 & 0xFFFF] = (short)n6;
                this.hashTable[LZ4Utils.hashHC((int)UnsafeUtils.readInt((byte[])byArray, (int)n5))] = n5;
            } while (++n5 < n4);
            this.nextToUpdate = n4;
        }
        return lZ4Utils$Match.len != 0;
    }

    boolean insertAndFindWiderMatch(byte[] byArray, int n2, int n3, int n4, int n5, LZ4Utils$Match lZ4Utils$Match) {
        lZ4Utils$Match.len = n5;
        this.insert(n2, byArray);
        int n6 = n2 - n3;
        int n7 = this.hashPointer(byArray, n2);
        for (int i2 = 0; i2 < LZ4HCJavaUnsafeCompressor.access$000(this.this$0) && n7 >= Math.max(this.base, n2 - 65536 + 1) && n7 <= n2; ++i2) {
            if (LZ4UnsafeUtils.readIntEquals(byArray, n7, n2)) {
                int n8 = 4 + LZ4UnsafeUtils.commonBytes(byArray, n7 + 4, n2 + 4, n4);
                int n9 = LZ4UnsafeUtils.commonBytesBackward(byArray, n7, n2, this.base, n3);
                int n10 = n9 + n8;
                if (n10 > lZ4Utils$Match.len) {
                    lZ4Utils$Match.len = n10;
                    lZ4Utils$Match.ref = n7 - n9;
                    lZ4Utils$Match.start = n2 - n9;
                }
            }
            n7 = this.next(n7);
        }
        return lZ4Utils$Match.len > n5;
    }

    boolean insertAndFindBestMatch(ByteBuffer byteBuffer, int n2, int n3, LZ4Utils$Match lZ4Utils$Match) {
        int n4;
        int n5;
        lZ4Utils$Match.start = n2;
        lZ4Utils$Match.len = 0;
        int n6 = 0;
        int n7 = 0;
        this.insert(n2, byteBuffer);
        int n8 = this.hashPointer(byteBuffer, n2);
        if (n8 >= n2 - 4 && n8 <= n2 && n8 >= this.base) {
            if (LZ4ByteBufferUtils.readIntEquals(byteBuffer, n8, n2)) {
                n6 = n2 - n8;
                n7 = lZ4Utils$Match.len = 4 + LZ4ByteBufferUtils.commonBytes(byteBuffer, n8 + 4, n2 + 4, n3);
                lZ4Utils$Match.ref = n8;
            }
            n8 = this.next(n8);
        }
        for (n5 = 0; n5 < LZ4HCJavaUnsafeCompressor.access$000(this.this$0) && n8 >= Math.max(this.base, n2 - 65536 + 1) && n8 <= n2; ++n5) {
            if (LZ4ByteBufferUtils.readIntEquals(byteBuffer, n8, n2) && (n4 = 4 + LZ4ByteBufferUtils.commonBytes(byteBuffer, n8 + 4, n2 + 4, n3)) > lZ4Utils$Match.len) {
                lZ4Utils$Match.ref = n8;
                lZ4Utils$Match.len = n4;
            }
            n8 = this.next(n8);
        }
        if (n7 != 0) {
            n4 = n2 + n7 - 3;
            for (n5 = n2; n5 < n4 - n6; ++n5) {
                this.chainTable[n5 & 0xFFFF] = (short)n6;
            }
            do {
                this.chainTable[n5 & 0xFFFF] = (short)n6;
                this.hashTable[LZ4Utils.hashHC((int)ByteBufferUtils.readInt((ByteBuffer)byteBuffer, (int)n5))] = n5;
            } while (++n5 < n4);
            this.nextToUpdate = n4;
        }
        return lZ4Utils$Match.len != 0;
    }

    boolean insertAndFindWiderMatch(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, LZ4Utils$Match lZ4Utils$Match) {
        lZ4Utils$Match.len = n5;
        this.insert(n2, byteBuffer);
        int n6 = n2 - n3;
        int n7 = this.hashPointer(byteBuffer, n2);
        for (int i2 = 0; i2 < LZ4HCJavaUnsafeCompressor.access$000(this.this$0) && n7 >= Math.max(this.base, n2 - 65536 + 1) && n7 <= n2; ++i2) {
            if (LZ4ByteBufferUtils.readIntEquals(byteBuffer, n7, n2)) {
                int n8 = 4 + LZ4ByteBufferUtils.commonBytes(byteBuffer, n7 + 4, n2 + 4, n4);
                int n9 = LZ4ByteBufferUtils.commonBytesBackward(byteBuffer, n7, n2, this.base, n3);
                int n10 = n9 + n8;
                if (n10 > lZ4Utils$Match.len) {
                    lZ4Utils$Match.len = n10;
                    lZ4Utils$Match.ref = n7 - n9;
                    lZ4Utils$Match.start = n2 - n9;
                }
            }
            n7 = this.next(n7);
        }
        return lZ4Utils$Match.len > n5;
    }

    static {
        $assertionsDisabled = !LZ4HCJavaUnsafeCompressor.class.desiredAssertionStatus();
    }
}

