/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FrameOutputStream$BD;
import net.jpountz.lz4.LZ4FrameOutputStream$BLOCKSIZE;
import net.jpountz.lz4.LZ4FrameOutputStream$FLG;
import net.jpountz.lz4.LZ4FrameOutputStream$FLG$Bits;
import net.jpountz.lz4.LZ4FrameOutputStream$FrameInfo;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;

public class LZ4FrameOutputStream
extends FilterOutputStream {
    static final int INTEGER_BYTES = 4;
    static final int LONG_BYTES = 8;
    static final int MAGIC = 407708164;
    static final int LZ4_MAX_HEADER_LENGTH = 15;
    static final int LZ4_FRAME_INCOMPRESSIBLE_MASK = Integer.MIN_VALUE;
    static final LZ4FrameOutputStream$FLG$Bits[] DEFAULT_FEATURES = new LZ4FrameOutputStream$FLG$Bits[]{LZ4FrameOutputStream$FLG$Bits.BLOCK_INDEPENDENCE};
    static final String CLOSED_STREAM = "The stream is already closed";
    private final LZ4Compressor compressor;
    private final XXHash32 checksum;
    private final ByteBuffer buffer;
    private final byte[] compressedBuffer;
    private final int maxBlockSize;
    private final long knownSize;
    private final ByteBuffer intLEBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
    private LZ4FrameOutputStream$FrameInfo frameInfo = null;

    public LZ4FrameOutputStream(OutputStream outputStream, LZ4FrameOutputStream$BLOCKSIZE lZ4FrameOutputStream$BLOCKSIZE, LZ4FrameOutputStream$FLG$Bits ... lZ4FrameOutputStream$FLG$BitsArray) {
        this(outputStream, lZ4FrameOutputStream$BLOCKSIZE, -1L, lZ4FrameOutputStream$FLG$BitsArray);
    }

    public LZ4FrameOutputStream(OutputStream outputStream, LZ4FrameOutputStream$BLOCKSIZE lZ4FrameOutputStream$BLOCKSIZE, long l2, LZ4FrameOutputStream$FLG$Bits ... lZ4FrameOutputStream$FLG$BitsArray) {
        super(outputStream);
        this.compressor = LZ4Factory.fastestInstance().fastCompressor();
        this.checksum = XXHashFactory.fastestInstance().hash32();
        this.frameInfo = new LZ4FrameOutputStream$FrameInfo(new LZ4FrameOutputStream$FLG(1, lZ4FrameOutputStream$FLG$BitsArray), new LZ4FrameOutputStream$BD(lZ4FrameOutputStream$BLOCKSIZE));
        this.maxBlockSize = this.frameInfo.getBD().getBlockMaximumSize();
        this.buffer = ByteBuffer.allocate(this.maxBlockSize).order(ByteOrder.LITTLE_ENDIAN);
        this.compressedBuffer = new byte[this.compressor.maxCompressedLength(this.maxBlockSize)];
        if (this.frameInfo.getFLG().isEnabled(LZ4FrameOutputStream$FLG$Bits.CONTENT_SIZE) && l2 < 0L) {
            throw new IllegalArgumentException("Known size must be greater than zero in order to use the known size feature");
        }
        this.knownSize = l2;
        this.writeHeader();
    }

    public LZ4FrameOutputStream(OutputStream outputStream, LZ4FrameOutputStream$BLOCKSIZE lZ4FrameOutputStream$BLOCKSIZE) {
        this(outputStream, lZ4FrameOutputStream$BLOCKSIZE, DEFAULT_FEATURES);
    }

    public LZ4FrameOutputStream(OutputStream outputStream) {
        this(outputStream, LZ4FrameOutputStream$BLOCKSIZE.SIZE_4MB);
    }

    private void writeHeader() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(15).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(407708164);
        byteBuffer.put(this.frameInfo.getFLG().toByte());
        byteBuffer.put(this.frameInfo.getBD().toByte());
        if (this.frameInfo.isEnabled(LZ4FrameOutputStream$FLG$Bits.CONTENT_SIZE)) {
            byteBuffer.putLong(this.knownSize);
        }
        int n2 = this.checksum.hash(byteBuffer.array(), 4, byteBuffer.position() - 4, 0) >> 8 & 0xFF;
        byteBuffer.put((byte)n2);
        this.out.write(byteBuffer.array(), 0, byteBuffer.position());
    }

    private void writeBlock() {
        int n2;
        byte[] byArray;
        if (this.buffer.position() == 0) {
            return;
        }
        Arrays.fill(this.compressedBuffer, (byte)0);
        int n3 = this.compressor.compress(this.buffer.array(), 0, this.buffer.position(), this.compressedBuffer, 0);
        if (n3 >= this.buffer.position()) {
            n3 = this.buffer.position();
            byArray = Arrays.copyOf(this.buffer.array(), n3);
            n2 = Integer.MIN_VALUE;
        } else {
            byArray = this.compressedBuffer;
            n2 = 0;
        }
        this.intLEBuffer.putInt(0, n3 | n2);
        this.out.write(this.intLEBuffer.array());
        this.out.write(byArray, 0, n3);
        if (this.frameInfo.isEnabled(LZ4FrameOutputStream$FLG$Bits.BLOCK_CHECKSUM)) {
            this.intLEBuffer.putInt(0, this.checksum.hash(byArray, 0, n3, 0));
            this.out.write(this.intLEBuffer.array());
        }
        this.buffer.rewind();
    }

    private void writeEndMark() {
        this.intLEBuffer.putInt(0, 0);
        this.out.write(this.intLEBuffer.array());
        if (this.frameInfo.isEnabled(LZ4FrameOutputStream$FLG$Bits.CONTENT_CHECKSUM)) {
            this.intLEBuffer.putInt(0, this.frameInfo.currentStreamHash());
            this.out.write(this.intLEBuffer.array());
        }
        this.frameInfo.finish();
    }

    @Override
    public void write(int n2) {
        this.ensureNotFinished();
        if (this.buffer.position() == this.maxBlockSize) {
            this.writeBlock();
        }
        this.buffer.put((byte)n2);
        if (this.frameInfo.isEnabled(LZ4FrameOutputStream$FLG$Bits.CONTENT_CHECKSUM)) {
            this.frameInfo.updateStreamHash(new byte[]{(byte)n2}, 0, 1);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureNotFinished();
        while (n3 > this.buffer.remaining()) {
            int n4 = this.buffer.remaining();
            this.buffer.put(byArray, n2, n4);
            if (this.frameInfo.isEnabled(LZ4FrameOutputStream$FLG$Bits.CONTENT_CHECKSUM)) {
                this.frameInfo.updateStreamHash(byArray, n2, n4);
            }
            this.writeBlock();
            n2 += n4;
            n3 -= n4;
        }
        this.buffer.put(byArray, n2, n3);
        if (this.frameInfo.isEnabled(LZ4FrameOutputStream$FLG$Bits.CONTENT_CHECKSUM)) {
            this.frameInfo.updateStreamHash(byArray, n2, n3);
        }
    }

    @Override
    public void flush() {
        if (!this.frameInfo.isFinished()) {
            this.writeBlock();
        }
        super.flush();
    }

    private void ensureNotFinished() {
        if (this.frameInfo.isFinished()) {
            throw new IllegalStateException(CLOSED_STREAM);
        }
    }

    @Override
    public void close() {
        if (!this.frameInfo.isFinished()) {
            this.flush();
            this.writeEndMark();
        }
        super.close();
    }
}

