/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Decompressor;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.lz4.LZ4UnknownSizeDecompressor;
import net.jpountz.util.Native;
import net.jpountz.util.Utils;

public final class LZ4Factory {
    private static LZ4Factory NATIVE_INSTANCE;
    private static LZ4Factory JAVA_UNSAFE_INSTANCE;
    private static LZ4Factory JAVA_SAFE_INSTANCE;
    private final String impl;
    private final LZ4Compressor fastCompressor;
    private final LZ4Compressor highCompressor;
    private final LZ4FastDecompressor fastDecompressor;
    private final LZ4SafeDecompressor safeDecompressor;
    private final LZ4Compressor[] highCompressors = new LZ4Compressor[18];

    private static LZ4Factory instance(String string) {
        try {
            return new LZ4Factory(string);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static synchronized LZ4Factory nativeInstance() {
        if (NATIVE_INSTANCE == null) {
            NATIVE_INSTANCE = LZ4Factory.instance("JNI");
        }
        return NATIVE_INSTANCE;
    }

    public static synchronized LZ4Factory safeInstance() {
        if (JAVA_SAFE_INSTANCE == null) {
            JAVA_SAFE_INSTANCE = LZ4Factory.instance("JavaSafe");
        }
        return JAVA_SAFE_INSTANCE;
    }

    public static synchronized LZ4Factory unsafeInstance() {
        if (JAVA_UNSAFE_INSTANCE == null) {
            JAVA_UNSAFE_INSTANCE = LZ4Factory.instance("JavaUnsafe");
        }
        return JAVA_UNSAFE_INSTANCE;
    }

    public static LZ4Factory fastestJavaInstance() {
        if (Utils.isUnalignedAccessAllowed()) {
            try {
                return LZ4Factory.unsafeInstance();
            }
            catch (Throwable throwable) {
                return LZ4Factory.safeInstance();
            }
        }
        return LZ4Factory.safeInstance();
    }

    public static LZ4Factory fastestInstance() {
        if (Native.isLoaded() || Native.class.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            try {
                return LZ4Factory.nativeInstance();
            }
            catch (Throwable throwable) {
                return LZ4Factory.fastestJavaInstance();
            }
        }
        return LZ4Factory.fastestJavaInstance();
    }

    private static Object classInstance(String string) {
        ClassLoader classLoader = LZ4Factory.class.getClassLoader();
        classLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        Class<?> clazz = classLoader.loadClass(string);
        Field field = clazz.getField("INSTANCE");
        return field.get(null);
    }

    private LZ4Factory(String string) {
        this.impl = string;
        this.fastCompressor = (LZ4Compressor)LZ4Factory.classInstance("net.jpountz.lz4.LZ4" + string + "Compressor");
        this.highCompressor = (LZ4Compressor)LZ4Factory.classInstance("net.jpountz.lz4.LZ4HC" + string + "Compressor");
        this.fastDecompressor = (LZ4FastDecompressor)LZ4Factory.classInstance("net.jpountz.lz4.LZ4" + string + "FastDecompressor");
        this.safeDecompressor = (LZ4SafeDecompressor)LZ4Factory.classInstance("net.jpountz.lz4.LZ4" + string + "SafeDecompressor");
        Constructor<?> constructor = this.highCompressor.getClass().getDeclaredConstructor(Integer.TYPE);
        this.highCompressors[9] = this.highCompressor;
        for (int i2 = 1; i2 <= 17; ++i2) {
            if (i2 == 9) continue;
            this.highCompressors[i2] = (LZ4Compressor)constructor.newInstance(i2);
        }
        byte[] byArray = new byte[]{97, 98, 99, 100, 32, 32, 32, 32, 32, 32, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106};
        for (LZ4Compressor lZ4Compressor : Arrays.asList(this.fastCompressor, this.highCompressor)) {
            int n2 = lZ4Compressor.maxCompressedLength(byArray.length);
            byte[] byArray2 = new byte[n2];
            int n3 = lZ4Compressor.compress(byArray, 0, byArray.length, byArray2, 0, n2);
            byte[] byArray3 = new byte[byArray.length];
            this.fastDecompressor.decompress(byArray2, 0, byArray3, 0, byArray.length);
            if (!Arrays.equals(byArray, byArray3)) {
                throw new AssertionError();
            }
            Arrays.fill(byArray3, (byte)0);
            int n4 = this.safeDecompressor.decompress(byArray2, 0, n3, byArray3, 0);
            if (n4 != byArray.length || !Arrays.equals(byArray, byArray3)) {
                throw new AssertionError();
            }
        }
    }

    public LZ4Compressor fastCompressor() {
        return this.fastCompressor;
    }

    public LZ4Compressor highCompressor() {
        return this.highCompressor;
    }

    public LZ4Compressor highCompressor(int n2) {
        if (n2 > 17) {
            n2 = 17;
        } else if (n2 < 1) {
            n2 = 9;
        }
        return this.highCompressors[n2];
    }

    public LZ4FastDecompressor fastDecompressor() {
        return this.fastDecompressor;
    }

    public LZ4SafeDecompressor safeDecompressor() {
        return this.safeDecompressor;
    }

    public LZ4UnknownSizeDecompressor unknownSizeDecompressor() {
        return this.safeDecompressor();
    }

    public LZ4Decompressor decompressor() {
        return this.fastDecompressor();
    }

    public static void main(String[] stringArray) {
        System.out.println("Fastest instance is " + LZ4Factory.fastestInstance());
        System.out.println("Fastest Java instance is " + LZ4Factory.fastestJavaInstance());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.impl;
    }
}

