/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jpountz.lz4.LZ4ByteBufferUtils$Match;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.util.ByteBufferUtils;

final class LZ4ByteBufferUtils
extends Enum {
    private static final /* synthetic */ LZ4ByteBufferUtils[] $VALUES;

    public static LZ4ByteBufferUtils[] values() {
        return (LZ4ByteBufferUtils[])$VALUES.clone();
    }

    public static LZ4ByteBufferUtils valueOf(String string) {
        return Enum.valueOf(LZ4ByteBufferUtils.class, string);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private LZ4ByteBufferUtils() {
        void var2_-1;
        void var1_-1;
    }

    static int hash(ByteBuffer byteBuffer, int n2) {
        return LZ4Utils.hash(ByteBufferUtils.readInt(byteBuffer, n2));
    }

    static int hash64k(ByteBuffer byteBuffer, int n2) {
        return LZ4Utils.hash64k(ByteBufferUtils.readInt(byteBuffer, n2));
    }

    static boolean readIntEquals(ByteBuffer byteBuffer, int n2, int n3) {
        return byteBuffer.getInt(n2) == byteBuffer.getInt(n3);
    }

    static void safeIncrementalCopy(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            byteBuffer.put(n3 + i2, byteBuffer.get(n2 + i2));
        }
    }

    static void wildIncrementalCopy(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        if (n3 - n2 < 4) {
            int n5;
            for (n5 = 0; n5 < 4; ++n5) {
                ByteBufferUtils.writeByte(byteBuffer, n3 + n5, ByteBufferUtils.readByte(byteBuffer, n2 + n5));
            }
            n5 = 0;
            assert ((n3 += 4) >= (n2 += 4) && n3 - n2 < 8);
            switch (n3 - n2) {
                case 1: {
                    n2 -= 3;
                    break;
                }
                case 2: {
                    n2 -= 2;
                    break;
                }
                case 3: {
                    n2 -= 3;
                    n5 = -1;
                    break;
                }
                case 5: {
                    n5 = 1;
                    break;
                }
                case 6: {
                    n5 = 2;
                    break;
                }
                case 7: {
                    n5 = 3;
                    break;
                }
            }
            ByteBufferUtils.writeInt(byteBuffer, n3, ByteBufferUtils.readInt(byteBuffer, n2));
            n3 += 4;
            n2 -= n5;
        } else if (n3 - n2 < 8) {
            ByteBufferUtils.writeLong(byteBuffer, n3, ByteBufferUtils.readLong(byteBuffer, n2));
            n3 += n3 - n2;
        }
        while (n3 < n4) {
            ByteBufferUtils.writeLong(byteBuffer, n3, ByteBufferUtils.readLong(byteBuffer, n2));
            n3 += 8;
            n2 += 8;
        }
    }

    static int commonBytes(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        int n5 = 0;
        while (n3 <= n4 - 8) {
            if (ByteBufferUtils.readLong(byteBuffer, n3) == ByteBufferUtils.readLong(byteBuffer, n2)) {
                n5 += 8;
                n2 += 8;
                n3 += 8;
                continue;
            }
            int n6 = byteBuffer.order() == ByteOrder.BIG_ENDIAN ? Long.numberOfLeadingZeros(ByteBufferUtils.readLong(byteBuffer, n3) ^ ByteBufferUtils.readLong(byteBuffer, n2)) : Long.numberOfTrailingZeros(ByteBufferUtils.readLong(byteBuffer, n3) ^ ByteBufferUtils.readLong(byteBuffer, n2));
            return n5 + (n6 >>> 3);
        }
        while (n3 < n4 && ByteBufferUtils.readByte(byteBuffer, n2++) == ByteBufferUtils.readByte(byteBuffer, n3++)) {
            ++n5;
        }
        return n5;
    }

    static int commonBytesBackward(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        while (n2 > n4 && n3 > n5 && byteBuffer.get(--n2) == byteBuffer.get(--n3)) {
            ++n6;
        }
        return n6;
    }

    static void safeArraycopy(ByteBuffer byteBuffer, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            byteBuffer2.put(n3 + i2, byteBuffer.get(n2 + i2));
        }
    }

    static void wildArraycopy(ByteBuffer byteBuffer, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        assert (byteBuffer.order().equals(byteBuffer2.order()));
        try {
            for (int i2 = 0; i2 < n4; i2 += 8) {
                byteBuffer2.putLong(n3 + i2, byteBuffer.getLong(n2 + i2));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new LZ4Exception("Malformed input at offset " + n2);
        }
    }

    static int encodeSequence(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, ByteBuffer byteBuffer2, int n6, int n7) {
        int n8;
        int n9 = n3 - n2;
        int n10 = n6++;
        if (n6 + n9 + 8 + (n9 >>> 8) > n7) {
            throw new LZ4Exception("maxDestLen is too small");
        }
        if (n9 >= 15) {
            n8 = -16;
            n6 = LZ4ByteBufferUtils.writeLen(n9 - 15, byteBuffer2, n6);
        } else {
            n8 = n9 << 4;
        }
        LZ4ByteBufferUtils.wildArraycopy(byteBuffer, n2, byteBuffer2, n6, n9);
        n6 += n9;
        int n11 = n3 - n4;
        byteBuffer2.put(n6++, (byte)n11);
        byteBuffer2.put(n6++, (byte)(n11 >>> 8));
        if (n6 + 6 + ((n5 -= 4) >>> 8) > n7) {
            throw new LZ4Exception("maxDestLen is too small");
        }
        if (n5 >= 15) {
            n8 |= 0xF;
            n6 = LZ4ByteBufferUtils.writeLen(n5 - 15, byteBuffer2, n6);
        } else {
            n8 |= n5;
        }
        byteBuffer2.put(n10, (byte)n8);
        return n6;
    }

    static int lastLiterals(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) {
        int n6 = n3;
        if (n4 + n6 + 1 + (n6 + 255 - 15) / 255 > n5) {
            throw new LZ4Exception();
        }
        if (n6 >= 15) {
            byteBuffer2.put(n4++, (byte)-16);
            n4 = LZ4ByteBufferUtils.writeLen(n6 - 15, byteBuffer2, n4);
        } else {
            byteBuffer2.put(n4++, (byte)(n6 << 4));
        }
        LZ4ByteBufferUtils.safeArraycopy(byteBuffer, n2, byteBuffer2, n4, n6);
        return n4 += n6;
    }

    static int writeLen(int n2, ByteBuffer byteBuffer, int n3) {
        while (n2 >= 255) {
            byteBuffer.put(n3++, (byte)-1);
            n2 -= 255;
        }
        byteBuffer.put(n3++, (byte)n2);
        return n3;
    }

    static void copyTo(LZ4ByteBufferUtils$Match lZ4ByteBufferUtils$Match, LZ4ByteBufferUtils$Match lZ4ByteBufferUtils$Match2) {
        lZ4ByteBufferUtils$Match2.len = lZ4ByteBufferUtils$Match.len;
        lZ4ByteBufferUtils$Match2.start = lZ4ByteBufferUtils$Match.start;
        lZ4ByteBufferUtils$Match2.ref = lZ4ByteBufferUtils$Match.ref;
    }

    static {
        $VALUES = new LZ4ByteBufferUtils[0];
    }
}

