/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.util.SafeUtils;
import net.jpountz.xxhash.XXHashFactory;

public final class LZ4BlockOutputStream
extends FilterOutputStream {
    static final byte[] MAGIC = new byte[]{76, 90, 52, 66, 108, 111, 99, 107};
    static final int MAGIC_LENGTH = MAGIC.length;
    static final int HEADER_LENGTH = MAGIC_LENGTH + 1 + 4 + 4 + 4;
    static final int COMPRESSION_LEVEL_BASE = 10;
    static final int MIN_BLOCK_SIZE = 64;
    static final int MAX_BLOCK_SIZE = 0x2000000;
    static final int COMPRESSION_METHOD_RAW = 16;
    static final int COMPRESSION_METHOD_LZ4 = 32;
    static final int DEFAULT_SEED = -1756908916;
    private final int blockSize;
    private final int compressionLevel;
    private final LZ4Compressor compressor;
    private final Checksum checksum;
    private final byte[] buffer;
    private final byte[] compressedBuffer;
    private final boolean syncFlush;
    private boolean finished;
    private int o;

    private static int compressionLevel(int n2) {
        if (n2 < 64) {
            throw new IllegalArgumentException("blockSize must be >= 64, got " + n2);
        }
        if (n2 > 0x2000000) {
            throw new IllegalArgumentException("blockSize must be <= 33554432, got " + n2);
        }
        int n3 = 32 - Integer.numberOfLeadingZeros(n2 - 1);
        assert (1 << n3 >= n2);
        assert (n2 * 2 > 1 << n3);
        n3 = Math.max(0, n3 - 10);
        assert (n3 >= 0 && n3 <= 15);
        return n3;
    }

    public LZ4BlockOutputStream(OutputStream outputStream, int n2, LZ4Compressor lZ4Compressor, Checksum checksum, boolean bl2) {
        super(outputStream);
        this.blockSize = n2;
        this.compressor = lZ4Compressor;
        this.checksum = checksum;
        this.compressionLevel = LZ4BlockOutputStream.compressionLevel(n2);
        this.buffer = new byte[n2];
        int n3 = HEADER_LENGTH + lZ4Compressor.maxCompressedLength(n2);
        this.compressedBuffer = new byte[n3];
        this.syncFlush = bl2;
        this.o = 0;
        this.finished = false;
        System.arraycopy(MAGIC, 0, this.compressedBuffer, 0, MAGIC_LENGTH);
    }

    public LZ4BlockOutputStream(OutputStream outputStream, int n2, LZ4Compressor lZ4Compressor) {
        this(outputStream, n2, lZ4Compressor, XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum(), false);
    }

    public LZ4BlockOutputStream(OutputStream outputStream, int n2) {
        this(outputStream, n2, LZ4Factory.fastestInstance().fastCompressor());
    }

    public LZ4BlockOutputStream(OutputStream outputStream) {
        this(outputStream, 65536);
    }

    private void ensureNotFinished() {
        if (this.finished) {
            throw new IllegalStateException("This stream is already closed");
        }
    }

    @Override
    public void write(int n2) {
        this.ensureNotFinished();
        if (this.o == this.blockSize) {
            this.flushBufferedData();
        }
        this.buffer[this.o++] = (byte)n2;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        SafeUtils.checkRange(byArray, n2, n3);
        this.ensureNotFinished();
        while (this.o + n3 > this.blockSize) {
            int n4 = this.blockSize - this.o;
            System.arraycopy(byArray, n2, this.buffer, this.o, this.blockSize - this.o);
            this.o = this.blockSize;
            this.flushBufferedData();
            n2 += n4;
            n3 -= n4;
        }
        System.arraycopy(byArray, n2, this.buffer, this.o, n3);
        this.o += n3;
    }

    @Override
    public void write(byte[] byArray) {
        this.ensureNotFinished();
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void close() {
        if (!this.finished) {
            this.finish();
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    private void flushBufferedData() {
        int n2;
        if (this.o == 0) {
            return;
        }
        this.checksum.reset();
        this.checksum.update(this.buffer, 0, this.o);
        int n3 = (int)this.checksum.getValue();
        int n4 = this.compressor.compress(this.buffer, 0, this.o, this.compressedBuffer, HEADER_LENGTH);
        if (n4 >= this.o) {
            n2 = 16;
            n4 = this.o;
            System.arraycopy(this.buffer, 0, this.compressedBuffer, HEADER_LENGTH, this.o);
        } else {
            n2 = 32;
        }
        this.compressedBuffer[LZ4BlockOutputStream.MAGIC_LENGTH] = (byte)(n2 | this.compressionLevel);
        LZ4BlockOutputStream.writeIntLE(n4, this.compressedBuffer, MAGIC_LENGTH + 1);
        LZ4BlockOutputStream.writeIntLE(this.o, this.compressedBuffer, MAGIC_LENGTH + 5);
        LZ4BlockOutputStream.writeIntLE(n3, this.compressedBuffer, MAGIC_LENGTH + 9);
        assert (MAGIC_LENGTH + 13 == HEADER_LENGTH);
        this.out.write(this.compressedBuffer, 0, HEADER_LENGTH + n4);
        this.o = 0;
    }

    @Override
    public void flush() {
        if (this.out != null) {
            if (this.syncFlush) {
                this.flushBufferedData();
            }
            this.out.flush();
        }
    }

    public void finish() {
        this.ensureNotFinished();
        this.flushBufferedData();
        this.compressedBuffer[LZ4BlockOutputStream.MAGIC_LENGTH] = (byte)(0x10 | this.compressionLevel);
        LZ4BlockOutputStream.writeIntLE(0, this.compressedBuffer, MAGIC_LENGTH + 1);
        LZ4BlockOutputStream.writeIntLE(0, this.compressedBuffer, MAGIC_LENGTH + 5);
        LZ4BlockOutputStream.writeIntLE(0, this.compressedBuffer, MAGIC_LENGTH + 9);
        assert (MAGIC_LENGTH + 13 == HEADER_LENGTH);
        this.out.write(this.compressedBuffer, 0, HEADER_LENGTH);
        this.finished = true;
        this.out.flush();
    }

    private static void writeIntLE(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)n2;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 24);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(out=" + this.out + ", blockSize=" + this.blockSize + ", compressor=" + this.compressor + ", checksum=" + this.checksum + ")";
    }
}

