/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.util.SafeUtils;
import net.jpountz.xxhash.XXHashFactory;

public final class LZ4BlockInputStream
extends FilterInputStream {
    private final LZ4FastDecompressor decompressor;
    private final Checksum checksum;
    private final boolean stopOnEmptyBlock;
    private byte[] buffer;
    private byte[] compressedBuffer;
    private int originalLen;
    private int o;
    private boolean finished;

    public LZ4BlockInputStream(InputStream inputStream, LZ4FastDecompressor lZ4FastDecompressor, Checksum checksum, boolean bl2) {
        super(inputStream);
        this.decompressor = lZ4FastDecompressor;
        this.checksum = checksum;
        this.stopOnEmptyBlock = bl2;
        this.buffer = new byte[0];
        this.compressedBuffer = new byte[LZ4BlockOutputStream.HEADER_LENGTH];
        this.originalLen = 0;
        this.o = 0;
        this.finished = false;
    }

    public LZ4BlockInputStream(InputStream inputStream, LZ4FastDecompressor lZ4FastDecompressor, Checksum checksum) {
        this(inputStream, lZ4FastDecompressor, checksum, true);
    }

    public LZ4BlockInputStream(InputStream inputStream, LZ4FastDecompressor lZ4FastDecompressor) {
        this(inputStream, lZ4FastDecompressor, XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum(), true);
    }

    public LZ4BlockInputStream(InputStream inputStream, boolean bl2) {
        this(inputStream, LZ4Factory.fastestInstance().fastDecompressor(), XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum(), bl2);
    }

    public LZ4BlockInputStream(InputStream inputStream) {
        this(inputStream, LZ4Factory.fastestInstance().fastDecompressor());
    }

    @Override
    public int available() {
        return this.originalLen - this.o;
    }

    @Override
    public int read() {
        if (this.finished) {
            return -1;
        }
        if (this.o == this.originalLen) {
            this.refill();
        }
        if (this.finished) {
            return -1;
        }
        return this.buffer[this.o++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        SafeUtils.checkRange(byArray, n2, n3);
        if (this.finished) {
            return -1;
        }
        if (this.o == this.originalLen) {
            this.refill();
        }
        if (this.finished) {
            return -1;
        }
        n3 = Math.min(n3, this.originalLen - this.o);
        System.arraycopy(this.buffer, this.o, byArray, n2, n3);
        this.o += n3;
        return n3;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public long skip(long l2) {
        if (l2 <= 0L || this.finished) {
            return 0L;
        }
        if (this.o == this.originalLen) {
            this.refill();
        }
        if (this.finished) {
            return 0L;
        }
        int n2 = (int)Math.min(l2, (long)(this.originalLen - this.o));
        this.o += n2;
        return n2;
    }

    private void refill() {
        int n2;
        try {
            this.readFully(this.compressedBuffer, LZ4BlockOutputStream.HEADER_LENGTH);
        }
        catch (EOFException eOFException) {
            if (this.stopOnEmptyBlock) {
                throw eOFException;
            }
            this.finished = true;
            return;
        }
        for (n2 = 0; n2 < LZ4BlockOutputStream.MAGIC_LENGTH; ++n2) {
            if (this.compressedBuffer[n2] == LZ4BlockOutputStream.MAGIC[n2]) continue;
            throw new IOException("Stream is corrupted");
        }
        n2 = this.compressedBuffer[LZ4BlockOutputStream.MAGIC_LENGTH] & 0xFF;
        int n3 = n2 & 0xF0;
        int n4 = 10 + (n2 & 0xF);
        if (n3 != 16 && n3 != 32) {
            throw new IOException("Stream is corrupted");
        }
        int n5 = SafeUtils.readIntLE(this.compressedBuffer, LZ4BlockOutputStream.MAGIC_LENGTH + 1);
        this.originalLen = SafeUtils.readIntLE(this.compressedBuffer, LZ4BlockOutputStream.MAGIC_LENGTH + 5);
        int n6 = SafeUtils.readIntLE(this.compressedBuffer, LZ4BlockOutputStream.MAGIC_LENGTH + 9);
        assert (LZ4BlockOutputStream.HEADER_LENGTH == LZ4BlockOutputStream.MAGIC_LENGTH + 13);
        if (this.originalLen > 1 << n4 || this.originalLen < 0 || n5 < 0 || this.originalLen == 0 && n5 != 0 || this.originalLen != 0 && n5 == 0 || n3 == 16 && this.originalLen != n5) {
            throw new IOException("Stream is corrupted");
        }
        if (this.originalLen == 0 && n5 == 0) {
            if (n6 != 0) {
                throw new IOException("Stream is corrupted");
            }
            if (!this.stopOnEmptyBlock) {
                this.refill();
            } else {
                this.finished = true;
            }
            return;
        }
        if (this.buffer.length < this.originalLen) {
            this.buffer = new byte[Math.max(this.originalLen, this.buffer.length * 3 / 2)];
        }
        switch (n3) {
            case 16: {
                this.readFully(this.buffer, this.originalLen);
                break;
            }
            case 32: {
                if (this.compressedBuffer.length < n5) {
                    this.compressedBuffer = new byte[Math.max(n5, this.compressedBuffer.length * 3 / 2)];
                }
                this.readFully(this.compressedBuffer, n5);
                try {
                    int n7 = this.decompressor.decompress(this.compressedBuffer, 0, this.buffer, 0, this.originalLen);
                    if (n5 != n7) {
                        throw new IOException("Stream is corrupted");
                    }
                    break;
                }
                catch (LZ4Exception lZ4Exception) {
                    throw new IOException("Stream is corrupted", lZ4Exception);
                }
            }
            default: {
                throw new AssertionError();
            }
        }
        this.checksum.reset();
        this.checksum.update(this.buffer, 0, this.originalLen);
        if ((int)this.checksum.getValue() != n6) {
            throw new IOException("Stream is corrupted");
        }
        this.o = 0;
    }

    private void readFully(byte[] byArray, int n2) {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.in.read(byArray, n3, n2 - n3);
            if (n4 >= 0) continue;
            throw new EOFException("Stream ended prematurely");
        }
        assert (n2 == n3);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n2) {
    }

    @Override
    public void reset() {
        throw new IOException("mark/reset not supported");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(in=" + this.in + ", decompressor=" + this.decompressor + ", checksum=" + this.checksum + ")";
    }
}

