/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.spec;

import java.security.spec.KeySpec;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;

public class EdDSAPublicKeySpec
implements KeySpec {
    private final GroupElement A;
    private GroupElement Aneg = null;
    private final EdDSAParameterSpec spec;

    public EdDSAPublicKeySpec(byte[] byArray, EdDSAParameterSpec edDSAParameterSpec) {
        if (byArray.length != edDSAParameterSpec.getCurve().getField().getb() / 8) {
            throw new IllegalArgumentException("public-key length is wrong");
        }
        this.A = new GroupElement(edDSAParameterSpec.getCurve(), byArray);
        this.spec = edDSAParameterSpec;
    }

    public EdDSAPublicKeySpec(GroupElement groupElement, EdDSAParameterSpec edDSAParameterSpec) {
        this.A = groupElement;
        this.spec = edDSAParameterSpec;
    }

    public GroupElement getA() {
        return this.A;
    }

    public GroupElement getNegativeA() {
        GroupElement groupElement = this.Aneg;
        if (groupElement == null) {
            this.Aneg = groupElement = this.A.negate();
        }
        return groupElement;
    }

    public EdDSAParameterSpec getParams() {
        return this.spec;
    }
}

