/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.spec;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;

public class EdDSAPrivateKeySpec
implements KeySpec {
    private final byte[] seed;
    private final byte[] h;
    private final byte[] a;
    private final GroupElement A;
    private final EdDSAParameterSpec spec;

    public EdDSAPrivateKeySpec(byte[] byArray, EdDSAParameterSpec edDSAParameterSpec) {
        if (byArray.length != edDSAParameterSpec.getCurve().getField().getb() / 8) {
            throw new IllegalArgumentException("seed length is wrong");
        }
        this.spec = edDSAParameterSpec;
        this.seed = byArray;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(edDSAParameterSpec.getHashAlgorithm());
            int n2 = edDSAParameterSpec.getCurve().getField().getb();
            this.h = messageDigest.digest(byArray);
            this.h[0] = (byte)(this.h[0] & 0xF8);
            int n3 = n2 / 8 - 1;
            this.h[n3] = (byte)(this.h[n3] & 0x3F);
            int n4 = n2 / 8 - 1;
            this.h[n4] = (byte)(this.h[n4] | 0x40);
            this.a = Arrays.copyOfRange(this.h, 0, n2 / 8);
            this.A = edDSAParameterSpec.getB().scalarMultiply(this.a);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("Unsupported hash algorithm");
        }
    }

    public EdDSAPrivateKeySpec(EdDSAParameterSpec edDSAParameterSpec, byte[] byArray) {
        if (byArray.length != edDSAParameterSpec.getCurve().getField().getb() / 4) {
            throw new IllegalArgumentException("hash length is wrong");
        }
        this.seed = null;
        this.h = byArray;
        this.spec = edDSAParameterSpec;
        int n2 = edDSAParameterSpec.getCurve().getField().getb();
        byArray[0] = (byte)(byArray[0] & 0xF8);
        int n3 = n2 / 8 - 1;
        byArray[n3] = (byte)(byArray[n3] & 0x3F);
        int n4 = n2 / 8 - 1;
        byArray[n4] = (byte)(byArray[n4] | 0x40);
        this.a = Arrays.copyOfRange(byArray, 0, n2 / 8);
        this.A = edDSAParameterSpec.getB().scalarMultiply(this.a);
    }

    public EdDSAPrivateKeySpec(byte[] byArray, byte[] byArray2, byte[] byArray3, GroupElement groupElement, EdDSAParameterSpec edDSAParameterSpec) {
        this.seed = byArray;
        this.h = byArray2;
        this.a = byArray3;
        this.A = groupElement;
        this.spec = edDSAParameterSpec;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public byte[] getH() {
        return this.h;
    }

    public byte[] geta() {
        return this.a;
    }

    public GroupElement getA() {
        return this.A;
    }

    public EdDSAParameterSpec getParams() {
        return this.spec;
    }
}

