/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.spec;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import net.i2p.crypto.eddsa.math.Curve;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.math.ScalarOps;

public class EdDSAParameterSpec
implements Serializable,
AlgorithmParameterSpec {
    private static final long serialVersionUID = 8274987108472012L;
    private final Curve curve;
    private final String hashAlgo;
    private final ScalarOps sc;
    private final GroupElement B;

    public EdDSAParameterSpec(Curve curve, String string, ScalarOps scalarOps, GroupElement groupElement) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            if (curve.getField().getb() / 4 != messageDigest.getDigestLength()) {
                throw new IllegalArgumentException("Hash output is not 2b-bit");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("Unsupported hash algorithm");
        }
        this.curve = curve;
        this.hashAlgo = string;
        this.sc = scalarOps;
        this.B = groupElement;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public String getHashAlgorithm() {
        return this.hashAlgo;
    }

    public ScalarOps getScalarOps() {
        return this.sc;
    }

    public GroupElement getB() {
        return this.B;
    }

    public int hashCode() {
        return this.hashAlgo.hashCode() ^ this.curve.hashCode() ^ this.B.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EdDSAParameterSpec)) {
            return false;
        }
        EdDSAParameterSpec edDSAParameterSpec = (EdDSAParameterSpec)object;
        return this.hashAlgo.equals(edDSAParameterSpec.getHashAlgorithm()) && this.curve.equals(edDSAParameterSpec.getCurve()) && this.B.equals(edDSAParameterSpec.getB());
    }
}

