/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.ed25519;

import net.i2p.crypto.eddsa.math.Encoding;
import net.i2p.crypto.eddsa.math.FieldElement;
import net.i2p.crypto.eddsa.math.ed25519.Ed25519FieldElement;

public class Ed25519LittleEndianEncoding
extends Encoding {
    @Override
    public byte[] encode(FieldElement fieldElement) {
        int[] nArray = ((Ed25519FieldElement)fieldElement).t;
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        int n11 = nArray[9];
        int n12 = 19 * n11 + 0x1000000 >> 25;
        n12 = n2 + n12 >> 26;
        n12 = n3 + n12 >> 25;
        n12 = n4 + n12 >> 26;
        n12 = n5 + n12 >> 25;
        n12 = n6 + n12 >> 26;
        n12 = n7 + n12 >> 25;
        n12 = n8 + n12 >> 26;
        n12 = n9 + n12 >> 25;
        n12 = n10 + n12 >> 26;
        n12 = n11 + n12 >> 25;
        int n13 = (n2 += 19 * n12) >> 26;
        n2 -= n13 << 26;
        int n14 = (n3 += n13) >> 25;
        n3 -= n14 << 25;
        int n15 = (n4 += n14) >> 26;
        n4 -= n15 << 26;
        int n16 = (n5 += n15) >> 25;
        n5 -= n16 << 25;
        int n17 = (n6 += n16) >> 26;
        n6 -= n17 << 26;
        int n18 = (n7 += n17) >> 25;
        n7 -= n18 << 25;
        int n19 = (n8 += n18) >> 26;
        int n20 = (n9 += n19) >> 25;
        int n21 = (n10 += n20) >> 26;
        int n22 = (n11 += n21) >> 25;
        byte[] byArray = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24 | n3 << 2), (byte)(n3 >> 6), (byte)(n3 >> 14), (byte)(n3 >> 22 | n4 << 3), (byte)(n4 >> 5), (byte)(n4 >> 13), (byte)(n4 >> 21 | n5 << 5), (byte)(n5 >> 3), (byte)(n5 >> 11), (byte)(n5 >> 19 | n6 << 6), (byte)(n6 >> 2), (byte)(n6 >> 10), (byte)(n6 >> 18), (byte)n7, (byte)(n7 >> 8), (byte)(n7 >> 16), (byte)(n7 >> 24 | (n8 -= n19 << 26) << 1), (byte)(n8 >> 7), (byte)(n8 >> 15), (byte)(n8 >> 23 | (n9 -= n20 << 25) << 3), (byte)(n9 >> 5), (byte)(n9 >> 13), (byte)(n9 >> 21 | (n10 -= n21 << 26) << 4), (byte)(n10 >> 4), (byte)(n10 >> 12), (byte)(n10 >> 20 | (n11 -= n22 << 25) << 6), (byte)(n11 >> 2), (byte)(n11 >> 10), (byte)(n11 >> 18)};
        return byArray;
    }

    static int load_3(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        n3 |= (byArray[n2++] & 0xFF) << 8;
        return n3 |= (byArray[n2] & 0xFF) << 16;
    }

    static long load_4(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        n3 |= (byArray[n2++] & 0xFF) << 8;
        n3 |= (byArray[n2++] & 0xFF) << 16;
        return (long)(n3 |= byArray[n2] << 24) & 0xFFFFFFFFL;
    }

    @Override
    public FieldElement decode(byte[] byArray) {
        long l2 = Ed25519LittleEndianEncoding.load_4(byArray, 0);
        long l3 = Ed25519LittleEndianEncoding.load_3(byArray, 4) << 6;
        long l4 = Ed25519LittleEndianEncoding.load_3(byArray, 7) << 5;
        long l5 = Ed25519LittleEndianEncoding.load_3(byArray, 10) << 3;
        long l6 = Ed25519LittleEndianEncoding.load_3(byArray, 13) << 2;
        long l7 = Ed25519LittleEndianEncoding.load_4(byArray, 16);
        long l8 = Ed25519LittleEndianEncoding.load_3(byArray, 20) << 7;
        long l9 = Ed25519LittleEndianEncoding.load_3(byArray, 23) << 5;
        long l10 = Ed25519LittleEndianEncoding.load_3(byArray, 26) << 4;
        long l11 = (Ed25519LittleEndianEncoding.load_3(byArray, 29) & 0x7FFFFF) << 2;
        long l12 = l11 + 0x1000000L >> 25;
        l2 += l12 * 19L;
        l11 -= l12 << 25;
        long l13 = l3 + 0x1000000L >> 25;
        l4 += l13;
        l3 -= l13 << 25;
        long l14 = l5 + 0x1000000L >> 25;
        l6 += l14;
        l5 -= l14 << 25;
        long l15 = l7 + 0x1000000L >> 25;
        l8 += l15;
        l7 -= l15 << 25;
        long l16 = l9 + 0x1000000L >> 25;
        l10 += l16;
        l9 -= l16 << 25;
        long l17 = l2 + 0x2000000L >> 26;
        l3 += l17;
        l2 -= l17 << 26;
        long l18 = l4 + 0x2000000L >> 26;
        l5 += l18;
        l4 -= l18 << 26;
        long l19 = l6 + 0x2000000L >> 26;
        long l20 = l8 + 0x2000000L >> 26;
        long l21 = l10 + 0x2000000L >> 26;
        int[] nArray = new int[]{(int)l2, (int)l3, (int)l4, (int)l5, (int)(l6 -= l19 << 26), (int)(l7 += l19), (int)(l8 -= l20 << 26), (int)(l9 += l20), (int)(l10 -= l21 << 26), (int)(l11 += l21)};
        return new Ed25519FieldElement(this.f, nArray);
    }

    @Override
    public boolean isNegative(FieldElement fieldElement) {
        byte[] byArray = this.encode(fieldElement);
        return (byArray[0] & 1) != 0;
    }
}

