/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.ed25519;

import java.util.Arrays;
import net.i2p.crypto.eddsa.Utils;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.FieldElement;

public class Ed25519FieldElement
extends FieldElement {
    final int[] t;
    private static final byte[] ZERO = new byte[32];

    public Ed25519FieldElement(Field field, int[] nArray) {
        super(field);
        if (nArray.length != 10) {
            throw new IllegalArgumentException("Invalid radix-2^51 representation");
        }
        this.t = nArray;
    }

    @Override
    public boolean isNonZero() {
        byte[] byArray = this.toByteArray();
        return Utils.equal(byArray, ZERO) == 0;
    }

    @Override
    public FieldElement add(FieldElement fieldElement) {
        int[] nArray = ((Ed25519FieldElement)fieldElement).t;
        int[] nArray2 = new int[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            nArray2[i2] = this.t[i2] + nArray[i2];
        }
        return new Ed25519FieldElement(this.f, nArray2);
    }

    @Override
    public FieldElement subtract(FieldElement fieldElement) {
        int[] nArray = ((Ed25519FieldElement)fieldElement).t;
        int[] nArray2 = new int[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            nArray2[i2] = this.t[i2] - nArray[i2];
        }
        return new Ed25519FieldElement(this.f, nArray2);
    }

    @Override
    public FieldElement negate() {
        int[] nArray = new int[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            nArray[i2] = -this.t[i2];
        }
        return new Ed25519FieldElement(this.f, nArray);
    }

    @Override
    public FieldElement multiply(FieldElement fieldElement) {
        int[] nArray = ((Ed25519FieldElement)fieldElement).t;
        int n2 = 19 * nArray[1];
        int n3 = 19 * nArray[2];
        int n4 = 19 * nArray[3];
        int n5 = 19 * nArray[4];
        int n6 = 19 * nArray[5];
        int n7 = 19 * nArray[6];
        int n8 = 19 * nArray[7];
        int n9 = 19 * nArray[8];
        int n10 = 19 * nArray[9];
        int n11 = 2 * this.t[1];
        int n12 = 2 * this.t[3];
        int n13 = 2 * this.t[5];
        int n14 = 2 * this.t[7];
        int n15 = 2 * this.t[9];
        long l2 = (long)this.t[0] * (long)nArray[0];
        long l3 = (long)this.t[0] * (long)nArray[1];
        long l4 = (long)this.t[0] * (long)nArray[2];
        long l5 = (long)this.t[0] * (long)nArray[3];
        long l6 = (long)this.t[0] * (long)nArray[4];
        long l7 = (long)this.t[0] * (long)nArray[5];
        long l8 = (long)this.t[0] * (long)nArray[6];
        long l9 = (long)this.t[0] * (long)nArray[7];
        long l10 = (long)this.t[0] * (long)nArray[8];
        long l11 = (long)this.t[0] * (long)nArray[9];
        long l12 = (long)this.t[1] * (long)nArray[0];
        long l13 = (long)n11 * (long)nArray[1];
        long l14 = (long)this.t[1] * (long)nArray[2];
        long l15 = (long)n11 * (long)nArray[3];
        long l16 = (long)this.t[1] * (long)nArray[4];
        long l17 = (long)n11 * (long)nArray[5];
        long l18 = (long)this.t[1] * (long)nArray[6];
        long l19 = (long)n11 * (long)nArray[7];
        long l20 = (long)this.t[1] * (long)nArray[8];
        long l21 = (long)n11 * (long)n10;
        long l22 = (long)this.t[2] * (long)nArray[0];
        long l23 = (long)this.t[2] * (long)nArray[1];
        long l24 = (long)this.t[2] * (long)nArray[2];
        long l25 = (long)this.t[2] * (long)nArray[3];
        long l26 = (long)this.t[2] * (long)nArray[4];
        long l27 = (long)this.t[2] * (long)nArray[5];
        long l28 = (long)this.t[2] * (long)nArray[6];
        long l29 = (long)this.t[2] * (long)nArray[7];
        long l30 = (long)this.t[2] * (long)n9;
        long l31 = (long)this.t[2] * (long)n10;
        long l32 = (long)this.t[3] * (long)nArray[0];
        long l33 = (long)n12 * (long)nArray[1];
        long l34 = (long)this.t[3] * (long)nArray[2];
        long l35 = (long)n12 * (long)nArray[3];
        long l36 = (long)this.t[3] * (long)nArray[4];
        long l37 = (long)n12 * (long)nArray[5];
        long l38 = (long)this.t[3] * (long)nArray[6];
        long l39 = (long)n12 * (long)n8;
        long l40 = (long)this.t[3] * (long)n9;
        long l41 = (long)n12 * (long)n10;
        long l42 = (long)this.t[4] * (long)nArray[0];
        long l43 = (long)this.t[4] * (long)nArray[1];
        long l44 = (long)this.t[4] * (long)nArray[2];
        long l45 = (long)this.t[4] * (long)nArray[3];
        long l46 = (long)this.t[4] * (long)nArray[4];
        long l47 = (long)this.t[4] * (long)nArray[5];
        long l48 = (long)this.t[4] * (long)n7;
        long l49 = (long)this.t[4] * (long)n8;
        long l50 = (long)this.t[4] * (long)n9;
        long l51 = (long)this.t[4] * (long)n10;
        long l52 = (long)this.t[5] * (long)nArray[0];
        long l53 = (long)n13 * (long)nArray[1];
        long l54 = (long)this.t[5] * (long)nArray[2];
        long l55 = (long)n13 * (long)nArray[3];
        long l56 = (long)this.t[5] * (long)nArray[4];
        long l57 = (long)n13 * (long)n6;
        long l58 = (long)this.t[5] * (long)n7;
        long l59 = (long)n13 * (long)n8;
        long l60 = (long)this.t[5] * (long)n9;
        long l61 = (long)n13 * (long)n10;
        long l62 = (long)this.t[6] * (long)nArray[0];
        long l63 = (long)this.t[6] * (long)nArray[1];
        long l64 = (long)this.t[6] * (long)nArray[2];
        long l65 = (long)this.t[6] * (long)nArray[3];
        long l66 = (long)this.t[6] * (long)n5;
        long l67 = (long)this.t[6] * (long)n6;
        long l68 = (long)this.t[6] * (long)n7;
        long l69 = (long)this.t[6] * (long)n8;
        long l70 = (long)this.t[6] * (long)n9;
        long l71 = (long)this.t[6] * (long)n10;
        long l72 = (long)this.t[7] * (long)nArray[0];
        long l73 = (long)n14 * (long)nArray[1];
        long l74 = (long)this.t[7] * (long)nArray[2];
        long l75 = (long)n14 * (long)n4;
        long l76 = (long)this.t[7] * (long)n5;
        long l77 = (long)n14 * (long)n6;
        long l78 = (long)this.t[7] * (long)n7;
        long l79 = (long)n14 * (long)n8;
        long l80 = (long)this.t[7] * (long)n9;
        long l81 = (long)n14 * (long)n10;
        long l82 = (long)this.t[8] * (long)nArray[0];
        long l83 = (long)this.t[8] * (long)nArray[1];
        long l84 = (long)this.t[8] * (long)n3;
        long l85 = (long)this.t[8] * (long)n4;
        long l86 = (long)this.t[8] * (long)n5;
        long l87 = (long)this.t[8] * (long)n6;
        long l88 = (long)this.t[8] * (long)n7;
        long l89 = (long)this.t[8] * (long)n8;
        long l90 = (long)this.t[8] * (long)n9;
        long l91 = (long)this.t[8] * (long)n10;
        long l92 = (long)this.t[9] * (long)nArray[0];
        long l93 = (long)n15 * (long)n2;
        long l94 = (long)this.t[9] * (long)n3;
        long l95 = (long)n15 * (long)n4;
        long l96 = (long)this.t[9] * (long)n5;
        long l97 = (long)n15 * (long)n6;
        long l98 = (long)this.t[9] * (long)n7;
        long l99 = (long)n15 * (long)n8;
        long l100 = (long)this.t[9] * (long)n9;
        long l101 = (long)n15 * (long)n10;
        long l102 = l2 + l21 + l30 + l39 + l48 + l57 + l66 + l75 + l84 + l93;
        long l103 = l3 + l12 + l31 + l40 + l49 + l58 + l67 + l76 + l85 + l94;
        long l104 = l4 + l13 + l22 + l41 + l50 + l59 + l68 + l77 + l86 + l95;
        long l105 = l5 + l14 + l23 + l32 + l51 + l60 + l69 + l78 + l87 + l96;
        long l106 = l6 + l15 + l24 + l33 + l42 + l61 + l70 + l79 + l88 + l97;
        long l107 = l7 + l16 + l25 + l34 + l43 + l52 + l71 + l80 + l89 + l98;
        long l108 = l8 + l17 + l26 + l35 + l44 + l53 + l62 + l81 + l90 + l99;
        long l109 = l9 + l18 + l27 + l36 + l45 + l54 + l63 + l72 + l91 + l100;
        long l110 = l10 + l19 + l28 + l37 + l46 + l55 + l64 + l73 + l82 + l101;
        long l111 = l11 + l20 + l29 + l38 + l47 + l56 + l65 + l74 + l83 + l92;
        long l112 = l102 + 0x2000000L >> 26;
        l102 -= l112 << 26;
        long l113 = l106 + 0x2000000L >> 26;
        l106 -= l113 << 26;
        long l114 = (l103 += l112) + 0x1000000L >> 25;
        l103 -= l114 << 25;
        long l115 = (l107 += l113) + 0x1000000L >> 25;
        l107 -= l115 << 25;
        long l116 = (l104 += l114) + 0x2000000L >> 26;
        l104 -= l116 << 26;
        long l117 = (l108 += l115) + 0x2000000L >> 26;
        l108 -= l117 << 26;
        long l118 = (l105 += l116) + 0x1000000L >> 25;
        l105 -= l118 << 25;
        long l119 = (l109 += l117) + 0x1000000L >> 25;
        l113 = (l106 += l118) + 0x2000000L >> 26;
        long l120 = (l110 += l119) + 0x2000000L >> 26;
        long l121 = (l111 += l120) + 0x1000000L >> 25;
        l112 = (l102 += l121 * 19L) + 0x2000000L >> 26;
        int[] nArray2 = new int[]{(int)(l102 -= l112 << 26), (int)(l103 += l112), (int)l104, (int)l105, (int)(l106 -= l113 << 26), (int)(l107 += l113), (int)l108, (int)(l109 -= l119 << 25), (int)(l110 -= l120 << 26), (int)(l111 -= l121 << 25)};
        return new Ed25519FieldElement(this.f, nArray2);
    }

    @Override
    public FieldElement square() {
        int n2 = this.t[0];
        int n3 = this.t[1];
        int n4 = this.t[2];
        int n5 = this.t[3];
        int n6 = this.t[4];
        int n7 = this.t[5];
        int n8 = this.t[6];
        int n9 = this.t[7];
        int n10 = this.t[8];
        int n11 = this.t[9];
        int n12 = 2 * n2;
        int n13 = 2 * n3;
        int n14 = 2 * n4;
        int n15 = 2 * n5;
        int n16 = 2 * n6;
        int n17 = 2 * n7;
        int n18 = 2 * n8;
        int n19 = 2 * n9;
        int n20 = 38 * n7;
        int n21 = 19 * n8;
        int n22 = 38 * n9;
        int n23 = 19 * n10;
        int n24 = 38 * n11;
        long l2 = (long)n2 * (long)n2;
        long l3 = (long)n12 * (long)n3;
        long l4 = (long)n12 * (long)n4;
        long l5 = (long)n12 * (long)n5;
        long l6 = (long)n12 * (long)n6;
        long l7 = (long)n12 * (long)n7;
        long l8 = (long)n12 * (long)n8;
        long l9 = (long)n12 * (long)n9;
        long l10 = (long)n12 * (long)n10;
        long l11 = (long)n12 * (long)n11;
        long l12 = (long)n13 * (long)n3;
        long l13 = (long)n13 * (long)n4;
        long l14 = (long)n13 * (long)n15;
        long l15 = (long)n13 * (long)n6;
        long l16 = (long)n13 * (long)n17;
        long l17 = (long)n13 * (long)n8;
        long l18 = (long)n13 * (long)n19;
        long l19 = (long)n13 * (long)n10;
        long l20 = (long)n13 * (long)n24;
        long l21 = (long)n4 * (long)n4;
        long l22 = (long)n14 * (long)n5;
        long l23 = (long)n14 * (long)n6;
        long l24 = (long)n14 * (long)n7;
        long l25 = (long)n14 * (long)n8;
        long l26 = (long)n14 * (long)n9;
        long l27 = (long)n14 * (long)n23;
        long l28 = (long)n4 * (long)n24;
        long l29 = (long)n15 * (long)n5;
        long l30 = (long)n15 * (long)n6;
        long l31 = (long)n15 * (long)n17;
        long l32 = (long)n15 * (long)n8;
        long l33 = (long)n15 * (long)n22;
        long l34 = (long)n15 * (long)n23;
        long l35 = (long)n15 * (long)n24;
        long l36 = (long)n6 * (long)n6;
        long l37 = (long)n16 * (long)n7;
        long l38 = (long)n16 * (long)n21;
        long l39 = (long)n6 * (long)n22;
        long l40 = (long)n16 * (long)n23;
        long l41 = (long)n6 * (long)n24;
        long l42 = (long)n7 * (long)n20;
        long l43 = (long)n17 * (long)n21;
        long l44 = (long)n17 * (long)n22;
        long l45 = (long)n17 * (long)n23;
        long l46 = (long)n17 * (long)n24;
        long l47 = (long)n8 * (long)n21;
        long l48 = (long)n8 * (long)n22;
        long l49 = (long)n18 * (long)n23;
        long l50 = (long)n8 * (long)n24;
        long l51 = (long)n9 * (long)n22;
        long l52 = (long)n19 * (long)n23;
        long l53 = (long)n19 * (long)n24;
        long l54 = (long)n10 * (long)n23;
        long l55 = (long)n10 * (long)n24;
        long l56 = (long)n11 * (long)n24;
        long l57 = l2 + l20 + l27 + l33 + l38 + l42;
        long l58 = l3 + l28 + l34 + l39 + l43;
        long l59 = l4 + l12 + l35 + l40 + l44 + l47;
        long l60 = l5 + l13 + l41 + l45 + l48;
        long l61 = l6 + l14 + l21 + l46 + l49 + l51;
        long l62 = l7 + l15 + l22 + l50 + l52;
        long l63 = l8 + l16 + l23 + l29 + l53 + l54;
        long l64 = l9 + l17 + l24 + l30 + l55;
        long l65 = l10 + l18 + l25 + l31 + l36 + l56;
        long l66 = l11 + l19 + l26 + l32 + l37;
        long l67 = l57 + 0x2000000L >> 26;
        l57 -= l67 << 26;
        long l68 = l61 + 0x2000000L >> 26;
        l61 -= l68 << 26;
        long l69 = (l58 += l67) + 0x1000000L >> 25;
        l58 -= l69 << 25;
        long l70 = (l62 += l68) + 0x1000000L >> 25;
        l62 -= l70 << 25;
        long l71 = (l59 += l69) + 0x2000000L >> 26;
        l59 -= l71 << 26;
        long l72 = (l63 += l70) + 0x2000000L >> 26;
        l63 -= l72 << 26;
        long l73 = (l60 += l71) + 0x1000000L >> 25;
        l60 -= l73 << 25;
        long l74 = (l64 += l72) + 0x1000000L >> 25;
        l68 = (l61 += l73) + 0x2000000L >> 26;
        long l75 = (l65 += l74) + 0x2000000L >> 26;
        long l76 = (l66 += l75) + 0x1000000L >> 25;
        l67 = (l57 += l76 * 19L) + 0x2000000L >> 26;
        int[] nArray = new int[]{(int)(l57 -= l67 << 26), (int)(l58 += l67), (int)l59, (int)l60, (int)(l61 -= l68 << 26), (int)(l62 += l68), (int)l63, (int)(l64 -= l74 << 25), (int)(l65 -= l75 << 26), (int)(l66 -= l76 << 25)};
        return new Ed25519FieldElement(this.f, nArray);
    }

    @Override
    public FieldElement squareAndDouble() {
        int n2 = this.t[0];
        int n3 = this.t[1];
        int n4 = this.t[2];
        int n5 = this.t[3];
        int n6 = this.t[4];
        int n7 = this.t[5];
        int n8 = this.t[6];
        int n9 = this.t[7];
        int n10 = this.t[8];
        int n11 = this.t[9];
        int n12 = 2 * n2;
        int n13 = 2 * n3;
        int n14 = 2 * n4;
        int n15 = 2 * n5;
        int n16 = 2 * n6;
        int n17 = 2 * n7;
        int n18 = 2 * n8;
        int n19 = 2 * n9;
        int n20 = 38 * n7;
        int n21 = 19 * n8;
        int n22 = 38 * n9;
        int n23 = 19 * n10;
        int n24 = 38 * n11;
        long l2 = (long)n2 * (long)n2;
        long l3 = (long)n12 * (long)n3;
        long l4 = (long)n12 * (long)n4;
        long l5 = (long)n12 * (long)n5;
        long l6 = (long)n12 * (long)n6;
        long l7 = (long)n12 * (long)n7;
        long l8 = (long)n12 * (long)n8;
        long l9 = (long)n12 * (long)n9;
        long l10 = (long)n12 * (long)n10;
        long l11 = (long)n12 * (long)n11;
        long l12 = (long)n13 * (long)n3;
        long l13 = (long)n13 * (long)n4;
        long l14 = (long)n13 * (long)n15;
        long l15 = (long)n13 * (long)n6;
        long l16 = (long)n13 * (long)n17;
        long l17 = (long)n13 * (long)n8;
        long l18 = (long)n13 * (long)n19;
        long l19 = (long)n13 * (long)n10;
        long l20 = (long)n13 * (long)n24;
        long l21 = (long)n4 * (long)n4;
        long l22 = (long)n14 * (long)n5;
        long l23 = (long)n14 * (long)n6;
        long l24 = (long)n14 * (long)n7;
        long l25 = (long)n14 * (long)n8;
        long l26 = (long)n14 * (long)n9;
        long l27 = (long)n14 * (long)n23;
        long l28 = (long)n4 * (long)n24;
        long l29 = (long)n15 * (long)n5;
        long l30 = (long)n15 * (long)n6;
        long l31 = (long)n15 * (long)n17;
        long l32 = (long)n15 * (long)n8;
        long l33 = (long)n15 * (long)n22;
        long l34 = (long)n15 * (long)n23;
        long l35 = (long)n15 * (long)n24;
        long l36 = (long)n6 * (long)n6;
        long l37 = (long)n16 * (long)n7;
        long l38 = (long)n16 * (long)n21;
        long l39 = (long)n6 * (long)n22;
        long l40 = (long)n16 * (long)n23;
        long l41 = (long)n6 * (long)n24;
        long l42 = (long)n7 * (long)n20;
        long l43 = (long)n17 * (long)n21;
        long l44 = (long)n17 * (long)n22;
        long l45 = (long)n17 * (long)n23;
        long l46 = (long)n17 * (long)n24;
        long l47 = (long)n8 * (long)n21;
        long l48 = (long)n8 * (long)n22;
        long l49 = (long)n18 * (long)n23;
        long l50 = (long)n8 * (long)n24;
        long l51 = (long)n9 * (long)n22;
        long l52 = (long)n19 * (long)n23;
        long l53 = (long)n19 * (long)n24;
        long l54 = (long)n10 * (long)n23;
        long l55 = (long)n10 * (long)n24;
        long l56 = (long)n11 * (long)n24;
        long l57 = l2 + l20 + l27 + l33 + l38 + l42;
        long l58 = l3 + l28 + l34 + l39 + l43;
        long l59 = l4 + l12 + l35 + l40 + l44 + l47;
        long l60 = l5 + l13 + l41 + l45 + l48;
        long l61 = l6 + l14 + l21 + l46 + l49 + l51;
        long l62 = l7 + l15 + l22 + l50 + l52;
        long l63 = l8 + l16 + l23 + l29 + l53 + l54;
        long l64 = l9 + l17 + l24 + l30 + l55;
        long l65 = l10 + l18 + l25 + l31 + l36 + l56;
        long l66 = l11 + l19 + l26 + l32 + l37;
        l57 += l57;
        l58 += l58;
        l59 += l59;
        l60 += l60;
        l61 += l61;
        l62 += l62;
        l63 += l63;
        l64 += l64;
        l65 += l65;
        l66 += l66;
        long l67 = l57 + 0x2000000L >> 26;
        l57 -= l67 << 26;
        long l68 = l61 + 0x2000000L >> 26;
        l61 -= l68 << 26;
        long l69 = (l58 += l67) + 0x1000000L >> 25;
        l58 -= l69 << 25;
        long l70 = (l62 += l68) + 0x1000000L >> 25;
        l62 -= l70 << 25;
        long l71 = (l59 += l69) + 0x2000000L >> 26;
        l59 -= l71 << 26;
        long l72 = (l63 += l70) + 0x2000000L >> 26;
        l63 -= l72 << 26;
        long l73 = (l60 += l71) + 0x1000000L >> 25;
        l60 -= l73 << 25;
        long l74 = (l64 += l72) + 0x1000000L >> 25;
        l68 = (l61 += l73) + 0x2000000L >> 26;
        long l75 = (l65 += l74) + 0x2000000L >> 26;
        long l76 = (l66 += l75) + 0x1000000L >> 25;
        l67 = (l57 += l76 * 19L) + 0x2000000L >> 26;
        int[] nArray = new int[]{(int)(l57 -= l67 << 26), (int)(l58 += l67), (int)l59, (int)l60, (int)(l61 -= l68 << 26), (int)(l62 += l68), (int)l63, (int)(l64 -= l74 << 25), (int)(l65 -= l75 << 26), (int)(l66 -= l76 << 25)};
        return new Ed25519FieldElement(this.f, nArray);
    }

    @Override
    public FieldElement invert() {
        int n2;
        FieldElement fieldElement = this.square();
        FieldElement fieldElement2 = fieldElement.square();
        fieldElement2 = fieldElement2.square();
        fieldElement2 = this.multiply(fieldElement2);
        fieldElement = fieldElement.multiply(fieldElement2);
        FieldElement fieldElement3 = fieldElement.square();
        fieldElement2 = fieldElement2.multiply(fieldElement3);
        fieldElement3 = fieldElement2.square();
        for (n2 = 1; n2 < 5; ++n2) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement2 = fieldElement3.multiply(fieldElement2);
        fieldElement3 = fieldElement2.square();
        for (n2 = 1; n2 < 10; ++n2) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement3 = fieldElement3.multiply(fieldElement2);
        FieldElement fieldElement4 = fieldElement3.square();
        for (n2 = 1; n2 < 20; ++n2) {
            fieldElement4 = fieldElement4.square();
        }
        fieldElement3 = fieldElement4.multiply(fieldElement3);
        fieldElement3 = fieldElement3.square();
        for (n2 = 1; n2 < 10; ++n2) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement2 = fieldElement3.multiply(fieldElement2);
        fieldElement3 = fieldElement2.square();
        for (n2 = 1; n2 < 50; ++n2) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement3 = fieldElement3.multiply(fieldElement2);
        fieldElement4 = fieldElement3.square();
        for (n2 = 1; n2 < 100; ++n2) {
            fieldElement4 = fieldElement4.square();
        }
        fieldElement3 = fieldElement4.multiply(fieldElement3);
        fieldElement3 = fieldElement3.square();
        for (n2 = 1; n2 < 50; ++n2) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement2 = fieldElement3.multiply(fieldElement2);
        fieldElement2 = fieldElement2.square();
        for (n2 = 1; n2 < 5; ++n2) {
            fieldElement2 = fieldElement2.square();
        }
        return fieldElement2.multiply(fieldElement);
    }

    @Override
    public FieldElement pow22523() {
        int n2;
        FieldElement fieldElement = this.square();
        FieldElement fieldElement2 = fieldElement.square();
        fieldElement2 = fieldElement2.square();
        fieldElement2 = this.multiply(fieldElement2);
        fieldElement = fieldElement.multiply(fieldElement2);
        fieldElement = fieldElement.square();
        fieldElement = fieldElement2.multiply(fieldElement);
        fieldElement2 = fieldElement.square();
        for (n2 = 1; n2 < 5; ++n2) {
            fieldElement2 = fieldElement2.square();
        }
        fieldElement = fieldElement2.multiply(fieldElement);
        fieldElement2 = fieldElement.square();
        for (n2 = 1; n2 < 10; ++n2) {
            fieldElement2 = fieldElement2.square();
        }
        fieldElement2 = fieldElement2.multiply(fieldElement);
        FieldElement fieldElement3 = fieldElement2.square();
        for (n2 = 1; n2 < 20; ++n2) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement2 = fieldElement3.multiply(fieldElement2);
        fieldElement2 = fieldElement2.square();
        for (n2 = 1; n2 < 10; ++n2) {
            fieldElement2 = fieldElement2.square();
        }
        fieldElement = fieldElement2.multiply(fieldElement);
        fieldElement2 = fieldElement.square();
        for (n2 = 1; n2 < 50; ++n2) {
            fieldElement2 = fieldElement2.square();
        }
        fieldElement2 = fieldElement2.multiply(fieldElement);
        fieldElement3 = fieldElement2.square();
        for (n2 = 1; n2 < 100; ++n2) {
            fieldElement3 = fieldElement3.square();
        }
        fieldElement2 = fieldElement3.multiply(fieldElement2);
        fieldElement2 = fieldElement2.square();
        for (n2 = 1; n2 < 50; ++n2) {
            fieldElement2 = fieldElement2.square();
        }
        fieldElement = fieldElement2.multiply(fieldElement);
        fieldElement = fieldElement.square();
        fieldElement = fieldElement.square();
        return this.multiply(fieldElement);
    }

    @Override
    public FieldElement cmov(FieldElement fieldElement, int n2) {
        Ed25519FieldElement ed25519FieldElement = (Ed25519FieldElement)fieldElement;
        n2 = -n2;
        int[] nArray = new int[10];
        int n3 = 0;
        while (n3 < 10) {
            nArray[n3] = this.t[n3];
            int n4 = this.t[n3] ^ ed25519FieldElement.t[n3];
            int n5 = n3++;
            nArray[n5] = nArray[n5] ^ (n4 &= n2);
        }
        return new Ed25519FieldElement(this.f, nArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.t);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Ed25519FieldElement)) {
            return false;
        }
        Ed25519FieldElement ed25519FieldElement = (Ed25519FieldElement)object;
        return 1 == Utils.equal(this.toByteArray(), ed25519FieldElement.toByteArray());
    }

    public String toString() {
        return "[Ed25519FieldElement val=" + Utils.bytesToHex(this.toByteArray()) + "]";
    }
}

