/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.bigint;

import java.io.Serializable;
import java.math.BigInteger;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.FieldElement;

public class BigIntegerFieldElement
extends FieldElement
implements Serializable {
    private static final long serialVersionUID = 4890398908392808L;
    final BigInteger bi;

    public BigIntegerFieldElement(Field field, BigInteger bigInteger) {
        super(field);
        this.bi = bigInteger;
    }

    @Override
    public boolean isNonZero() {
        return !this.bi.equals(BigInteger.ZERO);
    }

    @Override
    public FieldElement add(FieldElement fieldElement) {
        return new BigIntegerFieldElement(this.f, this.bi.add(((BigIntegerFieldElement)fieldElement).bi)).mod(this.f.getQ());
    }

    @Override
    public FieldElement addOne() {
        return new BigIntegerFieldElement(this.f, this.bi.add(BigInteger.ONE)).mod(this.f.getQ());
    }

    @Override
    public FieldElement subtract(FieldElement fieldElement) {
        return new BigIntegerFieldElement(this.f, this.bi.subtract(((BigIntegerFieldElement)fieldElement).bi)).mod(this.f.getQ());
    }

    @Override
    public FieldElement subtractOne() {
        return new BigIntegerFieldElement(this.f, this.bi.subtract(BigInteger.ONE)).mod(this.f.getQ());
    }

    @Override
    public FieldElement negate() {
        return this.f.getQ().subtract(this);
    }

    @Override
    public FieldElement divide(FieldElement fieldElement) {
        return this.divide(((BigIntegerFieldElement)fieldElement).bi);
    }

    public FieldElement divide(BigInteger bigInteger) {
        return new BigIntegerFieldElement(this.f, this.bi.divide(bigInteger)).mod(this.f.getQ());
    }

    @Override
    public FieldElement multiply(FieldElement fieldElement) {
        return new BigIntegerFieldElement(this.f, this.bi.multiply(((BigIntegerFieldElement)fieldElement).bi)).mod(this.f.getQ());
    }

    @Override
    public FieldElement square() {
        return this.multiply(this);
    }

    @Override
    public FieldElement squareAndDouble() {
        FieldElement fieldElement = this.square();
        return fieldElement.add(fieldElement);
    }

    @Override
    public FieldElement invert() {
        return new BigIntegerFieldElement(this.f, this.bi.modInverse(((BigIntegerFieldElement)this.f.getQ()).bi));
    }

    public FieldElement mod(FieldElement fieldElement) {
        return new BigIntegerFieldElement(this.f, this.bi.mod(((BigIntegerFieldElement)fieldElement).bi));
    }

    public FieldElement modPow(FieldElement fieldElement, FieldElement fieldElement2) {
        return new BigIntegerFieldElement(this.f, this.bi.modPow(((BigIntegerFieldElement)fieldElement).bi, ((BigIntegerFieldElement)fieldElement2).bi));
    }

    public FieldElement pow(FieldElement fieldElement) {
        return this.modPow(fieldElement, this.f.getQ());
    }

    @Override
    public FieldElement pow22523() {
        return this.pow(this.f.getQm5d8());
    }

    @Override
    public FieldElement cmov(FieldElement fieldElement, int n2) {
        return n2 == 0 ? this : fieldElement;
    }

    public int hashCode() {
        return this.bi.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigIntegerFieldElement)) {
            return false;
        }
        BigIntegerFieldElement bigIntegerFieldElement = (BigIntegerFieldElement)object;
        return this.bi.equals(bigIntegerFieldElement.bi);
    }

    public String toString() {
        return "[BigIntegerFieldElement val=" + this.bi + "]";
    }
}

