/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math;

import java.io.Serializable;
import java.util.Arrays;
import net.i2p.crypto.eddsa.Utils;
import net.i2p.crypto.eddsa.math.Curve;
import net.i2p.crypto.eddsa.math.FieldElement;
import net.i2p.crypto.eddsa.math.GroupElement$Representation;

public class GroupElement
implements Serializable {
    private static final long serialVersionUID = 2395879087349587L;
    final Curve curve;
    final GroupElement$Representation repr;
    final FieldElement X;
    final FieldElement Y;
    final FieldElement Z;
    final FieldElement T;
    final GroupElement[][] precmp;
    final GroupElement[] dblPrecmp;

    public static GroupElement p2(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3) {
        return new GroupElement(curve, GroupElement$Representation.P2, fieldElement, fieldElement2, fieldElement3, null);
    }

    public static GroupElement p3(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        return GroupElement.p3(curve, fieldElement, fieldElement2, fieldElement3, fieldElement4, false);
    }

    public static GroupElement p3(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4, boolean bl2) {
        return new GroupElement(curve, GroupElement$Representation.P3, fieldElement, fieldElement2, fieldElement3, fieldElement4, bl2);
    }

    public static GroupElement p1p1(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        return new GroupElement(curve, GroupElement$Representation.P1P1, fieldElement, fieldElement2, fieldElement3, fieldElement4);
    }

    public static GroupElement precomp(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3) {
        return new GroupElement(curve, GroupElement$Representation.PRECOMP, fieldElement, fieldElement2, fieldElement3, null);
    }

    public static GroupElement cached(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        return new GroupElement(curve, GroupElement$Representation.CACHED, fieldElement, fieldElement2, fieldElement3, fieldElement4);
    }

    public GroupElement(Curve curve, GroupElement$Representation groupElement$Representation, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        this(curve, groupElement$Representation, fieldElement, fieldElement2, fieldElement3, fieldElement4, false);
    }

    public GroupElement(Curve curve, GroupElement$Representation groupElement$Representation, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4, boolean bl2) {
        this.curve = curve;
        this.repr = groupElement$Representation;
        this.X = fieldElement;
        this.Y = fieldElement2;
        this.Z = fieldElement3;
        this.T = fieldElement4;
        this.precmp = null;
        this.dblPrecmp = bl2 ? this.precomputeDouble() : null;
    }

    public GroupElement(Curve curve, byte[] byArray) {
        this(curve, byArray, false);
    }

    public GroupElement(Curve curve, byte[] byArray, boolean bl2) {
        FieldElement fieldElement = curve.getField().fromByteArray(byArray);
        FieldElement fieldElement2 = fieldElement.square();
        FieldElement fieldElement3 = fieldElement2.subtractOne();
        FieldElement fieldElement4 = fieldElement2.multiply(curve.getD()).addOne();
        FieldElement fieldElement5 = fieldElement4.square().multiply(fieldElement4);
        FieldElement fieldElement6 = fieldElement5.square().multiply(fieldElement4).multiply(fieldElement3);
        fieldElement6 = fieldElement6.pow22523();
        fieldElement6 = fieldElement5.multiply(fieldElement3).multiply(fieldElement6);
        FieldElement fieldElement7 = fieldElement6.square().multiply(fieldElement4);
        FieldElement fieldElement8 = fieldElement7.subtract(fieldElement3);
        if (fieldElement8.isNonZero()) {
            fieldElement8 = fieldElement7.add(fieldElement3);
            if (fieldElement8.isNonZero()) {
                throw new IllegalArgumentException("not a valid GroupElement");
            }
            fieldElement6 = fieldElement6.multiply(curve.getI());
        }
        if ((fieldElement6.isNegative() ? 1 : 0) != Utils.bit(byArray, curve.getField().getb() - 1)) {
            fieldElement6 = fieldElement6.negate();
        }
        this.curve = curve;
        this.repr = GroupElement$Representation.P3;
        this.X = fieldElement6;
        this.Y = fieldElement;
        this.Z = curve.getField().ONE;
        this.T = this.X.multiply(this.Y);
        if (bl2) {
            this.precmp = this.precomputeSingle();
            this.dblPrecmp = this.precomputeDouble();
        } else {
            this.precmp = null;
            this.dblPrecmp = null;
        }
    }

    public Curve getCurve() {
        return this.curve;
    }

    public GroupElement$Representation getRepresentation() {
        return this.repr;
    }

    public FieldElement getX() {
        return this.X;
    }

    public FieldElement getY() {
        return this.Y;
    }

    public FieldElement getZ() {
        return this.Z;
    }

    public FieldElement getT() {
        return this.T;
    }

    public byte[] toByteArray() {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement fieldElement = this.Z.invert();
                FieldElement fieldElement2 = this.X.multiply(fieldElement);
                FieldElement fieldElement3 = this.Y.multiply(fieldElement);
                byte[] byArray = fieldElement3.toByteArray();
                int n2 = byArray.length - 1;
                byArray[n2] = (byte)(byArray[n2] | (fieldElement2.isNegative() ? -128 : 0));
                return byArray;
            }
        }
        return this.toP2().toByteArray();
    }

    public GroupElement toP2() {
        return this.toRep(GroupElement$Representation.P2);
    }

    public GroupElement toP3() {
        return this.toRep(GroupElement$Representation.P3);
    }

    public GroupElement toP3PrecomputeDouble() {
        return this.toRep(GroupElement$Representation.P3PrecomputedDouble);
    }

    public GroupElement toCached() {
        return this.toRep(GroupElement$Representation.CACHED);
    }

    private GroupElement toRep(GroupElement$Representation groupElement$Representation) {
        switch (this.repr) {
            case P2: {
                switch (groupElement$Representation) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case P3: {
                switch (groupElement$Representation) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X, this.Y, this.Z);
                    }
                    case P3: {
                        return GroupElement.p3(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                    case CACHED: {
                        return GroupElement.cached(this.curve, this.Y.add(this.X), this.Y.subtract(this.X), this.Z, this.T.multiply(this.curve.get2D()));
                    }
                }
                throw new IllegalArgumentException();
            }
            case P1P1: {
                switch (groupElement$Representation) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T));
                    }
                    case P3: {
                        return GroupElement.p3(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T), this.X.multiply(this.Y), false);
                    }
                    case P3PrecomputedDouble: {
                        return GroupElement.p3(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T), this.X.multiply(this.Y), true);
                    }
                    case P1P1: {
                        return GroupElement.p1p1(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
            case PRECOMP: {
                switch (groupElement$Representation) {
                    case PRECOMP: {
                        return GroupElement.precomp(this.curve, this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case CACHED: {
                switch (groupElement$Representation) {
                    case CACHED: {
                        return GroupElement.cached(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new UnsupportedOperationException();
    }

    private GroupElement[][] precomputeSingle() {
        GroupElement[][] groupElementArray = new GroupElement[32][8];
        GroupElement groupElement = this;
        for (int i2 = 0; i2 < 32; ++i2) {
            int n2;
            GroupElement groupElement2 = groupElement;
            for (n2 = 0; n2 < 8; ++n2) {
                FieldElement fieldElement = groupElement2.Z.invert();
                FieldElement fieldElement2 = groupElement2.X.multiply(fieldElement);
                FieldElement fieldElement3 = groupElement2.Y.multiply(fieldElement);
                groupElementArray[i2][n2] = GroupElement.precomp(this.curve, fieldElement3.add(fieldElement2), fieldElement3.subtract(fieldElement2), fieldElement2.multiply(fieldElement3).multiply(this.curve.get2D()));
                groupElement2 = groupElement2.add(groupElement.toCached()).toP3();
            }
            for (n2 = 0; n2 < 8; ++n2) {
                groupElement = groupElement.add(groupElement.toCached()).toP3();
            }
        }
        return groupElementArray;
    }

    private GroupElement[] precomputeDouble() {
        GroupElement[] groupElementArray = new GroupElement[8];
        GroupElement groupElement = this;
        for (int i2 = 0; i2 < 8; ++i2) {
            FieldElement fieldElement = groupElement.Z.invert();
            FieldElement fieldElement2 = groupElement.X.multiply(fieldElement);
            FieldElement fieldElement3 = groupElement.Y.multiply(fieldElement);
            groupElementArray[i2] = GroupElement.precomp(this.curve, fieldElement3.add(fieldElement2), fieldElement3.subtract(fieldElement2), fieldElement2.multiply(fieldElement3).multiply(this.curve.get2D()));
            groupElement = this.add(this.add(groupElement.toCached()).toP3().toCached()).toP3();
        }
        return groupElementArray;
    }

    public GroupElement dbl() {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement fieldElement = this.X.square();
                FieldElement fieldElement2 = this.Y.square();
                FieldElement fieldElement3 = this.Z.squareAndDouble();
                FieldElement fieldElement4 = this.X.add(this.Y);
                FieldElement fieldElement5 = fieldElement4.square();
                FieldElement fieldElement6 = fieldElement2.add(fieldElement);
                FieldElement fieldElement7 = fieldElement2.subtract(fieldElement);
                return GroupElement.p1p1(this.curve, fieldElement5.subtract(fieldElement6), fieldElement6, fieldElement7, fieldElement3.subtract(fieldElement7));
            }
        }
        throw new UnsupportedOperationException();
    }

    private GroupElement madd(GroupElement groupElement) {
        if (this.repr != GroupElement$Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (groupElement.repr != GroupElement$Representation.PRECOMP) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        FieldElement fieldElement3 = fieldElement.multiply(groupElement.X);
        FieldElement fieldElement4 = fieldElement2.multiply(groupElement.Y);
        FieldElement fieldElement5 = groupElement.Z.multiply(this.T);
        FieldElement fieldElement6 = this.Z.add(this.Z);
        return GroupElement.p1p1(this.curve, fieldElement3.subtract(fieldElement4), fieldElement3.add(fieldElement4), fieldElement6.add(fieldElement5), fieldElement6.subtract(fieldElement5));
    }

    private GroupElement msub(GroupElement groupElement) {
        if (this.repr != GroupElement$Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (groupElement.repr != GroupElement$Representation.PRECOMP) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        FieldElement fieldElement3 = fieldElement.multiply(groupElement.Y);
        FieldElement fieldElement4 = fieldElement2.multiply(groupElement.X);
        FieldElement fieldElement5 = groupElement.Z.multiply(this.T);
        FieldElement fieldElement6 = this.Z.add(this.Z);
        return GroupElement.p1p1(this.curve, fieldElement3.subtract(fieldElement4), fieldElement3.add(fieldElement4), fieldElement6.subtract(fieldElement5), fieldElement6.add(fieldElement5));
    }

    public GroupElement add(GroupElement groupElement) {
        if (this.repr != GroupElement$Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (groupElement.repr != GroupElement$Representation.CACHED) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        FieldElement fieldElement3 = fieldElement.multiply(groupElement.X);
        FieldElement fieldElement4 = fieldElement2.multiply(groupElement.Y);
        FieldElement fieldElement5 = groupElement.T.multiply(this.T);
        FieldElement fieldElement6 = this.Z.multiply(groupElement.Z);
        FieldElement fieldElement7 = fieldElement6.add(fieldElement6);
        return GroupElement.p1p1(this.curve, fieldElement3.subtract(fieldElement4), fieldElement3.add(fieldElement4), fieldElement7.add(fieldElement5), fieldElement7.subtract(fieldElement5));
    }

    public GroupElement sub(GroupElement groupElement) {
        if (this.repr != GroupElement$Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (groupElement.repr != GroupElement$Representation.CACHED) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        FieldElement fieldElement3 = fieldElement.multiply(groupElement.Y);
        FieldElement fieldElement4 = fieldElement2.multiply(groupElement.X);
        FieldElement fieldElement5 = groupElement.T.multiply(this.T);
        FieldElement fieldElement6 = this.Z.multiply(groupElement.Z);
        FieldElement fieldElement7 = fieldElement6.add(fieldElement6);
        return GroupElement.p1p1(this.curve, fieldElement3.subtract(fieldElement4), fieldElement3.add(fieldElement4), fieldElement7.subtract(fieldElement5), fieldElement7.add(fieldElement5));
    }

    public GroupElement negate() {
        if (this.repr != GroupElement$Representation.P3) {
            throw new UnsupportedOperationException();
        }
        return this.curve.getZero(GroupElement$Representation.P3).sub(this.toCached()).toP3PrecomputeDouble();
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GroupElement)) {
            return false;
        }
        GroupElement groupElement = (GroupElement)object;
        if (!this.repr.equals((Object)groupElement.repr)) {
            try {
                groupElement = groupElement.toRep(this.repr);
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }
        switch (this.repr) {
            case P2: 
            case P3: {
                if (this.Z.equals(groupElement.Z)) {
                    return this.X.equals(groupElement.X) && this.Y.equals(groupElement.Y);
                }
                FieldElement fieldElement = this.X.multiply(groupElement.Z);
                FieldElement fieldElement2 = this.Y.multiply(groupElement.Z);
                FieldElement fieldElement3 = groupElement.X.multiply(this.Z);
                FieldElement fieldElement4 = groupElement.Y.multiply(this.Z);
                return fieldElement.equals(fieldElement3) && fieldElement2.equals(fieldElement4);
            }
            case P1P1: {
                return this.toP2().equals(groupElement);
            }
            case PRECOMP: {
                return this.X.equals(groupElement.X) && this.Y.equals(groupElement.Y) && this.Z.equals(groupElement.Z);
            }
            case CACHED: {
                if (this.Z.equals(groupElement.Z)) {
                    return this.X.equals(groupElement.X) && this.Y.equals(groupElement.Y) && this.T.equals(groupElement.T);
                }
                FieldElement fieldElement = this.X.multiply(groupElement.Z);
                FieldElement fieldElement5 = this.Y.multiply(groupElement.Z);
                FieldElement fieldElement6 = this.T.multiply(groupElement.Z);
                FieldElement fieldElement7 = groupElement.X.multiply(this.Z);
                FieldElement fieldElement8 = groupElement.Y.multiply(this.Z);
                FieldElement fieldElement9 = groupElement.T.multiply(this.Z);
                return fieldElement.equals(fieldElement7) && fieldElement5.equals(fieldElement8) && fieldElement6.equals(fieldElement9);
            }
        }
        return false;
    }

    static byte[] toRadix16(byte[] byArray) {
        int n2;
        byte[] byArray2 = new byte[64];
        for (n2 = 0; n2 < 32; ++n2) {
            byArray2[2 * n2 + 0] = (byte)(byArray[n2] & 0xF);
            byArray2[2 * n2 + 1] = (byte)(byArray[n2] >> 4 & 0xF);
        }
        int n3 = 0;
        n2 = 0;
        while (n2 < 63) {
            int n4 = n2;
            byArray2[n4] = (byte)(byArray2[n4] + n3);
            n3 = byArray2[n2] + 8;
            int n5 = n2++;
            byArray2[n5] = (byte)(byArray2[n5] - ((n3 >>= 4) << 4));
        }
        byArray2[63] = (byte)(byArray2[63] + n3);
        return byArray2;
    }

    GroupElement cmov(GroupElement groupElement, int n2) {
        return GroupElement.precomp(this.curve, this.X.cmov(groupElement.X, n2), this.Y.cmov(groupElement.Y, n2), this.Z.cmov(groupElement.Z, n2));
    }

    GroupElement select(int n2, int n3) {
        int n4 = Utils.negative(n3);
        int n5 = n3 - ((-n4 & n3) << 1);
        GroupElement groupElement = this.curve.getZero(GroupElement$Representation.PRECOMP).cmov(this.precmp[n2][0], Utils.equal(n5, 1)).cmov(this.precmp[n2][1], Utils.equal(n5, 2)).cmov(this.precmp[n2][2], Utils.equal(n5, 3)).cmov(this.precmp[n2][3], Utils.equal(n5, 4)).cmov(this.precmp[n2][4], Utils.equal(n5, 5)).cmov(this.precmp[n2][5], Utils.equal(n5, 6)).cmov(this.precmp[n2][6], Utils.equal(n5, 7)).cmov(this.precmp[n2][7], Utils.equal(n5, 8));
        GroupElement groupElement2 = GroupElement.precomp(this.curve, groupElement.Y, groupElement.X, groupElement.Z.negate());
        return groupElement.cmov(groupElement2, n4);
    }

    public GroupElement scalarMultiply(byte[] byArray) {
        GroupElement groupElement;
        int n2;
        byte[] byArray2 = GroupElement.toRadix16(byArray);
        GroupElement groupElement2 = this.curve.getZero(GroupElement$Representation.P3);
        for (n2 = 1; n2 < 64; n2 += 2) {
            groupElement = this.select(n2 / 2, byArray2[n2]);
            groupElement2 = groupElement2.madd(groupElement).toP3();
        }
        groupElement2 = groupElement2.dbl().toP2().dbl().toP2().dbl().toP2().dbl().toP3();
        for (n2 = 0; n2 < 64; n2 += 2) {
            groupElement = this.select(n2 / 2, byArray2[n2]);
            groupElement2 = groupElement2.madd(groupElement).toP3();
        }
        return groupElement2;
    }

    static byte[] slide(byte[] byArray) {
        int n2;
        byte[] byArray2 = new byte[256];
        for (n2 = 0; n2 < 256; ++n2) {
            byArray2[n2] = (byte)(1 & byArray[n2 >> 3] >> (n2 & 7));
        }
        block1: for (n2 = 0; n2 < 256; ++n2) {
            if (byArray2[n2] == 0) continue;
            block2: for (int i2 = 1; i2 <= 6 && n2 + i2 < 256; ++i2) {
                if (byArray2[n2 + i2] == 0) continue;
                if (byArray2[n2] + (byArray2[n2 + i2] << i2) <= 15) {
                    int n3 = n2;
                    byArray2[n3] = (byte)(byArray2[n3] + (byArray2[n2 + i2] << i2));
                    byArray2[n2 + i2] = 0;
                    continue;
                }
                if (byArray2[n2] - (byArray2[n2 + i2] << i2) < -15) continue block1;
                int n4 = n2;
                byArray2[n4] = (byte)(byArray2[n4] - (byArray2[n2 + i2] << i2));
                for (int i3 = n2 + i2; i3 < 256; ++i3) {
                    if (byArray2[i3] == 0) {
                        byArray2[i3] = 1;
                        continue block2;
                    }
                    byArray2[i3] = 0;
                }
            }
        }
        return byArray2;
    }

    public GroupElement doubleScalarMultiplyVariableTime(GroupElement groupElement, byte[] byArray, byte[] byArray2) {
        int n2;
        byte[] byArray3 = GroupElement.slide(byArray);
        byte[] byArray4 = GroupElement.slide(byArray2);
        GroupElement groupElement2 = this.curve.getZero(GroupElement$Representation.P2);
        for (n2 = 255; n2 >= 0 && byArray3[n2] == 0 && byArray4[n2] == 0; --n2) {
        }
        while (n2 >= 0) {
            GroupElement groupElement3 = groupElement2.dbl();
            if (byArray3[n2] > 0) {
                groupElement3 = groupElement3.toP3().madd(groupElement.dblPrecmp[byArray3[n2] / 2]);
            } else if (byArray3[n2] < 0) {
                groupElement3 = groupElement3.toP3().msub(groupElement.dblPrecmp[-byArray3[n2] / 2]);
            }
            if (byArray4[n2] > 0) {
                groupElement3 = groupElement3.toP3().madd(this.dblPrecmp[byArray4[n2] / 2]);
            } else if (byArray4[n2] < 0) {
                groupElement3 = groupElement3.toP3().msub(this.dblPrecmp[-byArray4[n2] / 2]);
            }
            groupElement2 = groupElement3.toP2();
            --n2;
        }
        return groupElement2;
    }

    public boolean isOnCurve() {
        return this.isOnCurve(this.curve);
    }

    public boolean isOnCurve(Curve curve) {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement fieldElement = this.Z.invert();
                FieldElement fieldElement2 = this.X.multiply(fieldElement);
                FieldElement fieldElement3 = this.Y.multiply(fieldElement);
                FieldElement fieldElement4 = fieldElement2.square();
                FieldElement fieldElement5 = fieldElement3.square();
                FieldElement fieldElement6 = curve.getD().multiply(fieldElement4).multiply(fieldElement5);
                return curve.getField().ONE.add(fieldElement6).add(fieldElement4).equals(fieldElement5);
            }
        }
        return this.toP2().isOnCurve(curve);
    }

    public String toString() {
        return "[GroupElement\nX=" + this.X + "\nY=" + this.Y + "\nZ=" + this.Z + "\nT=" + this.T + "\n]";
    }
}

