/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSAGenParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public final class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int DEFAULT_KEYSIZE = 256;
    private EdDSAParameterSpec edParams;
    private SecureRandom random;
    private boolean initialized;
    private static final Hashtable edParameters = new Hashtable();

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        AlgorithmParameterSpec algorithmParameterSpec = (AlgorithmParameterSpec)edParameters.get(n2);
        if (algorithmParameterSpec == null) {
            throw new InvalidParameterException("unknown key type.");
        }
        try {
            this.initialize(algorithmParameterSpec, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException("key type not configurable.");
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (algorithmParameterSpec instanceof EdDSAParameterSpec) {
            this.edParams = (EdDSAParameterSpec)algorithmParameterSpec;
        } else if (algorithmParameterSpec instanceof EdDSAGenParameterSpec) {
            this.edParams = this.createNamedCurveSpec(((EdDSAGenParameterSpec)algorithmParameterSpec).getName());
        } else {
            throw new InvalidAlgorithmParameterException("parameter object not a EdDSAParameterSpec");
        }
        this.random = secureRandom;
        this.initialized = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialized) {
            this.initialize(256, new SecureRandom());
        }
        byte[] byArray = new byte[this.edParams.getCurve().getField().getb() / 8];
        this.random.nextBytes(byArray);
        EdDSAPrivateKeySpec edDSAPrivateKeySpec = new EdDSAPrivateKeySpec(byArray, this.edParams);
        EdDSAPublicKeySpec edDSAPublicKeySpec = new EdDSAPublicKeySpec(edDSAPrivateKeySpec.getA(), this.edParams);
        return new KeyPair(new EdDSAPublicKey(edDSAPublicKeySpec), new EdDSAPrivateKey(edDSAPrivateKeySpec));
    }

    protected EdDSANamedCurveSpec createNamedCurveSpec(String string) {
        EdDSANamedCurveSpec edDSANamedCurveSpec = EdDSANamedCurveTable.getByName(string);
        if (edDSANamedCurveSpec == null) {
            throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
        }
        return edDSANamedCurveSpec;
    }

    static {
        edParameters.put(256, new EdDSAGenParameterSpec("Ed25519"));
    }
}

