/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class EdDSAPublicKey
implements PublicKey,
EdDSAKey {
    private static final long serialVersionUID = 9837459837498475L;
    private final GroupElement A;
    private GroupElement Aneg = null;
    private final byte[] Abyte;
    private final EdDSAParameterSpec edDsaSpec;
    private static final int OID_OLD = 100;
    private static final int OID_ED25519 = 112;
    private static final int OID_BYTE = 8;
    private static final int IDLEN_BYTE = 3;

    public EdDSAPublicKey(EdDSAPublicKeySpec edDSAPublicKeySpec) {
        this.A = edDSAPublicKeySpec.getA();
        this.Abyte = this.A.toByteArray();
        this.edDsaSpec = edDSAPublicKeySpec.getParams();
    }

    public EdDSAPublicKey(X509EncodedKeySpec x509EncodedKeySpec) {
        this(new EdDSAPublicKeySpec(EdDSAPublicKey.decode(x509EncodedKeySpec.getEncoded()), (EdDSAParameterSpec)EdDSANamedCurveTable.ED_25519_CURVE_SPEC));
    }

    @Override
    public String getAlgorithm() {
        return "EdDSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (!this.edDsaSpec.equals(EdDSANamedCurveTable.ED_25519_CURVE_SPEC)) {
            return null;
        }
        int n2 = 12 + this.Abyte.length;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        byArray[n3++] = 48;
        byArray[n3++] = (byte)(n2 - 2);
        byArray[n3++] = 48;
        byArray[n3++] = 5;
        byArray[n3++] = 6;
        byArray[n3++] = 3;
        byArray[n3++] = 43;
        byArray[n3++] = 101;
        byArray[n3++] = 112;
        byArray[n3++] = 3;
        byArray[n3++] = (byte)(1 + this.Abyte.length);
        byArray[n3++] = 0;
        System.arraycopy(this.Abyte, 0, byArray, n3, this.Abyte.length);
        return byArray;
    }

    private static byte[] decode(byte[] byArray) {
        try {
            int n2 = 44;
            byte by = 5;
            byte by2 = byArray[8];
            if (by2 == 100) {
                n2 = 47;
                by = 8;
            } else if (by2 == 112) {
                if (byArray[3] == 7) {
                    n2 = 46;
                    by = 7;
                }
            } else {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            if (byArray.length != n2) {
                throw new InvalidKeySpecException("invalid key spec length");
            }
            int n3 = 0;
            if (byArray[n3++] != 48 || byArray[n3++] != n2 - 2 || byArray[n3++] != 48 || byArray[n3++] != by || byArray[n3++] != 6 || byArray[n3++] != 3 || byArray[n3++] != 43 || byArray[n3++] != 101) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            ++n3;
            if (by2 == 100 ? byArray[n3++] != 10 || byArray[n3++] != 1 || byArray[n3++] != 1 : by == 7 && (byArray[n3++] != 5 || byArray[n3++] != 0)) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            if (byArray[n3++] != 3 || byArray[n3++] != 33 || byArray[n3++] != 0) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            byte[] byArray2 = new byte[32];
            System.arraycopy(byArray, n3, byArray2, 0, 32);
            return byArray2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidKeySpecException(indexOutOfBoundsException);
        }
    }

    @Override
    public EdDSAParameterSpec getParams() {
        return this.edDsaSpec;
    }

    public GroupElement getA() {
        return this.A;
    }

    public GroupElement getNegativeA() {
        GroupElement groupElement = this.Aneg;
        if (groupElement == null) {
            this.Aneg = groupElement = this.A.negate();
        }
        return groupElement;
    }

    public byte[] getAbyte() {
        return this.Abyte;
    }

    public int hashCode() {
        return Arrays.hashCode(this.Abyte);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EdDSAPublicKey)) {
            return false;
        }
        EdDSAPublicKey edDSAPublicKey = (EdDSAPublicKey)object;
        return Arrays.equals(this.Abyte, edDSAPublicKey.getAbyte()) && this.edDsaSpec.equals(edDSAPublicKey.getParams());
    }
}

