/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MimeTypeFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.Vector;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap$1;
import javax.activation.SecuritySupport;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private MimeTypeFile[] DB;
    private static final int PROG = 0;
    private static final String defaultType = "application/octet-stream";
    private static final String confDir;

    public MimetypesFileTypeMap() {
        Vector<MimeTypeFile> vector = new Vector<MimeTypeFile>(5);
        MimeTypeFile mimeTypeFile = null;
        vector.addElement(null);
        LogSupport.log((String)"MimetypesFileTypeMap: load HOME");
        try {
            String string;
            String string2 = System.getProperty("user.home");
            if (string2 != null && (mimeTypeFile = this.loadFile(string = string2 + File.separator + ".mime.types")) != null) {
                vector.addElement(mimeTypeFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log((String)"MimetypesFileTypeMap: load SYS");
        try {
            if (confDir != null && (mimeTypeFile = this.loadFile(confDir + "mime.types")) != null) {
                vector.addElement(mimeTypeFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log((String)"MimetypesFileTypeMap: load JAR");
        this.loadAllResources(vector, "META-INF/mime.types");
        LogSupport.log((String)"MimetypesFileTypeMap: load DEF");
        mimeTypeFile = this.loadResource("/META-INF/mimetypes.default");
        if (mimeTypeFile != null) {
            vector.addElement(mimeTypeFile);
        }
        this.DB = new MimeTypeFile[vector.size()];
        vector.copyInto(this.DB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeTypeFile loadResource(String string) {
        InputStream inputStream = null;
        try {
            inputStream = SecuritySupport.getResourceAsStream(this.getClass(), string);
            if (inputStream != null) {
                MimeTypeFile mimeTypeFile = new MimeTypeFile(inputStream);
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)("MimetypesFileTypeMap: successfully loaded mime types file: " + string));
                }
                MimeTypeFile mimeTypeFile2 = mimeTypeFile;
                return mimeTypeFile2;
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("MimetypesFileTypeMap: not loading mime types file: " + string));
            }
        }
        catch (IOException iOException) {
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("MimetypesFileTypeMap: can't load " + string), (Throwable)iOException);
            }
        }
        catch (SecurityException securityException) {
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("MimetypesFileTypeMap: can't load " + string), (Throwable)securityException);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources(Vector vector, String string) {
        Object object;
        boolean bl2;
        block25: {
            bl2 = false;
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((object = classLoader != null ? SecuritySupport.getResources(classLoader, string) : SecuritySupport.getSystemResources(string)) == null) break block25;
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)"MimetypesFileTypeMap: getResources");
                }
                for (int i2 = 0; i2 < ((MimeTypeFile)object).length; ++i2) {
                    MimeTypeFile mimeTypeFile = object[i2];
                    InputStream inputStream = null;
                    if (LogSupport.isLoggable()) {
                        LogSupport.log((String)("MimetypesFileTypeMap: URL " + mimeTypeFile));
                    }
                    try {
                        inputStream = SecuritySupport.openStream((URL)mimeTypeFile);
                        if (inputStream != null) {
                            vector.addElement(new MimeTypeFile(inputStream));
                            bl2 = true;
                            if (!LogSupport.isLoggable()) continue;
                            LogSupport.log((String)("MimetypesFileTypeMap: successfully loaded mime types from URL: " + mimeTypeFile));
                            continue;
                        }
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log((String)("MimetypesFileTypeMap: not loading mime types from URL: " + mimeTypeFile));
                        continue;
                    }
                    catch (IOException iOException) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log((String)("MimetypesFileTypeMap: can't load " + mimeTypeFile), (Throwable)iOException);
                        continue;
                    }
                    catch (SecurityException securityException) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log((String)("MimetypesFileTypeMap: can't load " + mimeTypeFile), (Throwable)securityException);
                        continue;
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception exception) {
                if (!LogSupport.isLoggable()) break block25;
                LogSupport.log((String)("MimetypesFileTypeMap: can't load " + string), (Throwable)exception);
            }
        }
        if (!bl2) {
            LogSupport.log((String)"MimetypesFileTypeMap: !anyLoaded");
            object = this.loadResource("/" + string);
            if (object != null) {
                vector.addElement(object);
            }
        }
    }

    private MimeTypeFile loadFile(String string) {
        MimeTypeFile mimeTypeFile = null;
        try {
            mimeTypeFile = new MimeTypeFile(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mimeTypeFile;
    }

    public MimetypesFileTypeMap(String string) {
        this();
        this.DB[0] = new MimeTypeFile(string);
    }

    public MimetypesFileTypeMap(InputStream inputStream) {
        this();
        try {
            this.DB[0] = new MimeTypeFile(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void addMimeTypes(String string) {
        if (this.DB[0] == null) {
            this.DB[0] = new MimeTypeFile();
        }
        this.DB[0].appendToRegistry(string);
    }

    public String getContentType(File file) {
        return this.getContentType(file.getName());
    }

    public synchronized String getContentType(String string) {
        int n2 = string.lastIndexOf(".");
        if (n2 < 0) {
            return defaultType;
        }
        String string2 = string.substring(n2 + 1);
        if (string2.length() == 0) {
            return defaultType;
        }
        for (int i2 = 0; i2 < this.DB.length; ++i2) {
            String string3;
            if (this.DB[i2] == null || (string3 = this.DB[i2].getMIMETypeString(string2)) == null) continue;
            return string3;
        }
        return defaultType;
    }

    static {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new MimetypesFileTypeMap$1());
        }
        catch (Exception exception) {
            // empty catch block
        }
        confDir = string;
    }
}

