/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.MailcapCommandMap$1;
import javax.activation.SecuritySupport;

public class MailcapCommandMap
extends CommandMap {
    private MailcapFile[] DB;
    private static final int PROG = 0;
    private static final String confDir;

    public MailcapCommandMap() {
        ArrayList<MailcapFile> arrayList = new ArrayList<MailcapFile>(5);
        MailcapFile mailcapFile = null;
        arrayList.add(null);
        LogSupport.log((String)"MailcapCommandMap: load HOME");
        try {
            String string;
            String string2 = System.getProperty("user.home");
            if (string2 != null && (mailcapFile = this.loadFile(string = string2 + File.separator + ".mailcap")) != null) {
                arrayList.add(mailcapFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log((String)"MailcapCommandMap: load SYS");
        try {
            if (confDir != null && (mailcapFile = this.loadFile(confDir + "mailcap")) != null) {
                arrayList.add(mailcapFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log((String)"MailcapCommandMap: load JAR");
        this.loadAllResources(arrayList, "META-INF/mailcap");
        LogSupport.log((String)"MailcapCommandMap: load DEF");
        mailcapFile = this.loadResource("/META-INF/mailcap.default");
        if (mailcapFile != null) {
            arrayList.add(mailcapFile);
        }
        this.DB = new MailcapFile[arrayList.size()];
        this.DB = arrayList.toArray(this.DB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailcapFile loadResource(String string) {
        InputStream inputStream = null;
        try {
            inputStream = SecuritySupport.getResourceAsStream(this.getClass(), string);
            if (inputStream != null) {
                MailcapFile mailcapFile = new MailcapFile(inputStream);
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)("MailcapCommandMap: successfully loaded mailcap file: " + string));
                }
                MailcapFile mailcapFile2 = mailcapFile;
                return mailcapFile2;
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("MailcapCommandMap: not loading mailcap file: " + string));
            }
        }
        catch (IOException iOException) {
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("MailcapCommandMap: can't load " + string), (Throwable)iOException);
            }
        }
        catch (SecurityException securityException) {
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("MailcapCommandMap: can't load " + string), (Throwable)securityException);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources(List list, String string) {
        Object object;
        boolean bl2;
        block26: {
            bl2 = false;
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((object = classLoader != null ? SecuritySupport.getResources(classLoader, string) : SecuritySupport.getSystemResources(string)) == null) break block26;
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)"MailcapCommandMap: getResources");
                }
                for (int i2 = 0; i2 < ((MailcapFile)object).length; ++i2) {
                    MailcapFile mailcapFile = object[i2];
                    InputStream inputStream = null;
                    if (LogSupport.isLoggable()) {
                        LogSupport.log((String)("MailcapCommandMap: URL " + mailcapFile));
                    }
                    try {
                        inputStream = SecuritySupport.openStream((URL)mailcapFile);
                        if (inputStream != null) {
                            list.add(new MailcapFile(inputStream));
                            bl2 = true;
                            if (!LogSupport.isLoggable()) continue;
                            LogSupport.log((String)("MailcapCommandMap: successfully loaded mailcap file from URL: " + mailcapFile));
                            continue;
                        }
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log((String)("MailcapCommandMap: not loading mailcap file from URL: " + mailcapFile));
                        continue;
                    }
                    catch (IOException iOException) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log((String)("MailcapCommandMap: can't load " + mailcapFile), (Throwable)iOException);
                        continue;
                    }
                    catch (SecurityException securityException) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log((String)("MailcapCommandMap: can't load " + mailcapFile), (Throwable)securityException);
                        continue;
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception exception) {
                if (!LogSupport.isLoggable()) break block26;
                LogSupport.log((String)("MailcapCommandMap: can't load " + string), (Throwable)exception);
            }
        }
        if (!bl2) {
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)"MailcapCommandMap: !anyLoaded");
            }
            if ((object = this.loadResource("/" + string)) != null) {
                list.add(object);
            }
        }
    }

    private MailcapFile loadFile(String string) {
        MailcapFile mailcapFile = null;
        try {
            mailcapFile = new MailcapFile(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mailcapFile;
    }

    public MailcapCommandMap(String string) {
        this();
        if (LogSupport.isLoggable()) {
            LogSupport.log((String)("MailcapCommandMap: load PROG from " + string));
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile(string);
        }
    }

    public MailcapCommandMap(InputStream inputStream) {
        this();
        LogSupport.log((String)"MailcapCommandMap: load PROG");
        if (this.DB[0] == null) {
            try {
                this.DB[0] = new MailcapFile(inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized CommandInfo[] getPreferredCommands(String string) {
        Map map;
        int n2;
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (map = this.DB[n2].getMailcapList(string)) == null) continue;
            this.appendPrefCmdsToList(map, arrayList);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (map = this.DB[n2].getMailcapFallbackList(string)) == null) continue;
            this.appendPrefCmdsToList(map, arrayList);
        }
        CommandInfo[] commandInfoArray = new CommandInfo[arrayList.size()];
        commandInfoArray = arrayList.toArray(commandInfoArray);
        return commandInfoArray;
    }

    private void appendPrefCmdsToList(Map map, List list) {
        for (String string : map.keySet()) {
            if (this.checkForVerb(list, string)) continue;
            List list2 = (List)map.get(string);
            String string2 = (String)list2.get(0);
            list.add(new CommandInfo(string, string2));
        }
    }

    private boolean checkForVerb(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = ((CommandInfo)iterator.next()).getCommandName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized CommandInfo[] getAllCommands(String string) {
        Map map;
        int n2;
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (map = this.DB[n2].getMailcapList(string)) == null) continue;
            this.appendCmdsToList(map, arrayList);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (map = this.DB[n2].getMailcapFallbackList(string)) == null) continue;
            this.appendCmdsToList(map, arrayList);
        }
        CommandInfo[] commandInfoArray = new CommandInfo[arrayList.size()];
        commandInfoArray = arrayList.toArray(commandInfoArray);
        return commandInfoArray;
    }

    private void appendCmdsToList(Map map, List list) {
        for (String string : map.keySet()) {
            List list2 = (List)map.get(string);
            for (String string2 : list2) {
                list.add(new CommandInfo(string, string2));
            }
        }
    }

    public synchronized CommandInfo getCommand(String string, String string2) {
        String string3;
        List list;
        Map map;
        int n2;
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (map = this.DB[n2].getMailcapList(string)) == null || (list = (List)map.get(string2)) == null || (string3 = (String)list.get(0)) == null) continue;
            return new CommandInfo(string2, string3);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (map = this.DB[n2].getMailcapFallbackList(string)) == null || (list = (List)map.get(string2)) == null || (string3 = (String)list.get(0)) == null) continue;
            return new CommandInfo(string2, string3);
        }
        return null;
    }

    public synchronized void addMailcap(String string) {
        LogSupport.log((String)"MailcapCommandMap: add to PROG");
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile();
        }
        this.DB[0].appendToMailcap(string);
    }

    public synchronized DataContentHandler createDataContentHandler(String string) {
        String string2;
        DataContentHandler dataContentHandler;
        List list;
        Map map;
        int n2;
        if (LogSupport.isLoggable()) {
            LogSupport.log((String)("MailcapCommandMap: createDataContentHandler for " + string));
        }
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("  search DB #" + n2));
            }
            if ((map = this.DB[n2].getMailcapList(string)) == null || (list = (List)map.get("content-handler")) == null || (dataContentHandler = this.getDataContentHandler(string2 = (String)list.get(0))) == null) continue;
            return dataContentHandler;
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("  search fallback DB #" + n2));
            }
            if ((map = this.DB[n2].getMailcapFallbackList(string)) == null || (list = (List)map.get("content-handler")) == null || (dataContentHandler = this.getDataContentHandler(string2 = (String)list.get(0))) == null) continue;
            return dataContentHandler;
        }
        return null;
    }

    private DataContentHandler getDataContentHandler(String string) {
        block12: {
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)"    got content-handler");
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("      class " + string));
            }
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Class<?> clazz = null;
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (Exception exception) {
                    clazz = Class.forName(string);
                }
                if (clazz != null) {
                    return (DataContentHandler)clazz.newInstance();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)("Can't load DCH " + string), (Throwable)illegalAccessException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)("Can't load DCH " + string), (Throwable)classNotFoundException);
                }
            }
            catch (InstantiationException instantiationException) {
                if (!LogSupport.isLoggable()) break block12;
                LogSupport.log((String)("Can't load DCH " + string), (Throwable)instantiationException);
            }
        }
        return null;
    }

    public synchronized String[] getMimeTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.DB.length; ++i2) {
            String[] stringArray;
            if (this.DB[i2] == null || (stringArray = this.DB[i2].getMimeTypes()) == null) continue;
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (arrayList.contains(stringArray[i3])) continue;
                arrayList.add(stringArray[i3]);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public synchronized String[] getNativeCommands(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (int i2 = 0; i2 < this.DB.length; ++i2) {
            String[] stringArray;
            if (this.DB[i2] == null || (stringArray = this.DB[i2].getNativeCommands(string)) == null) continue;
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (arrayList.contains(stringArray[i3])) continue;
                arrayList.add(stringArray[i3]);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    static {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new MailcapCommandMap$1());
        }
        catch (Exception exception) {
            // empty catch block
        }
        confDir = string;
    }
}

