/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import javax.activation.MimetypesFileTypeMap;
import javax.activation.SecuritySupport;

public abstract class FileTypeMap {
    private static FileTypeMap defaultMap = null;
    private static Map map = new WeakHashMap();

    public abstract String getContentType(File var1);

    public abstract String getContentType(String var1);

    public static synchronized void setDefaultFileTypeMap(FileTypeMap fileTypeMap) {
        block3: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSetFactory();
                }
                catch (SecurityException securityException) {
                    ClassLoader classLoader = FileTypeMap.class.getClassLoader();
                    if (classLoader != null && classLoader.getParent() != null && classLoader == fileTypeMap.getClass().getClassLoader()) break block3;
                    throw securityException;
                }
            }
        }
        map.remove(SecuritySupport.getContextClassLoader());
        defaultMap = fileTypeMap;
    }

    public static synchronized FileTypeMap getDefaultFileTypeMap() {
        if (defaultMap != null) {
            return defaultMap;
        }
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        FileTypeMap fileTypeMap = (FileTypeMap)map.get(classLoader);
        if (fileTypeMap == null) {
            fileTypeMap = new MimetypesFileTypeMap();
            map.put(classLoader, fileTypeMap);
        }
        return fileTypeMap;
    }
}

