/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.Map;
import java.util.WeakHashMap;
import javax.activation.CommandInfo;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.activation.SecuritySupport;

public abstract class CommandMap {
    private static CommandMap defaultCommandMap = null;
    private static Map map = new WeakHashMap();

    public static synchronized CommandMap getDefaultCommandMap() {
        if (defaultCommandMap != null) {
            return defaultCommandMap;
        }
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        CommandMap commandMap = (CommandMap)map.get(classLoader);
        if (commandMap == null) {
            commandMap = new MailcapCommandMap();
            map.put(classLoader, commandMap);
        }
        return commandMap;
    }

    public static synchronized void setDefaultCommandMap(CommandMap commandMap) {
        block3: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSetFactory();
                }
                catch (SecurityException securityException) {
                    ClassLoader classLoader = CommandMap.class.getClassLoader();
                    if (classLoader != null && classLoader.getParent() != null && classLoader == commandMap.getClass().getClassLoader()) break block3;
                    throw securityException;
                }
            }
        }
        map.remove(SecuritySupport.getContextClassLoader());
        defaultCommandMap = commandMap;
    }

    public abstract CommandInfo[] getPreferredCommands(String var1);

    public CommandInfo[] getPreferredCommands(String string, DataSource dataSource) {
        return this.getPreferredCommands(string);
    }

    public abstract CommandInfo[] getAllCommands(String var1);

    public CommandInfo[] getAllCommands(String string, DataSource dataSource) {
        return this.getAllCommands(string);
    }

    public abstract CommandInfo getCommand(String var1, String var2);

    public CommandInfo getCommand(String string, String string2, DataSource dataSource) {
        return this.getCommand(string, string2);
    }

    public abstract DataContentHandler createDataContentHandler(String var1);

    public DataContentHandler createDataContentHandler(String string, DataSource dataSource) {
        return this.createDataContentHandler(string);
    }

    public String[] getMimeTypes() {
        return null;
    }
}

