/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.media;

import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaConfusionDetector;
import de.regnis.q.sequence.media.QSequenceIntMedia;

public abstract class QSequenceDiscardingMediaBlock {
    private final QSequenceIntMedia media;
    private final int[] undiscardedSymbols;
    private final int[] undiscardedIndices;
    private int undiscardedSymbolCount;

    protected abstract int[] getAllSymbols(QSequenceIntMedia var1);

    protected QSequenceDiscardingMediaBlock(QSequenceIntMedia qSequenceIntMedia) {
        this.media = qSequenceIntMedia;
        this.undiscardedSymbols = new int[this.getAllSymbols(qSequenceIntMedia).length];
        this.undiscardedIndices = new int[this.getAllSymbols(qSequenceIntMedia).length];
        this.undiscardedSymbolCount = 0;
    }

    public int getUndiscardedSymbolCount() {
        return this.undiscardedSymbolCount;
    }

    public int[] getUndiscardedSymbols() {
        return this.undiscardedSymbols;
    }

    public int getMediaIndex(int n2) {
        return this.undiscardedIndices[n2];
    }

    public void init(QSequenceDiscardingMediaBlock qSequenceDiscardingMediaBlock, QSequenceDiscardingMediaConfusionDetector qSequenceDiscardingMediaConfusionDetector) {
        QSequenceAssert.assertNotNull(qSequenceDiscardingMediaConfusionDetector);
        int[] nArray = this.getAllSymbols(this.media);
        int[] nArray2 = qSequenceDiscardingMediaBlock.getAllSymbols(this.media);
        int[] nArray3 = QSequenceDiscardingMediaBlock.createEquivalences(nArray2, this.media);
        byte[] byArray = QSequenceDiscardingMediaBlock.createDiscardableMarkers(nArray, nArray3, qSequenceDiscardingMediaConfusionDetector);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (byArray[i2] == 1) continue;
            this.undiscardedSymbols[this.undiscardedSymbolCount] = nArray[i2];
            this.undiscardedIndices[this.undiscardedSymbolCount] = i2;
            ++this.undiscardedSymbolCount;
        }
    }

    private static int[] createEquivalences(int[] nArray, QSequenceIntMedia qSequenceIntMedia) {
        int[] nArray2 = new int[qSequenceIntMedia.getSymbolCount()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            nArray2[n2] = nArray2[n2] + 1;
        }
        return nArray2;
    }

    private static byte[] createDiscardableMarkers(int[] nArray, int[] nArray2, QSequenceDiscardingMediaConfusionDetector qSequenceDiscardingMediaConfusionDetector) {
        byte[] byArray = new byte[nArray.length];
        qSequenceDiscardingMediaConfusionDetector.init(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray2[nArray[i2]];
            if (qSequenceDiscardingMediaConfusionDetector.isAbsolute(n2)) {
                byArray[i2] = 1;
                continue;
            }
            if (!qSequenceDiscardingMediaConfusionDetector.isProvisional(n2)) continue;
            byArray[i2] = 2;
        }
        return byArray;
    }
}

