/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.media;

import de.regnis.q.sequence.core.QSequenceCanceller;
import de.regnis.q.sequence.core.QSequenceMedia;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaBlock;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaConfusionDetector;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaLeftBlock;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaRightBlock;
import de.regnis.q.sequence.media.QSequenceIntMedia;
import de.regnis.q.sequence.media.QSequenceMediaIndexTransformer;

public class QSequenceDiscardingMedia
implements QSequenceMedia,
QSequenceMediaIndexTransformer {
    private final QSequenceIntMedia media;
    private final QSequenceCanceller canceller;
    private final QSequenceDiscardingMediaBlock leftBlock;
    private final QSequenceDiscardingMediaBlock rightBlock;
    private final int[] undiscardedLeftSymbols;
    private final int[] undiscardedRightSymbols;
    private final int undiscardedLeftSymbolCount;
    private final int undiscardedRightSymbolCount;

    public QSequenceDiscardingMedia(QSequenceIntMedia qSequenceIntMedia, QSequenceDiscardingMediaConfusionDetector qSequenceDiscardingMediaConfusionDetector, QSequenceCanceller qSequenceCanceller) {
        this.media = qSequenceIntMedia;
        this.canceller = qSequenceCanceller;
        this.leftBlock = new QSequenceDiscardingMediaLeftBlock(this.media);
        this.rightBlock = new QSequenceDiscardingMediaRightBlock(this.media);
        this.leftBlock.init(this.rightBlock, qSequenceDiscardingMediaConfusionDetector);
        this.rightBlock.init(this.leftBlock, qSequenceDiscardingMediaConfusionDetector);
        this.undiscardedLeftSymbols = this.leftBlock.getUndiscardedSymbols();
        this.undiscardedLeftSymbolCount = this.leftBlock.getUndiscardedSymbolCount();
        this.undiscardedRightSymbols = this.rightBlock.getUndiscardedSymbols();
        this.undiscardedRightSymbolCount = this.rightBlock.getUndiscardedSymbolCount();
    }

    public int getLeftLength() {
        return this.undiscardedLeftSymbolCount;
    }

    public int getRightLength() {
        return this.undiscardedRightSymbolCount;
    }

    public boolean equals(int n2, int n3) {
        this.canceller.checkCancelled();
        return this.undiscardedLeftSymbols[n2] == this.undiscardedRightSymbols[n3];
    }

    public int getMediaLeftIndex(int n2) {
        return this.leftBlock.getMediaIndex(n2);
    }

    public int getMediaRightIndex(int n2) {
        return this.rightBlock.getMediaIndex(n2);
    }

    public int getMediaLeftLength() {
        return this.media.getLeftLength();
    }

    public int getMediaRightLength() {
        return this.media.getRightLength();
    }
}

