/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line.diff;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.diff.QDiffGenerator;
import de.regnis.q.sequence.line.diff.QDiffGeneratorFactory;
import de.regnis.q.sequence.line.diff.QDiffManager;
import de.regnis.q.sequence.line.diff.QDiffSequenceGenerator;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class QDiffUniGenerator
extends QDiffSequenceGenerator
implements QDiffGeneratorFactory {
    public static final String TYPE = "unified";
    private Map myGeneratorsCache;

    public static void setup() {
        QDiffManager.registerDiffGeneratorFactory(new QDiffUniGenerator(), TYPE);
    }

    public QDiffUniGenerator(Map map, String string) {
        super(QDiffUniGenerator.initProperties(map), string);
    }

    private QDiffUniGenerator() {
        super(null, null);
    }

    public void generateDiffHeader(String string, String string2, String string3, Writer writer) {
        string2 = string2 == null ? "" : "\t" + string2;
        string3 = string3 == null ? "" : "\t" + string3;
        this.println("--- " + string + string2, writer);
        this.println("+++ " + string + string3, writer);
    }

    protected void processBlock(QSequenceDifferenceBlock[] qSequenceDifferenceBlockArray, QSequenceLineCache qSequenceLineCache, QSequenceLineCache qSequenceLineCache2, String string, Writer writer) {
        int n2;
        int n3 = this.getGutter();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHunkDelimiter());
        int n4 = qSequenceDifferenceBlockArray[0].getLeftFrom();
        int n5 = qSequenceDifferenceBlockArray[qSequenceDifferenceBlockArray.length - 1].getLeftTo();
        int n6 = qSequenceDifferenceBlockArray[0].getRightFrom();
        int n7 = qSequenceDifferenceBlockArray[qSequenceDifferenceBlockArray.length - 1].getRightTo();
        int n8 = Math.max(n4 - n3, 0);
        int n9 = Math.max(n6 - n3, 0);
        int n10 = Math.min(n5 + n3, qSequenceLineCache.getLineCount() - 1);
        int n11 = Math.min(n7 + n3, qSequenceLineCache2.getLineCount() - 1);
        if (n8 + 1 >= 0 && n10 - n8 + 1 >= 0) {
            stringBuffer.append(" -");
            if (n8 == 0 && n10 < 0) {
                stringBuffer.append("0,0");
            } else {
                stringBuffer.append(n8 + 1);
                if (n10 - n8 + 1 > 1) {
                    stringBuffer.append(",");
                    stringBuffer.append(n10 - n8 + 1);
                }
            }
        }
        if (n9 + 1 > 0 && n11 - n9 + 1 > 0) {
            stringBuffer.append(" +");
            stringBuffer.append(n9 + 1);
            if (n11 - n9 + 1 > 1) {
                stringBuffer.append(",");
                stringBuffer.append(n11 - n9 + 1);
            }
        } else {
            stringBuffer.append(" +0,0");
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.getHunkDelimiter());
        this.println(stringBuffer.toString(), writer);
        for (n2 = n8; n2 < n4; ++n2) {
            this.print(" " + this.printLine(qSequenceLineCache.getLine(n2), string), writer);
        }
        for (n2 = 0; n2 < qSequenceDifferenceBlockArray.length; ++n2) {
            String string2;
            int n12;
            QSequenceDifferenceBlock qSequenceDifferenceBlock = qSequenceDifferenceBlockArray[n2];
            for (n12 = qSequenceDifferenceBlock.getLeftFrom(); n12 <= qSequenceDifferenceBlock.getLeftTo(); ++n12) {
                string2 = this.printLine(qSequenceLineCache.getLine(n12), string);
                this.print("-" + string2, writer);
                if (n12 != qSequenceLineCache.getLineCount() - 1) continue;
                this.printNoNewLine(writer, string2);
            }
            for (n12 = qSequenceDifferenceBlock.getRightFrom(); n12 <= qSequenceDifferenceBlock.getRightTo(); ++n12) {
                string2 = this.printLine(qSequenceLineCache2.getLine(n12), string);
                this.print("+" + string2, writer);
                if (n12 != qSequenceLineCache2.getLineCount() - 1) continue;
                this.printNoNewLine(writer, string2);
            }
            n12 = n2 < qSequenceDifferenceBlockArray.length - 1 ? qSequenceDifferenceBlockArray[n2 + 1].getLeftFrom() - 1 : qSequenceDifferenceBlock.getLeftTo() + n3;
            int n13 = Math.min(n12, qSequenceLineCache.getLineCount() - 1);
            if (n2 + 1 < qSequenceDifferenceBlockArray.length) {
                n13 = Math.min(n13, qSequenceDifferenceBlockArray[n2 + 1].getLeftFrom() - 1);
            }
            for (int i2 = qSequenceDifferenceBlock.getLeftTo() + 1; i2 <= n13; ++i2) {
                String string3 = this.printLine(qSequenceLineCache.getLine(i2), string);
                this.print(" " + this.printLine(qSequenceLineCache.getLine(i2), string), writer);
                if (i2 != qSequenceLineCache.getLineCount() - 1) continue;
                this.printNoNewLine(writer, string3);
            }
        }
    }

    protected void processBlock(QSequenceDifferenceBlock[] qSequenceDifferenceBlockArray, QSequenceLineCache qSequenceLineCache, QSequenceLineCache qSequenceLineCache2, OutputStream outputStream) {
        int n2;
        int n3 = this.getGutter();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHunkDelimiter());
        int n4 = qSequenceDifferenceBlockArray[0].getLeftFrom();
        int n5 = qSequenceDifferenceBlockArray[qSequenceDifferenceBlockArray.length - 1].getLeftTo();
        int n6 = qSequenceDifferenceBlockArray[0].getRightFrom();
        int n7 = qSequenceDifferenceBlockArray[qSequenceDifferenceBlockArray.length - 1].getRightTo();
        int n8 = Math.max(n4 - n3, 0);
        int n9 = Math.max(n6 - n3, 0);
        int n10 = Math.min(n5 + n3, qSequenceLineCache.getLineCount() - 1);
        int n11 = Math.min(n7 + n3, qSequenceLineCache2.getLineCount() - 1);
        if (n8 + 1 >= 0 && n10 - n8 + 1 >= 0) {
            stringBuffer.append(" -");
            if (n8 == 0 && n10 < 0) {
                stringBuffer.append("0,0");
            } else {
                stringBuffer.append(n8 + 1);
                if (n10 - n8 + 1 > 1) {
                    stringBuffer.append(",");
                    stringBuffer.append(n10 - n8 + 1);
                }
            }
        }
        if (n9 + 1 > 0 && n11 - n9 + 1 > 0) {
            stringBuffer.append(" +");
            stringBuffer.append(n9 + 1);
            if (n11 - n9 + 1 > 1) {
                stringBuffer.append(",");
                stringBuffer.append(n11 - n9 + 1);
            }
        } else {
            stringBuffer.append(" +0,0");
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.getHunkDelimiter());
        this.println(stringBuffer.toString(), outputStream);
        for (n2 = n8; n2 < n4; ++n2) {
            outputStream.write(32);
            outputStream.write(qSequenceLineCache.getLine(n2).getContentBytes());
        }
        for (n2 = 0; n2 < qSequenceDifferenceBlockArray.length; ++n2) {
            byte[] byArray;
            int n12;
            QSequenceDifferenceBlock qSequenceDifferenceBlock = qSequenceDifferenceBlockArray[n2];
            for (n12 = qSequenceDifferenceBlock.getLeftFrom(); n12 <= qSequenceDifferenceBlock.getLeftTo(); ++n12) {
                outputStream.write(45);
                byArray = qSequenceLineCache.getLine(n12).getContentBytes();
                outputStream.write(byArray);
                if (n12 != qSequenceLineCache.getLineCount() - 1) continue;
                this.printNoNewLine(outputStream, byArray);
            }
            for (n12 = qSequenceDifferenceBlock.getRightFrom(); n12 <= qSequenceDifferenceBlock.getRightTo(); ++n12) {
                outputStream.write(43);
                byArray = qSequenceLineCache2.getLine(n12).getContentBytes();
                outputStream.write(byArray);
                if (n12 != qSequenceLineCache2.getLineCount() - 1) continue;
                this.printNoNewLine(outputStream, byArray);
            }
            n12 = n2 < qSequenceDifferenceBlockArray.length - 1 ? qSequenceDifferenceBlockArray[n2 + 1].getLeftFrom() - 1 : qSequenceDifferenceBlock.getLeftTo() + n3;
            int n13 = Math.min(n12, qSequenceLineCache.getLineCount() - 1);
            if (n2 + 1 < qSequenceDifferenceBlockArray.length) {
                n13 = Math.min(n13, qSequenceDifferenceBlockArray[n2 + 1].getLeftFrom() - 1);
            }
            for (int i2 = qSequenceDifferenceBlock.getLeftTo() + 1; i2 <= n13; ++i2) {
                outputStream.write(32);
                byte[] byArray2 = qSequenceLineCache.getLine(i2).getContentBytes();
                outputStream.write(byArray2);
                if (i2 != qSequenceLineCache.getLineCount() - 1) continue;
                this.printNoNewLine(outputStream, byArray2);
            }
        }
    }

    public QDiffGenerator createGenerator(Map map) {
        QDiffGenerator qDiffGenerator;
        if (this.myGeneratorsCache == null) {
            this.myGeneratorsCache = new HashMap();
        }
        if ((qDiffGenerator = (QDiffGenerator)this.myGeneratorsCache.get(map)) != null) {
            return qDiffGenerator;
        }
        qDiffGenerator = new QDiffUniGenerator(map, null);
        this.myGeneratorsCache.put(map, qDiffGenerator);
        return qDiffGenerator;
    }

    private void printNoNewLine(Writer writer, String string) {
        if (!string.endsWith("\n") && !string.endsWith("\r")) {
            this.println(writer);
            this.println("\\ No newline at end of file", writer);
        }
    }

    private void printNoNewLine(OutputStream outputStream, byte[] byArray) {
        if (byArray[byArray.length - 1] != 10 && byArray[byArray.length - 1] != 13) {
            this.println(outputStream);
            this.println("\\ No newline at end of file", outputStream);
        }
    }

    private static Map initProperties(Map hashMap) {
        if (hashMap == null || !hashMap.containsKey("gutter")) {
            hashMap = new HashMap<String, String>(hashMap == null ? Collections.EMPTY_MAP : hashMap);
            hashMap.put("gutter", "3");
        }
        return hashMap;
    }
}

