/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line.diff;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.line.QSequenceLine;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineMedia;
import de.regnis.q.sequence.line.QSequenceLineRAByteData;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import de.regnis.q.sequence.line.diff.QDiffGenerator;
import de.regnis.q.sequence.line.simplifier.QSequenceLineDummySimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineEOLUnifyingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineTeeSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceReducingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceSkippingSimplifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class QDiffSequenceGenerator
implements QDiffGenerator {
    private final String header;
    private Map myProperties;

    protected abstract void processBlock(QSequenceDifferenceBlock[] var1, QSequenceLineCache var2, QSequenceLineCache var3, String var4, Writer var5);

    protected abstract void processBlock(QSequenceDifferenceBlock[] var1, QSequenceLineCache var2, QSequenceLineCache var3, OutputStream var4);

    protected QDiffSequenceGenerator(Map map, String string) {
        this.header = string;
        this.myProperties = map == null ? Collections.EMPTY_MAP : map;
        this.myProperties = Collections.unmodifiableMap(this.myProperties);
    }

    public void generateBinaryDiff(InputStream inputStream, InputStream inputStream2, String string, Writer writer) {
        this.println("Binary files are different", writer);
    }

    public void generateTextDiff(InputStream inputStream, InputStream inputStream2, String string, Writer writer) {
        this.generateTextDiff(QSequenceLineRAByteData.create(inputStream), QSequenceLineRAByteData.create(inputStream2), string, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTextDiff(QSequenceLineRAData qSequenceLineRAData, QSequenceLineRAData qSequenceLineRAData2, String string, Writer writer) {
        QSequenceLineResult qSequenceLineResult;
        try {
            qSequenceLineResult = QSequenceLineMedia.createBlocks(qSequenceLineRAData, qSequenceLineRAData2, this.getSimplifier());
        }
        catch (QSequenceException qSequenceException) {
            throw new IOException(qSequenceException.getMessage());
        }
        try {
            List list = QDiffSequenceGenerator.combineBlocks(qSequenceLineResult.getBlocks(), this.getGutter());
            boolean bl2 = false;
            for (List list2 : list) {
                if (list2.isEmpty()) continue;
                if (!bl2 && this.header != null) {
                    bl2 = true;
                    writer.write(this.header);
                }
                QSequenceDifferenceBlock[] qSequenceDifferenceBlockArray = list2.toArray(new QSequenceDifferenceBlock[list2.size()]);
                this.processBlock(qSequenceDifferenceBlockArray, qSequenceLineResult.getLeftCache(), qSequenceLineResult.getRightCache(), string, writer);
            }
        }
        finally {
            qSequenceLineResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTextDiff(QSequenceLineRAData qSequenceLineRAData, QSequenceLineRAData qSequenceLineRAData2, OutputStream outputStream) {
        QSequenceLineResult qSequenceLineResult;
        try {
            qSequenceLineResult = QSequenceLineMedia.createBlocks(qSequenceLineRAData, qSequenceLineRAData2, this.getSimplifier());
        }
        catch (QSequenceException qSequenceException) {
            throw new IOException(qSequenceException.getMessage());
        }
        try {
            List list = QDiffSequenceGenerator.combineBlocks(qSequenceLineResult.getBlocks(), this.getGutter());
            boolean bl2 = false;
            for (List list2 : list) {
                if (list2.isEmpty()) continue;
                if (!bl2 && this.header != null) {
                    bl2 = true;
                    outputStream.write(this.header.getBytes("UTF-8"));
                }
                QSequenceDifferenceBlock[] qSequenceDifferenceBlockArray = list2.toArray(new QSequenceDifferenceBlock[list2.size()]);
                this.processBlock(qSequenceDifferenceBlockArray, qSequenceLineResult.getLeftCache(), qSequenceLineResult.getRightCache(), outputStream);
            }
        }
        finally {
            qSequenceLineResult.close();
        }
    }

    public void generateTextDiff(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, String string, Writer writer) {
        QSequenceLineRAData qSequenceLineRAData = null;
        QSequenceLineRAData qSequenceLineRAData2 = null;
        qSequenceLineRAData = randomAccessFile == null ? new QSequenceLineRAByteData(new byte[0]) : new QSequenceLineRAFileData(randomAccessFile);
        qSequenceLineRAData2 = randomAccessFile2 == null ? new QSequenceLineRAByteData(new byte[0]) : new QSequenceLineRAFileData(randomAccessFile2);
        this.generateTextDiff(qSequenceLineRAData, qSequenceLineRAData2, string, writer);
    }

    public void generateTextDiff(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, OutputStream outputStream) {
        QSequenceLineRAData qSequenceLineRAData = null;
        QSequenceLineRAData qSequenceLineRAData2 = null;
        qSequenceLineRAData = randomAccessFile == null ? new QSequenceLineRAByteData(new byte[0]) : new QSequenceLineRAFileData(randomAccessFile);
        qSequenceLineRAData2 = randomAccessFile2 == null ? new QSequenceLineRAByteData(new byte[0]) : new QSequenceLineRAFileData(randomAccessFile2);
        this.generateTextDiff(qSequenceLineRAData, qSequenceLineRAData2, outputStream);
    }

    protected Map getProperties() {
        return this.myProperties;
    }

    protected String getHunkDelimiter() {
        Object v2 = this.getProperties().get("hunk-delimiter");
        if (v2 != null && v2 instanceof String) {
            return (String)v2;
        }
        return "@@";
    }

    protected String getEOL() {
        if (this.getProperties().get("eol") instanceof String) {
            return (String)this.getProperties().get("eol");
        }
        return System.getProperty("line.separator", "\n");
    }

    protected QSequenceLineSimplifier getSimplifier() {
        Object v2 = this.getProperties().get("ignore-space");
        QSequenceLineSimplifier qSequenceLineSimplifier = "all-space".equals(v2) ? new QSequenceLineWhiteSpaceSkippingSimplifier() : ("space-change".equals(v2) ? new QSequenceLineWhiteSpaceReducingSimplifier() : new QSequenceLineDummySimplifier());
        if (this.getProperties().containsKey("ignore-eol-style")) {
            return new QSequenceLineTeeSimplifier(qSequenceLineSimplifier, new QSequenceLineEOLUnifyingSimplifier());
        }
        return qSequenceLineSimplifier;
    }

    protected int getGutter() {
        Object v2 = this.getProperties().get("gutter");
        if (v2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(v2.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected String printLine(QSequenceLine qSequenceLine, String string) {
        String string2 = new String(qSequenceLine.getContentBytes(), string);
        return string2;
    }

    protected void println(Writer writer) {
        writer.write(this.getEOL());
    }

    protected void println(OutputStream outputStream) {
        outputStream.write(this.getEOL().getBytes("UTF-8"));
    }

    protected void println(String string, Writer writer) {
        if (string != null) {
            writer.write(string);
        }
        writer.write(this.getEOL());
    }

    protected void println(String string, OutputStream outputStream) {
        if (string != null) {
            outputStream.write(string.getBytes("UTF-8"));
        }
        outputStream.write(this.getEOL().getBytes("UTF-8"));
    }

    protected void print(String string, Writer writer) {
        if (string != null) {
            writer.write(string);
        }
    }

    protected void print(String string, OutputStream outputStream) {
        if (string != null) {
            outputStream.write(string.getBytes("UTF-8"));
        }
    }

    private static List combineBlocks(List list, int n2) {
        LinkedList linkedList = new LinkedList();
        LinkedList<QSequenceDifferenceBlock> linkedList2 = new LinkedList<QSequenceDifferenceBlock>();
        QSequenceDifferenceBlock qSequenceDifferenceBlock = null;
        for (QSequenceDifferenceBlock qSequenceDifferenceBlock2 : list) {
            if (qSequenceDifferenceBlock != null) {
                int n3 = qSequenceDifferenceBlock2.getLeftFrom() - 1 - qSequenceDifferenceBlock.getLeftTo();
                int n4 = qSequenceDifferenceBlock2.getRightFrom() - 1 - qSequenceDifferenceBlock.getRightTo();
                if (n3 > 2 * n2 && n4 > 2 * n2) {
                    linkedList.add(linkedList2);
                    linkedList2 = new LinkedList();
                }
            }
            linkedList2.add(qSequenceDifferenceBlock2);
            qSequenceDifferenceBlock = qSequenceDifferenceBlock2;
        }
        if (!linkedList.contains(linkedList2)) {
            linkedList.add(linkedList2);
        }
        return linkedList;
    }
}

