/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line.diff;

import de.regnis.q.sequence.line.diff.QDiffGenerator;
import de.regnis.q.sequence.line.diff.QDiffGeneratorFactory;
import de.regnis.q.sequence.line.diff.QDiffNormalGenerator;
import de.regnis.q.sequence.line.diff.QDiffUniGenerator;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class QDiffManager {
    public static final String DEFAULT_TYPE = "normal";
    private static Map ourDiffGeneratorFactories;

    public static void setup() {
        QDiffNormalGenerator.setup();
        QDiffUniGenerator.setup();
    }

    public static QDiffGenerator getDiffGenerator(String string, Map map) {
        if (ourDiffGeneratorFactories == null || !ourDiffGeneratorFactories.containsKey(string)) {
            return null;
        }
        return ((QDiffGeneratorFactory)ourDiffGeneratorFactories.get(string)).createGenerator(map);
    }

    public static void generateDiffHeader(String string, String string2, String string3, Writer writer, QDiffGenerator qDiffGenerator) {
        if (qDiffGenerator == null || writer == null) {
            throw new NullPointerException("null argument is not accepted by SVNDiffManager.generateDiff()");
        }
        qDiffGenerator.generateDiffHeader(string, string2, string3, writer);
    }

    public static void generateTextDiff(InputStream inputStream, InputStream inputStream2, String string, Writer writer, QDiffGenerator qDiffGenerator) {
        if (qDiffGenerator == null || inputStream == null || inputStream2 == null || writer == null) {
            throw new NullPointerException("null argument is not accepted by SVNDiffManager.generateDiff()");
        }
        if (string == null) {
            string = System.getProperty("file.encoding", "US-ASCII");
        }
        qDiffGenerator.generateTextDiff(inputStream, inputStream2, string, writer);
    }

    public static void generateTextDiff(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, String string, Writer writer, QDiffGenerator qDiffGenerator) {
        if (qDiffGenerator == null || writer == null) {
            throw new NullPointerException("null argument is not accepted by SVNDiffManager.generateDiff()");
        }
        if (string == null) {
            string = System.getProperty("file.encoding", "US-ASCII");
        }
        qDiffGenerator.generateTextDiff(randomAccessFile, randomAccessFile2, string, writer);
    }

    public static void generateTextDiff(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, OutputStream outputStream, QDiffGenerator qDiffGenerator) {
        if (qDiffGenerator == null || outputStream == null) {
            throw new NullPointerException("null argument is not accepted by SVNDiffManager.generateDiff()");
        }
        qDiffGenerator.generateTextDiff(randomAccessFile, randomAccessFile2, outputStream);
    }

    public static void generateBinaryDiff(InputStream inputStream, InputStream inputStream2, String string, Writer writer, QDiffGenerator qDiffGenerator) {
        if (qDiffGenerator == null || inputStream == null || inputStream2 == null || writer == null) {
            throw new NullPointerException("null argument is not accepted by SVNDiffManager.generateDiff()");
        }
        if (string == null) {
            string = System.getProperty("file.encoding", "US-ASCII");
        }
        qDiffGenerator.generateBinaryDiff(inputStream, inputStream2, string, writer);
    }

    public static void registerDiffGeneratorFactory(QDiffGeneratorFactory qDiffGeneratorFactory, String string) {
        if (qDiffGeneratorFactory == null || string == null) {
            return;
        }
        if (ourDiffGeneratorFactories != null && ourDiffGeneratorFactories.containsKey(string)) {
            return;
        }
        if (ourDiffGeneratorFactories == null) {
            ourDiffGeneratorFactories = new HashMap();
        }
        ourDiffGeneratorFactories.put(string, qDiffGeneratorFactory);
    }

    private QDiffManager() {
    }
}

