/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line;

import de.regnis.q.sequence.QSequenceDifference;
import de.regnis.q.sequence.QSequenceDifferenceBlockShifter;
import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceDummyCanceller;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineFileSystemCache;
import de.regnis.q.sequence.line.QSequenceLineMemoryCache;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import de.regnis.q.sequence.line.QSequenceLineSystemTempDirectoryFactory;
import de.regnis.q.sequence.line.QSequenceLineTempDirectoryFactory;
import de.regnis.q.sequence.line.simplifier.QSequenceLineDummySimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import de.regnis.q.sequence.media.QSequenceCachableMedia;
import de.regnis.q.sequence.media.QSequenceCachingMedia;
import de.regnis.q.sequence.media.QSequenceDiscardingMedia;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaNoConfusionDectector;
import de.regnis.q.sequence.media.QSequenceMediaComparer;
import de.regnis.q.sequence.media.QSequenceMediaDummyIndexTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class QSequenceLineMedia
implements QSequenceCachableMedia,
QSequenceMediaComparer {
    public static final int FILE_SEGMENT_SIZE = 16384;
    public static final int SEGMENT_ENTRY_SIZE = 16;
    public static final int MEMORY_THRESHOLD = QSequenceLineMedia.parseMemoryTreshold(System.getProperty("q.sequence.memory-threshold", "1M"));
    public static final double SEARCH_DEPTH_EXPONENT = System.getProperty("q.sequence.search-depth-exponent") != null ? Math.max(0.1, Math.min(1.0, Double.parseDouble(System.getProperty("q.sequence.search-depth-exponent")))) : 0.5;
    private final QSequenceLineCache leftCache;
    private final QSequenceLineCache rightCache;

    public static QSequenceLineCache readLines(QSequenceLineRAData qSequenceLineRAData) {
        if (qSequenceLineRAData.length() <= (long)MEMORY_THRESHOLD) {
            InputStream inputStream = qSequenceLineRAData.read(0L, qSequenceLineRAData.length());
            try {
                QSequenceLineMemoryCache qSequenceLineMemoryCache = QSequenceLineMemoryCache.read(inputStream, new QSequenceLineDummySimplifier());
                return qSequenceLineMemoryCache;
            }
            finally {
                inputStream.close();
            }
        }
        return QSequenceLineFileSystemCache.create(qSequenceLineRAData, new QSequenceLineSystemTempDirectoryFactory(), MEMORY_THRESHOLD, 16384, new QSequenceLineDummySimplifier());
    }

    public static QSequenceLineResult createBlocks(QSequenceLineRAData qSequenceLineRAData, QSequenceLineRAData qSequenceLineRAData2) {
        return QSequenceLineMedia.createBlocks(qSequenceLineRAData, qSequenceLineRAData2, new QSequenceLineDummySimplifier());
    }

    public static QSequenceLineResult createBlocks(QSequenceLineRAData qSequenceLineRAData, QSequenceLineRAData qSequenceLineRAData2, QSequenceLineSimplifier qSequenceLineSimplifier) {
        return QSequenceLineMedia.createBlocks(qSequenceLineRAData, qSequenceLineRAData2, MEMORY_THRESHOLD, 16384, SEARCH_DEPTH_EXPONENT, new QSequenceLineSystemTempDirectoryFactory(), qSequenceLineSimplifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QSequenceLineResult createBlocks(QSequenceLineRAData qSequenceLineRAData, QSequenceLineRAData qSequenceLineRAData2, int n2, int n3, double d2, QSequenceLineTempDirectoryFactory qSequenceLineTempDirectoryFactory, QSequenceLineSimplifier qSequenceLineSimplifier) {
        if (qSequenceLineRAData.length() <= (long)n2 && qSequenceLineRAData2.length() <= (long)n2) {
            InputStream inputStream = qSequenceLineRAData.read(0L, qSequenceLineRAData.length());
            InputStream inputStream2 = qSequenceLineRAData2.read(0L, qSequenceLineRAData2.length());
            try {
                QSequenceLineResult qSequenceLineResult = QSequenceLineMedia.createBlocksInMemory(inputStream, inputStream2, d2, qSequenceLineSimplifier);
                return qSequenceLineResult;
            }
            finally {
                inputStream.close();
                inputStream2.close();
            }
        }
        return QSequenceLineMedia.createBlocksInFilesystem(qSequenceLineRAData, qSequenceLineRAData2, qSequenceLineTempDirectoryFactory, d2, n2, n3, qSequenceLineSimplifier);
    }

    static QSequenceLineResult createBlocksInMemory(InputStream inputStream, InputStream inputStream2, double d2, QSequenceLineSimplifier qSequenceLineSimplifier) {
        QSequenceLineMemoryCache qSequenceLineMemoryCache = QSequenceLineMemoryCache.read(inputStream, qSequenceLineSimplifier);
        QSequenceLineMemoryCache qSequenceLineMemoryCache2 = QSequenceLineMemoryCache.read(inputStream2, qSequenceLineSimplifier);
        QSequenceLineMedia qSequenceLineMedia = new QSequenceLineMedia(qSequenceLineMemoryCache, qSequenceLineMemoryCache2);
        QSequenceCachingMedia qSequenceCachingMedia = new QSequenceCachingMedia(qSequenceLineMedia, new QSequenceDummyCanceller());
        QSequenceDiscardingMedia qSequenceDiscardingMedia = new QSequenceDiscardingMedia(qSequenceCachingMedia, new QSequenceDiscardingMediaNoConfusionDectector(true), new QSequenceDummyCanceller());
        List list = new QSequenceDifference(qSequenceDiscardingMedia, qSequenceDiscardingMedia, QSequenceLineMedia.getSearchDepth(qSequenceLineMedia, d2)).getBlocks();
        new QSequenceDifferenceBlockShifter(qSequenceCachingMedia, qSequenceCachingMedia).shiftBlocks(list);
        return new QSequenceLineResult(list, qSequenceLineMemoryCache, qSequenceLineMemoryCache2);
    }

    static QSequenceLineResult createBlocksInFilesystem(QSequenceLineRAData qSequenceLineRAData, QSequenceLineRAData qSequenceLineRAData2, QSequenceLineTempDirectoryFactory qSequenceLineTempDirectoryFactory, double d2, int n2, int n3, QSequenceLineSimplifier qSequenceLineSimplifier) {
        QSequenceLineFileSystemCache qSequenceLineFileSystemCache = QSequenceLineFileSystemCache.create(qSequenceLineRAData, qSequenceLineTempDirectoryFactory, n2, n3, qSequenceLineSimplifier);
        QSequenceLineFileSystemCache qSequenceLineFileSystemCache2 = QSequenceLineFileSystemCache.create(qSequenceLineRAData2, qSequenceLineTempDirectoryFactory, n2, n3, qSequenceLineSimplifier);
        QSequenceLineMedia qSequenceLineMedia = new QSequenceLineMedia(qSequenceLineFileSystemCache, qSequenceLineFileSystemCache2);
        List list = new QSequenceDifference(qSequenceLineMedia, new QSequenceMediaDummyIndexTransformer(qSequenceLineMedia), QSequenceLineMedia.getSearchDepth(qSequenceLineMedia, d2)).getBlocks();
        new QSequenceDifferenceBlockShifter(qSequenceLineMedia, qSequenceLineMedia).shiftBlocks(list);
        return new QSequenceLineResult(list, qSequenceLineFileSystemCache, qSequenceLineFileSystemCache2);
    }

    public QSequenceLineMedia(QSequenceLineCache qSequenceLineCache, QSequenceLineCache qSequenceLineCache2) {
        this.leftCache = qSequenceLineCache;
        this.rightCache = qSequenceLineCache2;
    }

    public int getLeftLength() {
        return this.leftCache.getLineCount();
    }

    public int getRightLength() {
        return this.rightCache.getLineCount();
    }

    public Object getMediaLeftObject(int n2) {
        try {
            return this.leftCache.getLine(n2);
        }
        catch (IOException iOException) {
            throw new QSequenceException(iOException);
        }
    }

    public Object getMediaRightObject(int n2) {
        try {
            return this.rightCache.getLine(n2);
        }
        catch (IOException iOException) {
            throw new QSequenceException(iOException);
        }
    }

    public boolean equals(int n2, int n3) {
        try {
            int n4 = this.leftCache.getLineHash(n2);
            int n5 = this.rightCache.getLineHash(n3);
            if (n4 != 0 && n5 != 0 && n4 != n5) {
                return false;
            }
            return this.leftCache.getLine(n2).equals(this.rightCache.getLine(n3));
        }
        catch (IOException iOException) {
            throw new QSequenceException(iOException);
        }
    }

    public boolean equalsLeft(int n2, int n3) {
        try {
            return this.leftCache.getLine(n2).equals(this.leftCache.getLine(n3));
        }
        catch (IOException iOException) {
            throw new QSequenceException(iOException);
        }
    }

    public boolean equalsRight(int n2, int n3) {
        try {
            return this.rightCache.getLine(n2).equals(this.rightCache.getLine(n3));
        }
        catch (IOException iOException) {
            throw new QSequenceException(iOException);
        }
    }

    private static int getSearchDepth(QSequenceLineMedia qSequenceLineMedia, double d2) {
        QSequenceAssert.assertTrue(d2 >= 0.0 && d2 <= 1.0);
        if (d2 == 1.0) {
            return Integer.MAX_VALUE;
        }
        return Math.max(256, (int)Math.pow(qSequenceLineMedia.getLeftLength() + qSequenceLineMedia.getRightLength(), d2));
    }

    private static int parseMemoryTreshold(String string) {
        if (string == null) {
            string = "1M";
        }
        string = string.toLowerCase();
        int n2 = 1;
        if (string.endsWith("m")) {
            string = string.substring(0, string.length() - 1);
            n2 = 0x100000;
        } else if (string.endsWith("mb")) {
            string = string.substring(0, string.length() - 2);
            n2 = 0x100000;
        } else if (string.endsWith("k")) {
            string = string.substring(0, string.length() - 1);
            n2 = 1024;
        } else if (string.endsWith("kb")) {
            string = string.substring(0, string.length() - 2);
            n2 = 1024;
        }
        try {
            int n3 = Integer.parseInt(string);
            n3 = n2 * n3;
            if (n3 < 16384) {
                n3 = 16384;
            }
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return QSequenceLineMedia.parseMemoryTreshold(null);
        }
    }
}

