/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line;

import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.line.QSequenceLineFileSystemCacheSegment;
import de.regnis.q.sequence.line.QSequenceLineRandomAccessFileFactory;
import de.regnis.q.sequence.line.QSequenceLineTempDirectoryFactory;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

class QSequenceLineFileSystemCacheSegments {
    private final QSequenceLineTempDirectoryFactory tempDirectoryFactory;
    private final int maximumEntriesPerSegment;
    private final int maximumSegmentsInMemory;
    private final List segments;
    private final List memorySegments;
    private File filePath;
    private RandomAccessFile file;

    public QSequenceLineFileSystemCacheSegments(QSequenceLineTempDirectoryFactory qSequenceLineTempDirectoryFactory, int n2, int n3) {
        QSequenceAssert.assertTrue(n3 >= 16);
        QSequenceAssert.assertTrue(n2 >= n3);
        this.tempDirectoryFactory = qSequenceLineTempDirectoryFactory;
        this.maximumEntriesPerSegment = n3 / 16;
        this.maximumSegmentsInMemory = n2 / (this.maximumEntriesPerSegment * 16);
        this.segments = new ArrayList();
        this.memorySegments = new LinkedList();
        QSequenceLineFileSystemCacheSegment qSequenceLineFileSystemCacheSegment = new QSequenceLineFileSystemCacheSegment(0L, this.maximumEntriesPerSegment);
        this.segments.add(qSequenceLineFileSystemCacheSegment);
        this.memorySegments.add(qSequenceLineFileSystemCacheSegment);
    }

    public long getFrom(int n2) {
        int n3 = n2 / this.maximumEntriesPerSegment;
        int n4 = n2 % this.maximumEntriesPerSegment;
        return this.getSegment(n3).getFrom(n4);
    }

    public int getLength(int n2) {
        int n3 = n2 / this.maximumEntriesPerSegment;
        int n4 = n2 % this.maximumEntriesPerSegment;
        return this.getSegment(n3).getLength(n4);
    }

    public int getHash(int n2) {
        int n3 = n2 / this.maximumEntriesPerSegment;
        int n4 = n2 % this.maximumEntriesPerSegment;
        return this.getSegment(n3).getHash(n4);
    }

    public void setFromLengthHash(int n2, long l2, int n3, int n4) {
        int n5 = n2 / this.maximumEntriesPerSegment;
        int n6 = n2 % this.maximumEntriesPerSegment;
        QSequenceLineFileSystemCacheSegment qSequenceLineFileSystemCacheSegment = this.getSegment(n5);
        qSequenceLineFileSystemCacheSegment.setFromLengthHash(n6, l2, n3, n4);
    }

    public void close() {
        if (this.file == null) {
            return;
        }
        this.file.close();
        this.filePath.delete();
        this.tempDirectoryFactory.close();
    }

    private QSequenceLineFileSystemCacheSegment getSegment(int n2) {
        if (n2 >= this.segments.size()) {
            QSequenceLineFileSystemCacheSegment qSequenceLineFileSystemCacheSegment = new QSequenceLineFileSystemCacheSegment(n2, this.maximumEntriesPerSegment);
            this.segments.add(qSequenceLineFileSystemCacheSegment);
            this.memorySegments.add(0, qSequenceLineFileSystemCacheSegment);
            this.maybeUnloadSegments();
            return qSequenceLineFileSystemCacheSegment;
        }
        QSequenceLineFileSystemCacheSegment qSequenceLineFileSystemCacheSegment = (QSequenceLineFileSystemCacheSegment)this.segments.get(n2);
        if (!qSequenceLineFileSystemCacheSegment.isLoaded()) {
            qSequenceLineFileSystemCacheSegment.load(this.getFile());
            this.memorySegments.add(0, qSequenceLineFileSystemCacheSegment);
            this.maybeUnloadSegments();
        }
        return qSequenceLineFileSystemCacheSegment;
    }

    private void maybeUnloadSegments() {
        while (this.memorySegments.size() > this.maximumSegmentsInMemory) {
            QSequenceLineFileSystemCacheSegment qSequenceLineFileSystemCacheSegment = (QSequenceLineFileSystemCacheSegment)this.memorySegments.remove(this.memorySegments.size() - 1);
            qSequenceLineFileSystemCacheSegment.unload(this.getFile());
        }
    }

    private RandomAccessFile getFile() {
        if (this.file == null) {
            File file = this.tempDirectoryFactory.getTempDirectory();
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            this.filePath = File.createTempFile("sequence", null, file);
            this.file = QSequenceLineRandomAccessFileFactory.createRandomAccessFile(this.filePath, "rw");
        }
        return this.file;
    }
}

