/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line;

import de.regnis.q.sequence.core.QSequenceAssert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.RandomAccessFile;

class QSequenceLineFileSystemCacheSegment {
    private final long segmentIndex;
    private final int maximumEntryCount;
    private long[] froms;
    private int[] lengths;
    private int[] hashes;

    public QSequenceLineFileSystemCacheSegment(long l2, int n2) {
        this.segmentIndex = l2;
        this.maximumEntryCount = n2;
        this.froms = new long[n2];
        this.lengths = new int[n2];
        this.hashes = new int[n2];
    }

    public boolean isLoaded() {
        return this.froms != null;
    }

    public long getFrom(int n2) {
        return this.froms[n2];
    }

    public int getLength(int n2) {
        return this.lengths[n2];
    }

    public int getHash(int n2) {
        return this.hashes[n2];
    }

    public void setFromLengthHash(int n2, long l2, int n3, int n4) {
        this.froms[n2] = l2;
        this.lengths[n2] = n3;
        this.hashes[n2] = n4;
    }

    public void load(RandomAccessFile randomAccessFile) {
        this.froms = new long[this.maximumEntryCount];
        this.lengths = new int[this.maximumEntryCount];
        this.hashes = new int[this.maximumEntryCount];
        byte[] byArray = new byte[this.maximumEntryCount * 16];
        randomAccessFile.seek(this.segmentIndex * (long)this.maximumEntryCount * 16L);
        randomAccessFile.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        for (int i2 = 0; i2 < this.maximumEntryCount; ++i2) {
            this.froms[i2] = dataInputStream.readLong();
            this.lengths[i2] = dataInputStream.readInt();
            this.hashes[i2] = dataInputStream.readInt();
        }
    }

    public void unload(RandomAccessFile randomAccessFile) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.maximumEntryCount * 16);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (int i2 = 0; i2 < this.maximumEntryCount; ++i2) {
            dataOutputStream.writeLong(this.froms[i2]);
            dataOutputStream.writeInt(this.lengths[i2]);
            dataOutputStream.writeInt(this.hashes[i2]);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        QSequenceAssert.assertEquals(this.maximumEntryCount * 16, byArray.length);
        long l2 = this.segmentIndex * (long)this.maximumEntryCount * 16L;
        randomAccessFile.seek(l2);
        randomAccessFile.write(byArray);
        this.froms = null;
        this.lengths = null;
        this.hashes = null;
    }
}

