/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line;

import de.regnis.q.sequence.line.QSequenceLine;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineFileSystemCacheSegments;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineReader;
import de.regnis.q.sequence.line.QSequenceLineTempDirectoryFactory;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import java.io.IOException;
import java.io.InputStream;

final class QSequenceLineFileSystemCache
implements QSequenceLineCache {
    private final QSequenceLineRAData data;
    private final QSequenceLineSimplifier simplifier;
    private final QSequenceLineFileSystemCacheSegments segments;
    private int lineCount;

    public static QSequenceLineFileSystemCache create(QSequenceLineRAData qSequenceLineRAData, QSequenceLineTempDirectoryFactory qSequenceLineTempDirectoryFactory, int n2, int n3, QSequenceLineSimplifier qSequenceLineSimplifier) {
        QSequenceLineFileSystemCache qSequenceLineFileSystemCache = new QSequenceLineFileSystemCache(qSequenceLineRAData, qSequenceLineTempDirectoryFactory, n2, n3, qSequenceLineSimplifier);
        QSequenceLineReader qSequenceLineReader = new QSequenceLineReader();
        InputStream inputStream = qSequenceLineRAData.read(0L, qSequenceLineRAData.length());
        qSequenceLineReader.read(inputStream, qSequenceLineFileSystemCache, qSequenceLineSimplifier);
        inputStream.close();
        return qSequenceLineFileSystemCache;
    }

    private QSequenceLineFileSystemCache(QSequenceLineRAData qSequenceLineRAData, QSequenceLineTempDirectoryFactory qSequenceLineTempDirectoryFactory, int n2, int n3, QSequenceLineSimplifier qSequenceLineSimplifier) {
        this.data = qSequenceLineRAData;
        this.simplifier = qSequenceLineSimplifier;
        this.segments = new QSequenceLineFileSystemCacheSegments(qSequenceLineTempDirectoryFactory, n2, n3);
    }

    public void close() {
        this.segments.close();
    }

    public void addLine(QSequenceLine qSequenceLine) {
        if (this.lineCount >= Integer.MAX_VALUE) {
            throw new IOException("Too many lines.");
        }
        this.segments.setFromLengthHash(this.lineCount, qSequenceLine.getFrom(), qSequenceLine.getContentLength(), qSequenceLine.getCompareHash());
        ++this.lineCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public QSequenceLine getLine(int n2) {
        long l2 = this.segments.getFrom(n2);
        int n3 = this.segments.getLength(n2);
        byte[] byArray = new byte[n3];
        this.data.get(byArray, l2, n3);
        return new QSequenceLine(l2, byArray, this.simplifier);
    }

    public int getLineHash(int n2) {
        return this.segments.getHash(n2);
    }
}

