/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line;

import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;

public final class QSequenceLine {
    private final long from;
    private final byte[] contentBytes;
    private final byte[] compareBytes;

    public QSequenceLine(long l2, byte[] byArray, QSequenceLineSimplifier qSequenceLineSimplifier) {
        this.from = l2;
        this.contentBytes = byArray;
        this.compareBytes = qSequenceLineSimplifier.simplify(byArray);
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.from + (long)this.contentBytes.length - 1L;
    }

    public int getContentLength() {
        return this.contentBytes.length;
    }

    public byte[] getContentBytes() {
        return this.contentBytes;
    }

    public byte[] getBytes() {
        return this.getContentBytes();
    }

    public int getCompareHash() {
        return new String(this.compareBytes).hashCode();
    }

    public boolean equals(Object object) {
        byte[] byArray = ((QSequenceLine)object).compareBytes;
        if (this.compareBytes.length != byArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.compareBytes.length; ++i2) {
            if (this.compareBytes[i2] == byArray[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.compareBytes.length; ++i2) {
            n2 = 31 * n2 + this.compareBytes[i2];
        }
        return n2;
    }

    public String toString() {
        return new String(this.contentBytes);
    }
}

